package com.ejianc.business.sub.service.impl;

import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 分包合同审批流服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("contract")
public class ContractBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IContractService contractService;

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        //合同是否被其他单据引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            //上级的集采合同不允许被撤回
            ContractEntity contractEntity = contractService.selectById(billId);
            Long conorgid = contractEntity.getPurchaseOrgId();//合同组织主键
            CommonResponse<OrgVO> conResp =  orgApi.getOneById(conorgid);
            if(!conResp.isSuccess() || !conResp.isSuccess()) {
                return CommonResponse.error("查询合同组织信息失败！");
            }
            Long currentOrg = InvocationInfoProxy.getOrgId();
            String innerCode = conResp.getData().getInnerCode();
            if(("2".equals(contractEntity.getPurchaseType()) || ("1".equals(contractEntity.getPurchaseType()) && "1".equals(contractEntity.getReplaceSignFlag())))
                    &&!innerCode.contains(String.valueOf(currentOrg))){
                //说明-A组织innerCode包含了B主键，说明B是A的上级
                return CommonResponse.error("当前合同编制组织是【"+contractEntity.getPurchaseOrgName()+"】，不可撤回！");
            }
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }


}
