/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.WorkerPresentDetailEntity;
import com.ejianc.business.sub.bean.WorkerPresentEntity;
import com.ejianc.business.sub.service.IWorkerPresentService;
import com.ejianc.business.sub.vo.WorkerPresentDetailVO;
import com.ejianc.business.sub.vo.WorkerPresentVO;
import com.ejianc.business.utils.ExcelReader;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"workerPresent"})
public class WorkerPresentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "WORKER_PRESENT";
    @Autowired
    private IWorkerPresentService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDefdocApi defdocApi;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkerPresentVO> saveOrUpdate(@RequestBody WorkerPresentVO saveOrUpdateVO) {
        WorkerPresentEntity entity = (WorkerPresentEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WorkerPresentEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            WorkerPresentVO checkVo;
            if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                entity.setBillCode((String)billCode.getData());
            } else {
                WorkerPresentVO voByCode = this.service.checkCode(saveOrUpdateVO.getBillCode());
                if (!(null == voByCode || null != saveOrUpdateVO.getId() && voByCode.getId().equals(saveOrUpdateVO.getId()))) {
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
                }
            }
            if (!(null == (checkVo = this.service.checkWorkerPresent(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getSupplierId(), saveOrUpdateVO.getContractId())) || null != saveOrUpdateVO.getId() && checkVo.getId().equals(saveOrUpdateVO.getId()))) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u5408\u540c\u4e0b\u5206\u5305\u5355\u4f4d\u5df2\u5b58\u5728\u7edf\u8ba1\u8868\uff0c\u8bf7\u66f4\u6362\u5408\u540c\u6216\u8005\u5206\u5305\u5355\u4f4d\uff01");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        WorkerPresentVO vo = (WorkerPresentVO)BeanMapper.map((Object)((Object)entity), WorkerPresentVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkerPresentVO> queryDetail(Long id) {
        WorkerPresentEntity entity = (WorkerPresentEntity)((Object)this.service.selectById(id));
        WorkerPresentVO vo = (WorkerPresentVO)BeanMapper.map((Object)((Object)entity), WorkerPresentVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkerPresentVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WorkerPresentVO workerPresentVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkerPresentVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkerPresentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("workerPresent-export.xlsx", beans, response);
    }

    @PostMapping(value={"excelDetailExport"})
    public void excelDetailExport(@RequestBody WorkerPresentVO workerPresentVO, HttpServletResponse response) {
        WorkerPresentEntity entity = (WorkerPresentEntity)((Object)this.service.selectById(workerPresentVO.getId()));
        HashMap beans = new HashMap();
        ArrayList list = new ArrayList();
        List<WorkerPresentDetailEntity> workerPresentDetailList = entity.getWorkerPresentDetailList();
        if (CollectionUtils.isNotEmpty(workerPresentDetailList)) {
            workerPresentDetailList.forEach(item -> {
                WorkerPresentDetailVO vo = (WorkerPresentDetailVO)BeanMapper.map((Object)item, WorkerPresentDetailVO.class);
                CommonResponse defList = this.defdocApi.getDefDocByDefCode("worker-present-type");
                Map<String, String> defMap = this.getDefMapByCode((List)defList.getData());
                vo.setWorkTypeName(defMap.get(vo.getWorkType() + ""));
                if (vo.getPresentFlag().booleanValue()) {
                    vo.setPresentFlagStr("\u662f");
                } else {
                    vo.setPresentFlagStr("\u5426");
                }
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("workerPresent-detail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"workerPresent-import.xlsx", (String)"\u5de5\u4eba\u5728\u573a\u7edf\u8ba1\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<WorkerPresentDetailVO> successList = new ArrayList<WorkerPresentDetailVO>();
        ArrayList<WorkerPresentDetailVO> errorList = new ArrayList<WorkerPresentDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 10) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 1; i < result.size(); ++i) {
                Date date;
                String time;
                SimpleDateFormat ft;
                List datas = (List)result.get(i);
                WorkerPresentDetailVO workerPresentDetailVO = new WorkerPresentDetailVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    workerPresentDetailVO.setErrorMessage("\u5de5\u4eba\u59d3\u540d\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(0)).length() > 20) {
                    workerPresentDetailVO.setErrorMessage("\u7269\u8d44\u5206\u7c7b\u586b\u5199\u957f\u5ea6\u4e3a2~20\u5b57");
                } else {
                    workerPresentDetailVO.setWorkerName((String)datas.get(0));
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    workerPresentDetailVO.setErrorMessage("\u5de5\u79cd\u4e3a\u5fc5\u586b\u9879");
                } else {
                    String workTypeName;
                    CommonResponse defList = this.defdocApi.getDefDocByDefCode("worker-present-type");
                    Map<String, String> defMap = this.getDefMapByName((List)defList.getData());
                    if (defMap.containsKey((workTypeName = (String)datas.get(1)).trim())) {
                        workerPresentDetailVO.setWorkType(Long.valueOf(defMap.get(workTypeName)));
                        workerPresentDetailVO.setWorkTypeName(workTypeName.trim());
                    }
                }
                workerPresentDetailVO.setPhone((String)datas.get(2));
                workerPresentDetailVO.setIdCard((String)datas.get(3));
                workerPresentDetailVO.setBankAccount((String)datas.get(4));
                if (workerPresentDetailVO.getPhone().indexOf(".") != -1) {
                    String phone = workerPresentDetailVO.getPhone();
                    phone = phone.substring(0, phone.indexOf("."));
                    workerPresentDetailVO.setPhone(phone);
                }
                if (workerPresentDetailVO.getIdCard().indexOf(".") != -1) {
                    String idCard = workerPresentDetailVO.getIdCard();
                    idCard = idCard.substring(0, idCard.indexOf("."));
                    workerPresentDetailVO.setIdCard(idCard);
                }
                if (workerPresentDetailVO.getBankAccount().indexOf(".") != -1) {
                    String bankAccount = workerPresentDetailVO.getBankAccount();
                    bankAccount = bankAccount.substring(0, bankAccount.indexOf("."));
                    workerPresentDetailVO.setBankAccount(bankAccount);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    workerPresentDetailVO.setErrorMessage("\u8fdb\u573a\u65e5\u671f\u4e3a\u5fc5\u586b\u9879");
                } else {
                    try {
                        ft = new SimpleDateFormat("yyyy-MM-dd");
                        time = (String)datas.get(5);
                        date = ft.parse(time);
                        workerPresentDetailVO.setEnterDate(date);
                    }
                    catch (Exception e) {
                        workerPresentDetailVO.setErrorMessage("\u8fdb\u573a\u65e5\u671f\u683c\u5f0f\u6709\u8bef\uff0c\u4f8b\u59822022-01-01");
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    workerPresentDetailVO.setErrorMessage("\u662f\u5426\u5728\u573a\u4e3a\u5fc5\u586b\u9879");
                } else if ("\u662f".equals(datas.get(6))) {
                    workerPresentDetailVO.setPresentFlag(Boolean.valueOf(true));
                } else {
                    workerPresentDetailVO.setPresentFlag(Boolean.valueOf(false));
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    workerPresentDetailVO.setErrorMessage("\u79bb\u573a\u65e5\u671f\u4e3a\u5fc5\u586b\u9879");
                } else {
                    try {
                        ft = new SimpleDateFormat("yyyy-MM-dd");
                        time = (String)datas.get(7);
                        date = ft.parse(time);
                        workerPresentDetailVO.setDepartureDate(date);
                    }
                    catch (Exception e) {
                        workerPresentDetailVO.setErrorMessage("\u79bb\u573a\u65e5\u671f\u683c\u5f0f\u6709\u8bef\uff0c\u4f8b\u59822022-01-01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) && ((String)datas.get(9)).length() > 50) {
                    workerPresentDetailVO.setErrorMessage("\u5907\u6ce8\u586b\u5199\u957f\u5ea6\u4e3a0~50\u5b57");
                } else {
                    workerPresentDetailVO.setMemo((String)datas.get(9));
                }
                if (workerPresentDetailVO.getEnterDate() != null && workerPresentDetailVO.getDepartureDate() != null && workerPresentDetailVO.getDepartureDate().compareTo(workerPresentDetailVO.getEnterDate()) < 0) {
                    workerPresentDetailVO.setErrorMessage("\u79bb\u573a\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8fdb\u573a\u65e5\u671f");
                }
                if (StringUtils.isBlank((CharSequence)workerPresentDetailVO.getErrorMessage())) {
                    successList.add(workerPresentDetailVO);
                    Integer days = WorkerPresentController.daysBetween(workerPresentDetailVO.getEnterDate(), workerPresentDetailVO.getDepartureDate());
                    workerPresentDetailVO.setPresentDays(Integer.valueOf(days + 1));
                    continue;
                }
                errorList.add(workerPresentDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/refWorkerPresentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkerPresentVO>> refWorkerPresentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkerPresentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private static Integer daysBetween(Date one, Date two) {
        Long diff = (one.getTime() - two.getTime()) / 86400000L;
        long abs = Math.abs(diff);
        String date = String.valueOf(abs);
        return Integer.parseInt(date);
    }

    public Map<String, String> getDefMapByCode(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }

    public Map<String, String> getDefMapByName(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }
}

