/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.OddjobEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="oddjob")
public class OddjobBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOddjobService oddjobService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (res.isSuccess()) {
            OddjobEntity entity = (OddjobEntity)((Object)this.oddjobService.selectById(billId));
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (contractEntity.getFinishFlag().booleanValue()) {
                return CommonResponse.error((String)"\u5206\u5305\u5408\u540c\u5df2\u5b8c\u5de5\u7ed3\u7b97,\u96f6\u661f\u7528\u5de5\u4e0d\u5141\u8bb8\u64a4\u56de\u548c\u5f03\u5ba1");
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OddjobEntity oddjobEntity = (OddjobEntity)((Object)this.oddjobService.getById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(oddjobEntity.getContractId()));
        BigDecimal sumOddjobTaxMny = contractEntity.getSumOddjobTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobTaxMny();
        BigDecimal sumOddjobMny = contractEntity.getSumOddjobMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobMny();
        BigDecimal jobTaxMny = oddjobEntity.getJobTaxMny() == null ? BigDecimal.ZERO : oddjobEntity.getJobTaxMny();
        BigDecimal jobMny = oddjobEntity.getJobMny() == null ? BigDecimal.ZERO : oddjobEntity.getJobMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getSumOddjobTaxMny, (Object)sumOddjobTaxMny.add(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobMny, (Object)sumOddjobMny.add(jobMny));
        updateWrapper.eq(BaseEntity::getId, (Object)oddjobEntity.getContractId());
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OddjobEntity oddjobEntity = (OddjobEntity)((Object)this.oddjobService.getById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(oddjobEntity.getContractId()));
        BigDecimal sumOddjobTaxMny = contractEntity.getSumOddjobTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobTaxMny();
        BigDecimal sumOddjobMny = contractEntity.getSumOddjobMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobMny();
        BigDecimal jobTaxMny = oddjobEntity.getJobTaxMny() == null ? BigDecimal.ZERO : oddjobEntity.getJobTaxMny();
        BigDecimal jobMny = oddjobEntity.getJobMny() == null ? BigDecimal.ZERO : oddjobEntity.getJobMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getSumOddjobTaxMny, (Object)sumOddjobTaxMny.subtract(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobMny, (Object)sumOddjobMny.subtract(jobMny));
        updateWrapper.eq(BaseEntity::getId, (Object)oddjobEntity.getContractId());
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
        return CommonResponse.success((String)"\u64a4\u56de\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }
}

