/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class CommonUtils {
    public static final String defaultErrMsg = "\u63a8\u9001\u6570\u636e\u5931\u8d25\uff01";
    public static final String noPower = "\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u670d\u52a1\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01";
    public static final String TYPE_MATERIAL = "MATERIAL";
    public static final String TYPE_SUB = "SUB";
    public static final String TYPE_PURCHASE = "PURCHASE";
    public static final String TYPE_RENT = "RENT";
    public static final String TYPE_RMAT = "RMAT";
    public static final String TYPE_OTHER = "OTHER";

    private CommonUtils() {
    }

    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse) {
        return CommonUtils.checkCommonResponse(commonResponse, true, defaultErrMsg, null);
    }

    public static <T> void checkCommonResponse(CommonResponse<T> commonResponse, Logger logger) {
        CommonUtils.checkCommonResponse(commonResponse, true, defaultErrMsg, logger);
    }

    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse, boolean isThrow, String errMsg, Logger logger) {
        if (!commonResponse.isSuccess()) {
            if (logger != null) {
                logger.info("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u8c03\u7528\u7ed3\u679c\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.isSuccess(), (Object)commonResponse.getMsg());
            }
            if (isThrow) {
                throw new BusinessException(StringUtils.isNotEmpty((CharSequence)errMsg) ? errMsg : commonResponse.getMsg());
            }
            return false;
        }
        try {
            String dataString;
            Object data = commonResponse.getData();
            if (data instanceof String) {
                dataString = String.valueOf(data);
                if (noPower.equals(dataString)) {
                    throw new BusinessException(dataString);
                }
            } else {
                dataString = JSONObject.toJSONString((Object)data);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)dataString);
            if (StringUtils.isNotEmpty((CharSequence)dataString) && jsonObject.containsKey((Object)"code")) {
                CommonResponse check = (CommonResponse)JSONObject.toJavaObject((JSON)jsonObject, CommonResponse.class);
                if (isThrow && !check.isSuccess()) {
                    if (logger != null) {
                        logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)check.getMsg());
                    }
                    throw new BusinessException(StringUtils.isNotEmpty((CharSequence)errMsg) ? errMsg : check.getMsg());
                }
                return check.isSuccess();
            }
            throw new BusinessException(defaultErrMsg);
        }
        catch (BusinessException be) {
            if (logger != null) {
                logger.error(be.getErrorMsg());
            }
            throw be;
        }
        catch (Exception e) {
            if (logger != null) {
                logger.error("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff01\u8fd4\u56de\u7ed3\u679c\u4e0d\u662fjson\u6216CommonResponse", (Throwable)e);
            }
            if (isThrow) {
                throw new BusinessException(defaultErrMsg);
            }
            return true;
        }
    }

    public static String getTypeName(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        switch (type) {
            case "MATERIAL": {
                return "\u6750\u6599\u62db\u6807";
            }
            case "SUB": {
                return "\u5206\u5305\u62db\u6807";
            }
            case "PURCHASE": {
                return "\u8bbe\u5907\u91c7\u8d2d\u62db\u6807";
            }
            case "RENT": {
                return "\u8bbe\u5907\u79df\u8d41\u62db\u6807";
            }
            case "RMAT": {
                return "\u5468\u8f6c\u6750\u79df\u8d41\u62db\u6807";
            }
            case "OTHER": {
                return "\u5176\u4ed6\u62db\u6807";
            }
        }
        return null;
    }
}

