/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

public class SupbidFileUtils {
    private SupbidFileUtils() {
    }

    public static AttachmentVO upFile(String sourceType, String sourceId, String billType, MultipartFile file, HttpServletRequest request, String baseHost, Logger logger) {
        String authority = InvocationInfoProxy.getExtendAttribute((String)"authority").toString();
        logger.info("\u83b7\u53d6\u8ba4\u8bc1\u4fe1\u606f--" + authority);
        if (null != authority) {
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sourceType", sourceType);
            params.put("sourceId", sourceId);
            params.put("billType", billType);
            params.put("originalFileNameStr", file.getOriginalFilename());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", authority);
            AttachmentVO attachmentVO = null;
            try {
                String fileUploadRespStr = SupbidFileUtils.postFile(baseHost + "ejc-file-web/attachment/upload", params, headers, file.getInputStream(), file.getOriginalFilename());
                logger.info("\u6a21\u677f\u6587\u4ef6\u4fe1\u606f--" + fileUploadRespStr);
                CommonResponse attachmentResp = (CommonResponse)JSONObject.parseObject((String)fileUploadRespStr, CommonResponse.class);
                logger.info("\u4e0a\u4f20\u6587\u4ef6\u8fd4\u56de\u4fe1\u606f--" + attachmentResp);
                if (!attachmentResp.isSuccess()) {
                    logger.error("\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, \u539f\u56e0\uff1a{}", new Object[]{sourceId, sourceType, billType, file.getOriginalFilename(), attachmentResp.getMsg()});
                    return null;
                }
                attachmentVO = (AttachmentVO)JSONObject.parseObject((String)JSONObject.toJSONString(((List)attachmentResp.getData()).get(0)), AttachmentVO.class);
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, \u539f\u56e0\uff1a{}", new Object[]{sourceId, sourceType, billType, file.getOriginalFilename(), e.getMessage()});
                return null;
            }
            logger.info("\u6a21\u677f\u6587\u4ef6\u4fdd\u5b58\u6210\u529f\uff1a{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
            return attachmentVO;
        }
        return null;
    }

    public static AttachmentVO upFile2(String sourceType, String sourceId, String billType, MultipartFile file, String baseHost, Logger logger) {
        String authority = InvocationInfoProxy.getExtendAttribute((String)"authority").toString();
        logger.info("\u83b7\u53d6\u8ba4\u8bc1\u4fe1\u606f--" + authority);
        if (null != authority) {
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sourceType", sourceType);
            params.put("sourceId", sourceId);
            params.put("billType", billType);
            params.put("originalFileNameStr", file.getOriginalFilename());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", authority);
            AttachmentVO attachmentVO = null;
            try {
                String fileUploadRespStr = SupbidFileUtils.postFile(baseHost + "ejc-file-web/attachment/upload", params, headers, file.getInputStream(), file.getOriginalFilename());
                logger.info("\u6a21\u677f\u6587\u4ef6\u4fe1\u606f--" + fileUploadRespStr);
                CommonResponse attachmentResp = (CommonResponse)JSONObject.parseObject((String)fileUploadRespStr, CommonResponse.class);
                logger.info("\u4e0a\u4f20\u6587\u4ef6\u8fd4\u56de\u4fe1\u606f--" + attachmentResp);
                if (!attachmentResp.isSuccess()) {
                    logger.error("\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, \u539f\u56e0\uff1a{}", new Object[]{sourceId, sourceType, billType, file.getOriginalFilename(), attachmentResp.getMsg()});
                    return null;
                }
                attachmentVO = (AttachmentVO)JSONObject.parseObject((String)JSONObject.toJSONString(((List)attachmentResp.getData()).get(0)), AttachmentVO.class);
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, \u539f\u56e0\uff1a{}", new Object[]{sourceId, sourceType, billType, file.getOriginalFilename(), e.getMessage()});
                return null;
            }
            logger.info("\u6a21\u677f\u6587\u4ef6\u4fdd\u5b58\u6210\u529f\uff1a{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
            return attachmentVO;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, InputStream inputStream, String fileName) throws Exception {
        String charset = "UTF-8";
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        Integer readTimeout = 10000;
        try {
            HttpResponse res;
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("file", inputStream, ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), fileName);
            for (String key : params.keySet()) {
                builder.addPart(key, (ContentBody)new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key2 = null;
                for (String key2 : headers.keySet()) {
                    post.addHeader(key2, headers.get(key2));
                }
            } else {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
                res = client.execute((HttpUriRequest)post);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        post.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }
}

