/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.win.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.util.CommonUtils;
import com.ejianc.business.supbid.util.SupbidFileUtils;
import com.ejianc.business.supbid.win.bean.BidEntity;
import com.ejianc.business.supbid.win.mapper.BidMapper;
import com.ejianc.business.supbid.win.service.IBidService;
import com.ejianc.business.supbid.win.vo.BidVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="bidService")
public class BidServiceImpl
extends BaseServiceImpl<BidMapper, BidEntity>
implements IBidService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    private static final String BILL_TYPE = "BT220311000000001";
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public boolean saveBid(HttpServletRequest request, MultipartFile file) {
        this.logger.info("--------------\u8fdb\u5165\u4e2d\u6807\u901a\u77e5\u4e66\u63a5\u6536\u63a5\u53e3-------------------");
        this.logger.info("request--" + request);
        String bid = request.getParameter("transData");
        this.logger.info("bid\u5b9e\u4f53\u4fe1\u606f--" + bid);
        BidVO bidVO = (BidVO)JSON.parseObject((String)bid, (TypeReference)new TypeReference<BidVO>(){}, (Feature[])new Feature[0]);
        if (null == bidVO.getSystemId()) {
            throw new BusinessException("\u7cfb\u7edf\u6765\u6e90\u4e3a\u7a7a\uff01");
        }
        BidEntity bidEntity = (BidEntity)((Object)BeanMapper.map((Object)bidVO, BidEntity.class));
        if (file == null) {
            throw new BusinessException("\u4e2d\u6807\u901a\u77e5\u4e66\u4e3a\u7a7a\uff01");
        }
        super.saveOrUpdate((Object)bidEntity, false);
        this.logger.info(request + "\u6587\u4ef6\u6a21\u677f--" + file.getOriginalFilename());
        AttachmentVO attachmentVO = SupbidFileUtils.upFile("bidFiles", Long.toString(bidEntity.getId()), BILL_TYPE, file, request, this.BASE_HOST, this.logger);
        if (attachmentVO == null) {
            throw new BusinessException("\u4e2d\u6807\u901a\u77e5\u4e66\u4e0a\u4f20\u5931\u8d25\uff01");
        }
        bidEntity.setBidFileId(attachmentVO.getId());
        boolean flag = super.saveOrUpdate((Object)bidEntity, false);
        this.logger.info("--------------\u4e2d\u6807\u901a\u77e5\u4e66\u63a5\u6536\u63a5\u53e3\u7ed3\u675f-------------------");
        return flag;
    }

    @Override
    public boolean saveBid2(BidVO bidVO) {
        this.logger.info("--------------\u8fdb\u5165\u4e2d\u6807\u901a\u77e5\u4e66\u63a5\u6536\u63a5\u53e3-------------------");
        this.logger.info("bid\u5b9e\u4f53\u4fe1\u606f--" + bidVO);
        BidEntity bidEntity = (BidEntity)((Object)BeanMapper.map((Object)bidVO, BidEntity.class));
        boolean flag = super.saveOrUpdate((Object)bidEntity, false);
        this.logger.info("--------------\u4e2d\u6807\u901a\u77e5\u4e66\u63a5\u6536\u63a5\u53e3\u7ed3\u675f-------------------");
        return flag;
    }

    @Override
    public IPage<BidVO> queryBidList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bidTitle");
        fuzzyFields.add("unitName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("bidDate", "desc");
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List bidVOList = BeanMapper.mapList((Iterable)page.getRecords(), BidVO.class);
        for (BidVO bidVO : bidVOList) {
            bidVO.setTypeName(CommonUtils.getTypeName(bidVO.getType()));
        }
        pageData.setRecords(bidVOList);
        return pageData;
    }
}

