/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.winbid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.rmat.bean.RmatSchemeRepairEntity;
import com.ejianc.business.supbid.rmat.bean.RmatSchemeScrapEntity;
import com.ejianc.business.supbid.rmat.service.IRmatSchemeRepairService;
import com.ejianc.business.supbid.rmat.service.IRmatSchemeScrapService;
import com.ejianc.business.supbid.rmat.vo.RmatSchemeRepairVO;
import com.ejianc.business.supbid.rmat.vo.RmatSchemeScrapVO;
import com.ejianc.business.supbid.util.SendMsgUtils;
import com.ejianc.business.supbid.winbid.bean.OtherWinbidDetailEntity;
import com.ejianc.business.supbid.winbid.bean.PurchaseWinbidDetailEntity;
import com.ejianc.business.supbid.winbid.bean.RentWinbidDetailEntity;
import com.ejianc.business.supbid.winbid.bean.RmatWinbidDetailEntity;
import com.ejianc.business.supbid.winbid.bean.SubWinbidDetailEntity;
import com.ejianc.business.supbid.winbid.bean.WinbidContentEntity;
import com.ejianc.business.supbid.winbid.bean.WinbidDetailEntity;
import com.ejianc.business.supbid.winbid.bean.WinbidEntity;
import com.ejianc.business.supbid.winbid.mapper.WinbidMapper;
import com.ejianc.business.supbid.winbid.service.IOtherWinbidDetailService;
import com.ejianc.business.supbid.winbid.service.IPurchaseWinbidDetailService;
import com.ejianc.business.supbid.winbid.service.IRentWinbidDetailService;
import com.ejianc.business.supbid.winbid.service.IRmatWinbidDetailService;
import com.ejianc.business.supbid.winbid.service.ISubWinbidDetailService;
import com.ejianc.business.supbid.winbid.service.IWinbidContentService;
import com.ejianc.business.supbid.winbid.service.IWinbidDetailService;
import com.ejianc.business.supbid.winbid.service.IWinbidService;
import com.ejianc.business.supbid.winbid.vo.WinbidVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="winbidService")
public class WinbidServiceImpl
extends BaseServiceImpl<WinbidMapper, WinbidEntity>
implements IWinbidService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer PURCHASE_TYPE_1 = 1;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private ISignService signService;
    @Autowired
    private IWinbidDetailService winbidDetailService;
    @Autowired
    private ISubWinbidDetailService subWinbidDetailService;
    @Autowired
    private IPurchaseWinbidDetailService purchaseWinbidDetailService;
    @Autowired
    private IRentWinbidDetailService rentWinbidDetailService;
    @Autowired
    private IRmatWinbidDetailService rmatWinbidDetailService;
    @Autowired
    private IOtherWinbidDetailService otherWinbidDetailService;
    @Autowired
    private IWinbidContentService winbidContentService;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private IRmatSchemeRepairService rmatSchemeRepairService;
    @Autowired
    private IRmatSchemeScrapService rmatSchemeScrapService;

    @Override
    public WinbidVO queryWinbidDetail(String sourceId) {
        List list = super.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(WinbidEntity::getSourceId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            WinbidContentEntity winbidContentEntity;
            List noticeEntities;
            WinbidEntity winbidEntity = (WinbidEntity)((Object)list.get(0));
            if ("MATERIAL".equals(winbidEntity.getType())) {
                List winbidEntityList = this.winbidDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(WinbidDetailEntity::getSourceId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
                winbidEntity.setWinbidDetailList(winbidEntityList);
            } else if ("SUB".equals(winbidEntity.getType())) {
                List subWinbidDetailEntityList = this.subWinbidDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SubWinbidDetailEntity::getSourceId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
                winbidEntity.setSubWinbidDetailList(subWinbidDetailEntityList);
            } else if ("PURCHASE".equals(winbidEntity.getType())) {
                List purchaseWinbidDetailEntityList = this.purchaseWinbidDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseWinbidDetailEntity::getSourceId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
                winbidEntity.setPurchaseWinbidDetailList(purchaseWinbidDetailEntityList);
            } else if ("RENT".equals(winbidEntity.getType())) {
                List rentWinbidDetailEntityList = this.rentWinbidDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RentWinbidDetailEntity::getSourceId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
                winbidEntity.setRentWinbidDetailList(rentWinbidDetailEntityList);
            } else if ("RMAT".equals(winbidEntity.getType())) {
                List rmatWinbidDetailEntityList = this.rmatWinbidDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RmatWinbidDetailEntity::getSourceId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
                winbidEntity.setRmatWinbidDetailList(rmatWinbidDetailEntityList);
            } else if ("OTHER".equals(winbidEntity.getType())) {
                List otherWinbidDetailEntityList = this.otherWinbidDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OtherWinbidDetailEntity::getSourceId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
                winbidEntity.setOtherWinbidDetailList(otherWinbidDetailEntityList);
            } else {
                this.logger.error("\u62db\u6807\u7c7b\u578b\u4e0d\u5b58\u5728[{}]", (Object)winbidEntity.getType());
                throw new BusinessException("\u62db\u6807\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
            WinbidVO vo = (WinbidVO)BeanMapper.map((Object)((Object)winbidEntity), WinbidVO.class);
            if ("RMAT".equals(vo.getType())) {
                List rmatSchemeRepairEntityList = this.rmatSchemeRepairService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RmatSchemeRepairEntity::getSourceId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
                if (CollectionUtils.isNotEmpty((Collection)rmatSchemeRepairEntityList)) {
                    vo.setRmatSchemeRepairList(BeanMapper.mapList((Iterable)rmatSchemeRepairEntityList, RmatSchemeRepairVO.class));
                } else {
                    vo.setRmatSchemeRepairList(new ArrayList());
                }
                List rmatSchemeScrapEntityList = this.rmatSchemeScrapService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RmatSchemeScrapEntity::getNoticeId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
                if (CollectionUtils.isNotEmpty((Collection)rmatSchemeScrapEntityList)) {
                    vo.setRmatSchemeScrapList(BeanMapper.mapList((Iterable)rmatSchemeScrapEntityList, RmatSchemeScrapVO.class));
                } else {
                    vo.setRmatSchemeScrapList(new ArrayList());
                }
            }
            if (("RMAT".equals(vo.getType()) || "RENT".equals(vo.getType())) && CollectionUtils.isNotEmpty((Collection)(noticeEntities = this.noticeService.list((Wrapper)Wrappers.lambdaQuery().eq(NoticeEntity::getSourceId, (Object)sourceId))))) {
                vo.setRentType(((NoticeEntity)((Object)noticeEntities.get(0))).getRentType());
            }
            if (null != (winbidContentEntity = (WinbidContentEntity)((Object)this.winbidContentService.getOne((Wrapper)Wrappers.lambdaQuery().eq(WinbidContentEntity::getWinbidId, (Object)winbidEntity.getId()))))) {
                vo.setContent(winbidContentEntity.getContent());
            }
            return vo;
        }
        return null;
    }

    @Override
    public CommonResponse<Boolean> save(List<WinbidVO> listVO) {
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(listVO));
        if (CollectionUtils.isNotEmpty(listVO)) {
            QueryParam param = new QueryParam();
            param.getParams().put("sourceId", new Parameter("eq", (Object)listVO.get(0).getSourceId()));
            param.getParams().put("signStatus", new Parameter("eq", (Object)5));
            List outSignEntityList = this.signService.queryList(param);
            List outList = outSignEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            listVO.forEach(e -> {
                WinbidEntity winbidEntity = (WinbidEntity)((Object)((Object)BeanMapper.map((Object)e, WinbidEntity.class)));
                if ("MATERIAL".equals(winbidEntity.getType())) {
                    if (CollectionUtils.isNotEmpty(winbidEntity.getWinbidDetailList())) {
                        winbidEntity.getWinbidDetailList().forEach(k -> k.setTenantId(winbidEntity.getTenantId()));
                    }
                } else if ("SUB".equals(winbidEntity.getType())) {
                    if (CollectionUtils.isNotEmpty(winbidEntity.getSubWinbidDetailList())) {
                        winbidEntity.getSubWinbidDetailList().forEach(k -> k.setTenantId(winbidEntity.getTenantId()));
                    }
                } else if ("PURCHASE".equals(winbidEntity.getType())) {
                    if (CollectionUtils.isNotEmpty(winbidEntity.getPurchaseWinbidDetailList())) {
                        winbidEntity.getPurchaseWinbidDetailList().forEach(k -> k.setTenantId(winbidEntity.getTenantId()));
                    }
                } else if ("RENT".equals(winbidEntity.getType())) {
                    if (CollectionUtils.isNotEmpty(winbidEntity.getRentWinbidDetailList())) {
                        winbidEntity.getRentWinbidDetailList().forEach(k -> k.setTenantId(winbidEntity.getTenantId()));
                    }
                } else if ("RMAT".equals(winbidEntity.getType())) {
                    if (CollectionUtils.isNotEmpty(winbidEntity.getRmatWinbidDetailList())) {
                        winbidEntity.getRmatWinbidDetailList().forEach(k -> k.setTenantId(winbidEntity.getTenantId()));
                    }
                } else if ("OTHER".equals(winbidEntity.getType())) {
                    if (CollectionUtils.isNotEmpty(winbidEntity.getOtherWinbidDetailList())) {
                        winbidEntity.getOtherWinbidDetailList().forEach(k -> k.setTenantId(winbidEntity.getTenantId()));
                    }
                } else {
                    this.logger.error("\u62db\u6807\u7c7b\u578b\u4e0d\u5b58\u5728[{}]", (Object)winbidEntity.getType());
                    throw new BusinessException("\u62db\u6807\u7c7b\u578b\u4e0d\u5b58\u5728");
                }
                super.saveOrUpdate((Object)winbidEntity, false);
                if (StringUtils.isNotEmpty((CharSequence)e.getContent())) {
                    WinbidContentEntity contentEntity = new WinbidContentEntity();
                    contentEntity.setWinbidId(winbidEntity.getId());
                    contentEntity.setContent(e.getContent());
                    contentEntity.setTenantId(winbidEntity.getTenantId());
                    this.winbidContentService.save((Object)contentEntity);
                }
                if (null != e.getWinbidType() && 0 == e.getWinbidType()) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.eq(SignEntity::getSourceId, (Object)e.getSourceId());
                    updateWrapper.eq(BaseEntity::getTenantId, (Object)e.getTenantId());
                    updateWrapper.set(SignEntity::getSignStatus, (Object)4);
                    this.signService.update((Wrapper)updateWrapper);
                }
            });
            if (null != listVO.get(0).getWinbidType() && 0 == listVO.get(0).getWinbidType()) {
                List signEntityList;
                LambdaUpdateWrapper updateWrapper2 = new LambdaUpdateWrapper();
                updateWrapper2.eq(SignEntity::getSourceId, (Object)listVO.get(0).getSourceId());
                updateWrapper2.ne(SignEntity::getSignStatus, (Object)4);
                updateWrapper2.set(SignEntity::getSignStatus, (Object)5);
                updateWrapper2.set(SignEntity::getOutReason, (Object)"\u672a\u4e2d\u6807");
                this.signService.update((Wrapper)updateWrapper2);
                this.logger.info("\u5f00\u59cb\u7ec4\u7ec7\u6d88\u606f\u53d1\u9001\u5185\u5bb9===========");
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("sourceId", new Parameter("eq", (Object)listVO.get(0).getSourceId()));
                List noticeEntityList = this.noticeService.queryList(queryParam);
                queryParam.getParams().put("signStatus", new Parameter("eq", (Object)5));
                if (CollectionUtils.isNotEmpty(outList)) {
                    queryParam.getParams().put("id", new Parameter("not_in", outList));
                }
                if (CollectionUtils.isNotEmpty((Collection)(signEntityList = this.signService.queryList(queryParam))) && CollectionUtils.isNotEmpty((Collection)noticeEntityList)) {
                    this.logger.info("\u672a\u4e2d\u6807\u4f9b\u5e94\u5546\u6570\u91cf\u3010{}\u3011", (Object)signEntityList.size());
                    for (SignEntity sign : signEntityList) {
                        ArrayList<String> userList = new ArrayList<String>();
                        if (sign.getSignId() != null) {
                            userList.add(sign.getSignId().toString());
                        }
                        if (sign.getSchemeId() != null) {
                            userList.add(sign.getSchemeId().toString());
                        }
                        userList = userList.stream().distinct().collect(Collectors.toList());
                        NoticeEntity noticeEntity = (NoticeEntity)((Object)noticeEntityList.get(0));
                        String projectName = noticeEntity.getProjectName();
                        if (PURCHASE_TYPE_1.equals(noticeEntity.getPurchaseType())) {
                            projectName = noticeEntity.getOrgName();
                        }
                        String formurl = this.baseHost + "ejc-supbid-frontend/#/eliminated?id=" + noticeEntity.getId();
                        String mobileurl = this.baseHost + "ejc-supbid-mobile/#/inProgressList/eliminated?id=" + noticeEntity.getId();
                        String subject = "\u5f88\u9057\u61be,\u4f60\u6295\u6807\u7684\u3010" + projectName + "\u3011\u672a\u4e2d\u6807\uff0c\u611f\u8c22\u60a8\u7684\u53c2\u4e0e\uff01";
                        String content = "\u5f88\u9057\u61be,\u4f60\u6295\u6807\u7684\u3010" + projectName + "\u3011\u672a\u4e2d\u6807\uff0c\u611f\u8c22\u60a8\u7684\u53c2\u4e0e\uff01<a href= '" + formurl + "'>\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>";
                        new SendMsgUtils().sendSysMsg(userList, subject, content, sign.getTenantId(), this.pushMessageApi, mobileurl);
                    }
                }
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)true);
    }

    @Override
    public IPage<WinbidVO> queryHomeList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("memo");
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WinbidVO.class));
        return pageData;
    }
}

