package com.ejianc.business.supbid.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.supbid.notice.vo.NumsVO;
import com.ejianc.business.supbid.notice.vo.SignVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.notice.mapper.SignMapper;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.ISignService;

import java.util.Date;
import java.util.List;

/**
 * 报名实体
 * 
 * @author generator
 * 
 */
@Service("signService")
public class SignServiceImpl extends BaseServiceImpl<SignMapper, SignEntity> implements ISignService{

    @Override
    public Boolean updateSignStatus(List<SignVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)){
            vos.forEach(e->{
                LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(SignEntity::getTenantId,e.getTenantId());
                updateWrapper.eq(SignEntity::getSourceId,e.getSourceId());
                updateWrapper.set(SignEntity::getSignStatus,5);//已淘汰
                updateWrapper.set(SignEntity::getOutReason,e.getOutReason());
                super.update(updateWrapper);
            });
        }
        return true;
    }

}
