package com.ejianc.business.supbid.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.material.bean.SchemeDetailEntity;
import com.ejianc.business.supbid.material.bean.SchemeEntity;
import com.ejianc.business.supbid.material.service.ISchemeDetailService;
import com.ejianc.business.supbid.material.service.ISchemeService;
import com.ejianc.business.supbid.material.vo.SchemeVO;
import com.ejianc.business.supbid.notice.bean.ContentEntity;
import com.ejianc.business.supbid.notice.bean.FilecontentEntity;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.mapper.NoticeMapper;
import com.ejianc.business.supbid.notice.service.IContentService;
import com.ejianc.business.supbid.notice.service.IFilecontentService;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.notice.vo.ApplyVO;
import com.ejianc.business.supbid.notice.vo.NoticeVO;
import com.ejianc.business.supbid.notice.vo.NumsVO;
import com.ejianc.business.supbid.notice.vo.SignVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 公告实体
 * 
 * @author generator
 * 
 */
@Service("noticeService")
public class NoticeServiceImpl extends BaseServiceImpl<NoticeMapper, NoticeEntity> implements INoticeService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IContentService contentService;

    @Autowired
    private IFilecontentService filecontentService;

    @Autowired
    private ISchemeService schemeService;
    @Autowired
    private ISchemeDetailService schemeDetailService;
    @Autowired
    private ISignService signService;

    @Override
    public CommonResponse<Boolean> save(NoticeVO saveorUpdateVO) {
        NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                logger.debug("网络异常， 编码生成失败， 请稍后再试");
                return CommonResponse.success("网络异常， 编码生成失败， 请稍后再试！",false);
            }
        }
        boolean flag = super.saveOrUpdate(entity, false);
        if(StringUtils.isNotEmpty(saveorUpdateVO.getNoticeContent())){
            ContentEntity contentEntity = new ContentEntity();
            contentEntity.setNoticeId(entity.getId());
            contentEntity.setNoticeContent(saveorUpdateVO.getNoticeContent());
            contentService.save(contentEntity);
        }
        if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
            FilecontentEntity contentEntity = new FilecontentEntity();
            contentEntity.setNoticeId(entity.getId());
            contentEntity.setContent(saveorUpdateVO.getContent());
            filecontentService.save(contentEntity);
        }

        if(1==saveorUpdateVO.getTenderType()){
            //邀请招标  需要生成报名表，状态为待报名
            List<SignEntity> signEntities = new ArrayList<>();
            List<ApplyVO> applyVOList = saveorUpdateVO.getApplyList();
            if(CollectionUtils.isNotEmpty(applyVOList)){
                applyVOList.forEach(e->{
                    SignEntity signEntity = new SignEntity();
                    signEntity.setSourceId(saveorUpdateVO.getSourceId());
                    signEntity.setSignStatus(9);//待报名
                    signEntity.setSourceTenantId(e.getSourceTenantId());
                    signEntities.add(signEntity);
                });
                signService.saveBatch(signEntities);
            }
        }

        return CommonResponse.success("保存或修改单据成功！",flag);
    }


    @Override
    public CommonResponse<NoticeVO> saveFile(NoticeVO saveorUpdateVO) {
        List<SchemeVO> schemeVOList = saveorUpdateVO.getSchemeList();
        schemeService.saveOrUpdateBatch(BeanMapper.mapList(schemeVOList,SchemeEntity.class),10,false);
        List<SignVO> signVOList = saveorUpdateVO.getSignList();
        signService.saveBatch(BeanMapper.mapList(signVOList,SignEntity.class));
        return CommonResponse.success("保存或修改单据成功！",queryFileDetail(saveorUpdateVO.getId()));
    }

    @Override
    public NoticeVO queryDetail(Long id) {
        NoticeEntity noticeEntity = super.selectById(id);
        NoticeVO vo = BeanMapper.map(noticeEntity, NoticeVO.class);
        ContentEntity contentEntity = contentService.getOne((Wrappers.<ContentEntity>lambdaQuery().eq(ContentEntity::getNoticeId, id)));
        if(null!=contentEntity){
            vo.setNoticeContent(contentEntity.getNoticeContent());
        }
        return vo;
    }

    @Override
    public NoticeVO queryFileDetail(Long id) {
        NoticeEntity noticeEntity = super.selectById(id);
        NoticeVO vo = BeanMapper.map(noticeEntity, NoticeVO.class);
        FilecontentEntity filecontentEntity = filecontentService.getOne((Wrappers.<FilecontentEntity>lambdaQuery().eq(FilecontentEntity::getNoticeId, id)));
        if(null!=filecontentEntity){
            vo.setContent(filecontentEntity.getContent());
        }
        //查询方案信息
        List<SchemeEntity> schemeEntityList = schemeService.list((Wrappers.<SchemeEntity>lambdaQuery().eq(SchemeEntity::getNoticeId, id)).orderByAsc(SchemeEntity::getSchemeName));
        if(CollectionUtils.isNotEmpty(schemeEntityList)){
            schemeEntityList.forEach(e->{
                List<SchemeDetailEntity> schemeDetailEntities = null;
                schemeDetailEntities = schemeDetailService.list((Wrappers.<SchemeDetailEntity>lambdaQuery().eq(SchemeDetailEntity::getSchemeId, e.getId())));
                e.setSchemeDetailList(schemeDetailEntities);
            });
            vo.setSchemeList(BeanMapper.mapList(schemeEntityList,SchemeVO.class));
        }
        return vo;
    }

    @Override
    public List<NoticeVO> queryInvitationList(QueryWrapper queryWrapper, Integer signStatus,String tenantId) {
        return baseMapper.queryInvitation(queryWrapper,signStatus,tenantId);
    }

    @Override
    public NumsVO queryCounts() {
        NumsVO numsVO = new NumsVO();
        List<NoticeVO> list = baseMapper.queryCounts(InvocationInfoProxy.getTenantid()+"");
        numsVO.setDbmnums(list.get(0).getNums());
        numsVO.setYbmnums(list.get(1).getNums());
        numsVO.setDbjnums(list.get(2).getNums());
        numsVO.setQstpnums(list.get(3).getNums());
        numsVO.setBjznums(list.get(4).getNums());
        numsVO.setYdbnums(list.get(5).getNums());
        numsVO.setTtnums(list.get(6).getNums());
        return numsVO;
    }
}
