/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.mapper.SignMapper;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.notice.vo.BmNoticeVO;
import com.ejianc.business.supbid.notice.vo.SignVO;
import com.ejianc.business.supbid.util.ThirdSystemUtils;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="signService")
public class SignServiceImpl
extends BaseServiceImpl<SignMapper, SignEntity>
implements ISignService {
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${gcyUrl.signUpUrl}")
    private String signUpUrl;
    @Value(value="${gcyUrl.tokenUrl}")
    private String tokenUrl;

    @Override
    public CommonResponse<SignVO> save(SignVO saveorUpdateVO) {
        SignEntity entity = (SignEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SignEntity.class));
        entity.setSignStatus(0);
        BmNoticeVO bmNoticeVO = (BmNoticeVO)BeanMapper.map((Object)((Object)entity), BmNoticeVO.class);
        bmNoticeVO.setEmployeeId(entity.getSignEmployeeId());
        bmNoticeVO.setEmployeeName(entity.getSignEmployeeName());
        bmNoticeVO.setEmployeeMobile(entity.getSignEmployeeMobile());
        bmNoticeVO.setTenantId(InvocationInfoProxy.getTenantid());
        bmNoticeVO.setSupplierId("1212");
        bmNoticeVO.setSupplierName("\u6d4b\u8bd5\u6d4b\u8bd5");
        CommonResponse<JSONObject> response = null;
        try {
            response = new ThirdSystemUtils().sendPostReq(this.tokenUrl, this.signUpUrl, JSON.toJSONString((Object)bmNoticeVO), this.cacheManager);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        super.saveOrUpdate((Object)entity, false);
        SignVO vo = (SignVO)BeanMapper.map((Object)((Object)entity), SignVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public Boolean updateSignStatus(List<SignVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            vos.forEach(e -> {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getTenantId, (Object)e.getTenantId());
                updateWrapper.eq(SignEntity::getSourceId, (Object)e.getSourceId());
                updateWrapper.set(SignEntity::getSignStatus, (Object)5);
                updateWrapper.set(SignEntity::getOutReason, (Object)e.getOutReason());
                super.update((Wrapper)updateWrapper);
            });
        }
        return true;
    }
}

