package com.ejianc.business.supbid.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.material.bean.SchemeDetailEntity;
import com.ejianc.business.supbid.material.bean.SchemeEntity;
import com.ejianc.business.supbid.material.service.ISchemeDetailService;
import com.ejianc.business.supbid.material.service.ISchemeService;
import com.ejianc.business.supbid.material.vo.SchemeVO;
import com.ejianc.business.supbid.notice.bean.ContentEntity;
import com.ejianc.business.supbid.notice.bean.FilecontentEntity;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.mapper.NoticeMapper;
import com.ejianc.business.supbid.notice.service.IContentService;
import com.ejianc.business.supbid.notice.service.IFilecontentService;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.notice.vo.*;
import com.ejianc.business.supbid.util.ThirdSystemUtils;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 公告实体
 * 
 * @author generator
 * 
 */
@Service("noticeService")
public class NoticeServiceImpl extends BaseServiceImpl<NoticeMapper, NoticeEntity> implements INoticeService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Value("${gcyUrl.signUpUrl}")
    private String signUpUrl;

    @Value("${gcyUrl.pushSellUrl}")
    private String pushSellUrl;

    @Value("${gcyUrl.tokenUrl}")
    private String tokenUrl;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IContentService contentService;

    @Autowired
    private IFilecontentService filecontentService;

    @Autowired
    private ISchemeService schemeService;
    @Autowired
    private ISchemeDetailService schemeDetailService;
    @Autowired
    private ISignService signService;

    @Override
    public CommonResponse<Boolean> save(NoticeVO saveorUpdateVO) {
        NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
        boolean flag = false;

        if(0==saveorUpdateVO.getNoticeType()){//公告
            if(entity.getId() == null || entity.getId() == 0){
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    logger.debug("网络异常， 编码生成失败， 请稍后再试");
                    return CommonResponse.success("网络异常， 编码生成失败， 请稍后再试！",false);
                }
            }
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getNoticeContent())){
                ContentEntity contentEntity = new ContentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setNoticeContent(saveorUpdateVO.getNoticeContent());
                contentService.save(contentEntity);
            }
            if(1==saveorUpdateVO.getTenderType()){
                //邀请招标  需要生成报名表，状态为待报名
                List<SignEntity> signEntities = new ArrayList<>();
                List<ApplyVO> applyVOList = saveorUpdateVO.getApplyList();
                if(CollectionUtils.isNotEmpty(applyVOList)){
                    applyVOList.forEach(e->{
                        SignEntity signEntity = new SignEntity();
                        signEntity.setSourceId(saveorUpdateVO.getSourceId());
                        signEntity.setNoticeId(entity.getId());
                        signEntity.setSignStatus(9);//待报名
                        signEntity.setSourceSupplierId(e.getSourceSupplierId());
                        signEntity.setTenantId(e.getTenantId());
                        signEntities.add(signEntity);
                    });
                    signService.saveBatch(signEntities);
                }
            }
        }else if(1==saveorUpdateVO.getNoticeType()){//文件
            NoticeEntity noticeEntity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId()));
            noticeEntity.setProjectLinkName(saveorUpdateVO.getProjectLinkName());
            noticeEntity.setProjectLinkPhone(saveorUpdateVO.getProjectLinkPhone());
            noticeEntity.setOfferStartTime(saveorUpdateVO.getOfferStartTime());
            noticeEntity.setOfferEndTime(saveorUpdateVO.getOfferEndTime());
            noticeEntity.setBrandFlag(saveorUpdateVO.getBrandFlag());
            noticeEntity.setMemo(saveorUpdateVO.getMemo());

            flag = super.saveOrUpdate(noticeEntity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }
            //需将状态改为已报名的数据改为  待报价
            LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SignEntity::getSourceId,saveorUpdateVO.getSourceId());
            updateWrapper.eq(SignEntity::getSignStatus,0);//查询已报名
            updateWrapper.set(SignEntity::getSignStatus,1);//待报价
            signService.update(updateWrapper);
        }

        return CommonResponse.success("保存或修改单据成功！",flag);
    }


    @Override
    public CommonResponse<NoticeVO> saveFile(NoticeVO saveorUpdateVO) {
        NoticeVO dbVo = queryFileDetail(saveorUpdateVO.getId());
        List<SchemeVO> schemeVOList = saveorUpdateVO.getSchemeList();
        List<SchemeVO> delList = new ArrayList<>();//删除的数据
        List<SchemeVO> dbList = dbVo.getSchemeList();//数据库里的数据
        if(CollectionUtils.isNotEmpty(schemeVOList)){
            if(CollectionUtils.isNotEmpty(dbList)){
                Map<Long,String> map = schemeVOList.stream().collect(Collectors.toMap(SchemeVO::getId, SchemeVO::getSchemeName));
                dbList.forEach(d->{
                    if(!map.containsKey(d.getId())){
                        delList.add(d);
                    }
                });
            }
            if(CollectionUtils.isNotEmpty(delList)){
                schemeService.removeByIds(delList,false);
            }
            //新增修改的数据
            List<SchemeEntity> schemeEntityList=BeanMapper.mapList(schemeVOList,SchemeEntity.class);
            schemeEntityList.forEach(e->{
                schemeService.saveOrUpdate(e,false);
            });
        }
        List<SignVO> signVOList = saveorUpdateVO.getSignList();
        SignEntity signEntity = BeanMapper.map(signVOList.get(0),SignEntity.class);
        if(null!=signVOList.get(0).getsId()){
            signEntity.setId(signVOList.get(0).getsId());
        }
        signEntity.setSignStatus(3);
        signService.saveOrUpdate(signEntity,false);


        //调用第三方报名接口 推送报价
        NoticeVO resVo = queryFileDetail(saveorUpdateVO.getId());
        BjNoticeVO bjNoticeVO =  BeanMapper.map(signEntity,BjNoticeVO.class);
        bjNoticeVO.setEmployeeId(signEntity.getSignEmployeeId());
        bjNoticeVO.setEmployeeName(signEntity.getSignEmployeeName());
        bjNoticeVO.setEmployeeMobile(signEntity.getSignEmployeeMobile());
        bjNoticeVO.setDetailList(resVo.getDetailList());
        bjNoticeVO.setSchemeList(resVo.getSchemeList());
        CommonResponse<JSONObject> response = null;
        try {
            response = new ThirdSystemUtils().sendPostReq(tokenUrl,pushSellUrl, JSON.toJSONString(bjNoticeVO),cacheManager);
            if(!response.isSuccess()) {
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }

        return CommonResponse.success("保存或修改单据成功！",resVo);
    }

    @Override
    public CommonResponse<Boolean> updateTime(NoticeVO saveorUpdateVO) {
        LambdaUpdateWrapper<NoticeEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(NoticeEntity::getSourceId,saveorUpdateVO.getSourceId());
        if(null!=saveorUpdateVO.getNoticeEndTime()){
            updateWrapper.set(NoticeEntity::getNoticeEndTime,saveorUpdateVO.getNoticeEndTime());
        }
        if(null!=saveorUpdateVO.getNoticeEndTime()){
            updateWrapper.set(NoticeEntity::getOfferEndTime,saveorUpdateVO.getOfferEndTime());
        }
        return CommonResponse.success("修改成功！",true);
    }

    @Override
    public NoticeVO queryDetail(Long id) {
        NoticeEntity noticeEntity = super.selectById(id);
        NoticeVO vo = BeanMapper.map(noticeEntity, NoticeVO.class);
        List<SignEntity> signEntities = signService.list(Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getNoticeId, id).eq(SignEntity::getTenantId,InvocationInfoProxy.getTenantid()));
        List<SignVO> signVOList =  BeanMapper.mapList(signEntities, SignVO.class);
        if(CollectionUtils.isNotEmpty(signEntities)){
            Long sid = signEntities.get(0).getId();
            signVOList.get(0).setsId(sid);
        }
        vo.setSignList(signVOList);
        ContentEntity contentEntity = contentService.getOne((Wrappers.<ContentEntity>lambdaQuery().eq(ContentEntity::getNoticeId, id)));
        if(null!=contentEntity){
            vo.setNoticeContent(contentEntity.getNoticeContent());
        }
        return vo;
    }

    @Override
    public NoticeVO queryFileDetail(Long id) {
        NoticeEntity noticeEntity = super.selectById(id);
        NoticeVO vo = BeanMapper.map(noticeEntity, NoticeVO.class);
        List<SignEntity> signEntities = signService.list(Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getNoticeId, id).eq(SignEntity::getTenantId,InvocationInfoProxy.getTenantid()));
        List<SignVO> signVOList =  BeanMapper.mapList(signEntities, SignVO.class);
        if(CollectionUtils.isNotEmpty(signEntities)){
            Long sid = signEntities.get(0).getId();
            signVOList.get(0).setsId(sid);
        }
        vo.setSignList(signVOList);

        FilecontentEntity filecontentEntity = filecontentService.getOne((Wrappers.<FilecontentEntity>lambdaQuery().eq(FilecontentEntity::getNoticeId, id)));
        if(null!=filecontentEntity){
            vo.setContent(filecontentEntity.getContent());
        }
        //查询方案信息
        List<SchemeEntity> schemeEntityList = schemeService.list((Wrappers.<SchemeEntity>lambdaQuery().eq(SchemeEntity::getNoticeId, id)).eq(SchemeEntity::getTenantId, InvocationInfoProxy.getTenantid()).orderByAsc(SchemeEntity::getSchemeName));
        if(CollectionUtils.isNotEmpty(schemeEntityList)){
            schemeEntityList.forEach(e->{
                List<SchemeDetailEntity> schemeDetailEntities = null;
                schemeDetailEntities = schemeDetailService.list((Wrappers.<SchemeDetailEntity>lambdaQuery().eq(SchemeDetailEntity::getSchemeId, e.getId())));
                e.setSchemeDetailList(schemeDetailEntities);
            });
            vo.setSchemeList(BeanMapper.mapList(schemeEntityList,SchemeVO.class));
        }
        return vo;
    }

    @Override
    public List<NoticeVO> queryInvitationList(QueryWrapper queryWrapper, Integer signStatus,String tenantId) {
        return baseMapper.queryInvitation(queryWrapper,signStatus,tenantId);
    }

    @Override
    public NumsVO queryCounts() {
        NumsVO numsVO = new NumsVO();
        List<NoticeVO> list = baseMapper.queryCounts(InvocationInfoProxy.getTenantid()+"");
        numsVO.setDbmnums(list.get(0).getNums());
        numsVO.setYbmnums(list.get(1).getNums());
        numsVO.setDbjnums(list.get(2).getNums());
        numsVO.setQstpnums(list.get(3).getNums());
        numsVO.setBjznums(list.get(4).getNums());
        numsVO.setYdbnums(list.get(5).getNums());
        numsVO.setTtnums(list.get(6).getNums());
        return numsVO;
    }
}
