package com.ejianc.business.supbid.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.supbid.notice.vo.BmNoticeVO;
import com.ejianc.business.supbid.notice.vo.NoticeVO;
import com.ejianc.business.supbid.notice.vo.NumsVO;
import com.ejianc.business.supbid.notice.vo.SignVO;
import com.ejianc.business.supbid.util.ThirdSystemUtils;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.notice.mapper.SignMapper;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.ISignService;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 报名实体
 * 
 * @author generator
 * 
 */
@Service("signService")
public class SignServiceImpl extends BaseServiceImpl<SignMapper, SignEntity> implements ISignService{

    @Autowired
    private CacheManager cacheManager;

    @Value("${gcyUrl.signUpUrl}")
    private String signUpUrl;

    @Value("${gcyUrl.tokenUrl}")
    private String tokenUrl;

    @Override
    public CommonResponse<SignVO> save(SignVO saveorUpdateVO) {
        SignEntity entity = BeanMapper.map(saveorUpdateVO, SignEntity.class);
        if(null!=saveorUpdateVO.getsId()){
            entity.setId(saveorUpdateVO.getsId());
        }
        entity.setSignStatus(0);//已报名
        BmNoticeVO bmNoticeVO = BeanMapper.map(entity,BmNoticeVO.class);
        bmNoticeVO.setEmployeeId(entity.getSignEmployeeId());
        bmNoticeVO.setEmployeeName(entity.getSignEmployeeName());
        bmNoticeVO.setEmployeeMobile(entity.getSignEmployeeMobile());
        bmNoticeVO.setTenantId(InvocationInfoProxy.getTenantid());
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        String now = sdf.format(new Date());
        bmNoticeVO.setSignTime(new Date());
        bmNoticeVO.setSourceSupplierId("1212");
        bmNoticeVO.setSupplierName("测试测试");
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        try {
            response = new ThirdSystemUtils().sendPostReq(tokenUrl,signUpUrl, JSON.toJSONString(bmNoticeVO),cacheManager);
            if(!response.isSuccess()) {
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }

        super.saveOrUpdate(entity, false);
        SignVO vo = BeanMapper.map(entity, SignVO.class);
        vo.setsId(entity.getId());
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public Boolean updateSignStatus(List<SignVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)){
            vos.forEach(e->{
                LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(SignEntity::getTenantId,e.getTenantId());
                updateWrapper.eq(SignEntity::getSourceId,e.getSourceId());
                updateWrapper.set(SignEntity::getSignStatus,5);//已淘汰
                updateWrapper.set(SignEntity::getOutReason,e.getOutReason());
                super.update(updateWrapper);
            });
        }
        return true;
    }

}
