package com.ejianc.business.supbid.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import groovy.util.logging.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.omg.CORBA.portable.ApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Component
@Slf4j
public class ThirdSystemUtils {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String GCY_CACHE_KEY_PREFIX = "GCY::";//工程云

//    private final String GF_CACHE_KEY_PREFIX = "GF::";//供方

//    @Autowired
//    private CacheManager cacheManager;

    public String  getToken(String tokenUrl,CacheManager cacheManager){

        String key = GCY_CACHE_KEY_PREFIX + "ACCESS_TOKEN";
        String accessroken = cacheManager.get(key);
        logger.debug("获取accessroken:=====" + accessroken);
        if(StringUtils.isBlank(accessroken)){
            JSONObject result = getForObject(tokenUrl);
            JSONObject dataObject = (JSONObject) result.get("data");
            if((Boolean) dataObject.get("querysucflag")){
                accessroken = (String) dataObject.get("access_token");
                Integer expiresTime = (Integer) dataObject.get("expires_in");
                cacheManager.setex(key, accessroken, expiresTime);
            }else{
                throw new BusinessException((String) dataObject.get("errormsg"));
            }
            logger.debug("获取accessroken:" + accessroken);
        }
        return  accessroken;
    }

    public JSONObject getForObject(String url){
        JSONObject result;
        Map<String, String> headers = new HashMap<>();
        try {
            result = JSONObject.parseObject(HttpTookit.get(url, null, headers));
        } catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("调用第三方服务调用报错");
        }
        return  result;
    }

    private CommonResponse<JSONObject> sendGetReq(String tokenUrl,String url, Map<String, Object> params,CacheManager cacheManager) throws Exception {
        Map<String, String> headers = new HashMap<>(5);
        String accessToken = getToken(tokenUrl,cacheManager);
        if(null == accessToken) {
            throw new BusinessException("获取服务accessToken失败！");
        }
        headers.put("access_token", accessToken);
        String reqResp =  HttpTookit.get(url, params, headers, 10000, 20000);
        logger.info("发送get请求【地址： {}, 参数：{}, header: {}】, 响应结果：{}", url, JSON.toJSONString(params), headers, reqResp);

        JSONObject jsonData = JSONObject.parseObject(reqResp);
        if(0!=Integer.parseInt(jsonData.get("code").toString())) {
            return CommonResponse.error(null != jsonData.get("msg") ? jsonData.get("msg").toString() : "调用接口失败！");
        }
        return CommonResponse.success(jsonData);
    }

    public CommonResponse<JSONObject> sendPostReq(String tokenUrl,String url, String paramJson,CacheManager cacheManager) throws Exception {
        Map<String, String> headers = new HashMap<>(5);
        String accessToken = getToken(tokenUrl,cacheManager);
        if(null == accessToken) {
            throw new BusinessException("获取服务accessToken失败！");
        }
        headers.put("access_token", accessToken);
        String reqResp =  HttpTookit.postByJson(url, paramJson, headers, 10000, 20000);
        logger.info("发送post请求【地址： {}, 参数：{}, header: {}】, 响应结果：{}", url, paramJson, headers, reqResp);

        JSONObject jsonData = JSONObject.parseObject(reqResp);
        if(0!=Integer.parseInt(jsonData.get("code").toString())) {
            return CommonResponse.error(null != jsonData.get("msg") ? jsonData.get("msg").toString() : "调用接口失败！");
        }
        return CommonResponse.success(jsonData);
    }
}
