package com.ejianc.business.supbid.winbid.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.winbid.vo.WinbidVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.winbid.mapper.WinbidMapper;
import com.ejianc.business.supbid.winbid.bean.WinbidEntity;
import com.ejianc.business.supbid.winbid.service.IWinbidService;

import java.util.List;

/**
 * 中标实体
 * 
 * @author generator
 * 
 */
@Service("winbidService")
public class WinbidServiceImpl extends BaseServiceImpl<WinbidMapper, WinbidEntity> implements IWinbidService{
    @Autowired
    private ISignService signService;
    @Override
    public WinbidVO queryWinbidDetail(String sourceId) {
        List<WinbidEntity> list = super.list(Wrappers.<WinbidEntity>lambdaQuery().eq(WinbidEntity::getSourceId, sourceId).eq(WinbidEntity::getTenantId,InvocationInfoProxy.getTenantid()));
        if(CollectionUtils.isNotEmpty(list)){
            return BeanMapper.map(list.get(0),WinbidVO.class);
        }else{
            return null;
        }
    }

    @Override
    public CommonResponse<Boolean> save(List<WinbidVO> listVO) {
        List<WinbidEntity> winbidEntityList = BeanMapper.mapList(listVO,WinbidEntity.class);
        if(CollectionUtils.isNotEmpty(winbidEntityList)){
            winbidEntityList.forEach(e->{
                super.saveOrUpdate(e, false);

                //将对应报名表更新为已定标  剩下的改为已淘汰
                LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(SignEntity::getSourceId,e.getSourceId());
                updateWrapper.eq(SignEntity::getTenantId,InvocationInfoProxy.getTenantid());//查询已报名
                updateWrapper.set(SignEntity::getSignStatus,4);//已定标
                signService.update(updateWrapper);

                LambdaUpdateWrapper<SignEntity> updateWrapper2 = new LambdaUpdateWrapper<>();
                updateWrapper2.eq(SignEntity::getSourceId,e.getSourceId());
                updateWrapper2.eq(SignEntity::getTenantId,InvocationInfoProxy.getTenantid());//查询已报名
                updateWrapper2.ne(SignEntity::getSignStatus,4);//没用定标的全部改为淘汰
                updateWrapper2.set(SignEntity::getSignStatus,5);//已淘汰
                updateWrapper2.set(SignEntity::getOutReason,"未中标");
                signService.update(updateWrapper2);
            });
        }

        return CommonResponse.success("操作成功！",true);
    }
}
