/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.material.bean.SchemeDetailEntity;
import com.ejianc.business.supbid.material.bean.SchemeEntity;
import com.ejianc.business.supbid.material.service.ISchemeDetailService;
import com.ejianc.business.supbid.material.service.ISchemeService;
import com.ejianc.business.supbid.material.vo.SchemeVO;
import com.ejianc.business.supbid.notice.bean.ContentEntity;
import com.ejianc.business.supbid.notice.bean.FilecontentEntity;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.mapper.NoticeMapper;
import com.ejianc.business.supbid.notice.service.IContentService;
import com.ejianc.business.supbid.notice.service.IFilecontentService;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.notice.vo.BjNoticeVO;
import com.ejianc.business.supbid.notice.vo.NoticeVO;
import com.ejianc.business.supbid.notice.vo.NumsVO;
import com.ejianc.business.supbid.notice.vo.SignVO;
import com.ejianc.business.supbid.util.ThirdSystemUtils;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="noticeService")
public class NoticeServiceImpl
extends BaseServiceImpl<NoticeMapper, NoticeEntity>
implements INoticeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${gcyUrl.signUpUrl}")
    private String signUpUrl;
    @Value(value="${gcyUrl.pushSellUrl}")
    private String pushSellUrl;
    @Value(value="${gcyUrl.tokenUrl}")
    private String tokenUrl;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IContentService contentService;
    @Autowired
    private IFilecontentService filecontentService;
    @Autowired
    private ISchemeService schemeService;
    @Autowired
    private ISchemeDetailService schemeDetailService;
    @Autowired
    private ISignService signService;

    @Override
    public CommonResponse<Boolean> save(NoticeVO saveorUpdateVO) {
        NoticeEntity entity = (NoticeEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, NoticeEntity.class));
        boolean flag = false;
        if (0 == saveorUpdateVO.getNoticeType()) {
            if (entity.getId() == null || entity.getId() == 0L) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if (billCode.isSuccess()) {
                    entity.setBillCode((String)billCode.getData());
                } else {
                    this.logger.debug("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    return CommonResponse.success((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object)false);
                }
            }
            flag = super.saveOrUpdate((Object)entity, false);
            if (StringUtils.isNotEmpty((CharSequence)saveorUpdateVO.getNoticeContent())) {
                ContentEntity contentEntity = new ContentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setNoticeContent(saveorUpdateVO.getNoticeContent());
                this.contentService.save((Object)contentEntity);
            }
            if (1 == saveorUpdateVO.getTenderType()) {
                ArrayList signEntities = new ArrayList();
                List applyVOList = saveorUpdateVO.getApplyList();
                if (CollectionUtils.isNotEmpty((Collection)applyVOList)) {
                    applyVOList.forEach(e -> {
                        SignEntity signEntity = new SignEntity();
                        signEntity.setSourceId(saveorUpdateVO.getSourceId());
                        signEntity.setNoticeId(entity.getId());
                        signEntity.setSignStatus(9);
                        signEntity.setSourceSupplierId(e.getSourceSupplierId());
                        signEntity.setTenantId(e.getTenantId());
                        signEntities.add(signEntity);
                    });
                    this.signService.saveBatch(signEntities);
                }
            }
        } else if (1 == saveorUpdateVO.getNoticeType()) {
            NoticeEntity noticeEntity = (NoticeEntity)((Object)super.getOne((Wrapper)Wrappers.lambdaQuery().eq(NoticeEntity::getSourceId, (Object)saveorUpdateVO.getSourceId())));
            noticeEntity.setProjectLinkName(saveorUpdateVO.getProjectLinkName());
            noticeEntity.setProjectLinkPhone(saveorUpdateVO.getProjectLinkPhone());
            noticeEntity.setOfferStartTime(saveorUpdateVO.getOfferStartTime());
            noticeEntity.setOfferEndTime(saveorUpdateVO.getOfferEndTime());
            noticeEntity.setBrandFlag(saveorUpdateVO.getBrandFlag());
            noticeEntity.setMemo(saveorUpdateVO.getMemo());
            flag = super.saveOrUpdate((Object)noticeEntity, false);
            if (StringUtils.isNotEmpty((CharSequence)saveorUpdateVO.getContent())) {
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                this.filecontentService.save((Object)contentEntity);
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(SignEntity::getSourceId, (Object)saveorUpdateVO.getSourceId());
            updateWrapper.eq(SignEntity::getSignStatus, (Object)0);
            updateWrapper.set(SignEntity::getSignStatus, (Object)1);
            this.signService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)flag);
    }

    @Override
    public CommonResponse<NoticeVO> saveFile(NoticeVO saveorUpdateVO) {
        NoticeVO dbVo = this.queryFileDetail(saveorUpdateVO.getId());
        List schemeVOList = saveorUpdateVO.getSchemeList();
        ArrayList delList = new ArrayList();
        List dbList = dbVo.getSchemeList();
        if (CollectionUtils.isNotEmpty((Collection)schemeVOList)) {
            if (CollectionUtils.isNotEmpty((Collection)dbList)) {
                Map<Long, String> map = schemeVOList.stream().collect(Collectors.toMap(BaseVO::getId, SchemeVO::getSchemeName));
                dbList.forEach(d -> {
                    if (!map.containsKey(d.getId())) {
                        delList.add(d);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(delList)) {
                this.schemeService.removeByIds(delList, false);
            }
            List schemeEntityList = BeanMapper.mapList((Iterable)schemeVOList, SchemeEntity.class);
            schemeEntityList.forEach(e -> this.schemeService.saveOrUpdate(e, false));
        }
        List signVOList = saveorUpdateVO.getSignList();
        SignEntity signEntity = (SignEntity)((Object)this.signService.selectById(((SignVO)signVOList.get(0)).getsId()));
        signEntity.setSignStatus(3);
        this.signService.saveOrUpdate((Object)signEntity, false);
        NoticeVO resVo = this.queryFileDetail(saveorUpdateVO.getId());
        BjNoticeVO bjNoticeVO = (BjNoticeVO)BeanMapper.map((Object)((Object)signEntity), BjNoticeVO.class);
        bjNoticeVO.setSourceSupplierId(signEntity.getSourceSupplierId());
        bjNoticeVO.setSchemeTime(new Date());
        bjNoticeVO.setEmployeeId(signEntity.getSignEmployeeId());
        bjNoticeVO.setEmployeeName(signEntity.getSignEmployeeName());
        bjNoticeVO.setEmployeeMobile(signEntity.getSignEmployeeMobile());
        bjNoticeVO.setDetailList(resVo.getDetailList());
        bjNoticeVO.setSchemeList(resVo.getSchemeList());
        CommonResponse<JSONObject> response = null;
        try {
            response = new ThirdSystemUtils().sendPostReq(this.tokenUrl, this.pushSellUrl, JSON.toJSONString((Object)bjNoticeVO), this.cacheManager);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)resVo);
    }

    @Override
    public CommonResponse<Boolean> updateTime(NoticeVO saveorUpdateVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(NoticeEntity::getSourceId, (Object)saveorUpdateVO.getSourceId());
        if (null != saveorUpdateVO.getNoticeEndTime()) {
            updateWrapper.set(NoticeEntity::getNoticeEndTime, (Object)saveorUpdateVO.getNoticeEndTime());
        }
        if (null != saveorUpdateVO.getNoticeEndTime()) {
            updateWrapper.set(NoticeEntity::getOfferEndTime, (Object)saveorUpdateVO.getOfferEndTime());
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)true);
    }

    @Override
    public NoticeVO queryDetail(Long id) {
        NoticeEntity noticeEntity = (NoticeEntity)((Object)super.selectById((Serializable)id));
        NoticeVO vo = (NoticeVO)BeanMapper.map((Object)((Object)noticeEntity), NoticeVO.class);
        List signEntities = this.signService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SignEntity::getNoticeId, (Object)id)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
        List signVOList = BeanMapper.mapList((Iterable)signEntities, SignVO.class);
        if (CollectionUtils.isNotEmpty((Collection)signEntities)) {
            Long sid = ((SignEntity)((Object)signEntities.get(0))).getId();
            ((SignVO)signVOList.get(0)).setsId(sid);
        }
        vo.setSignList(signVOList);
        ContentEntity contentEntity = (ContentEntity)((Object)this.contentService.getOne((Wrapper)Wrappers.lambdaQuery().eq(ContentEntity::getNoticeId, (Object)id)));
        if (null != contentEntity) {
            vo.setNoticeContent(contentEntity.getNoticeContent());
        }
        return vo;
    }

    @Override
    public NoticeVO queryFileDetail(Long id) {
        List schemeEntityList;
        NoticeEntity noticeEntity = (NoticeEntity)((Object)super.selectById((Serializable)id));
        NoticeVO vo = (NoticeVO)BeanMapper.map((Object)((Object)noticeEntity), NoticeVO.class);
        List signEntities = this.signService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SignEntity::getNoticeId, (Object)id)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
        List signVOList = BeanMapper.mapList((Iterable)signEntities, SignVO.class);
        if (CollectionUtils.isNotEmpty((Collection)signEntities)) {
            Long sid = ((SignEntity)((Object)signEntities.get(0))).getId();
            ((SignVO)signVOList.get(0)).setsId(sid);
        }
        vo.setSignList(signVOList);
        FilecontentEntity filecontentEntity = (FilecontentEntity)((Object)this.filecontentService.getOne((Wrapper)Wrappers.lambdaQuery().eq(FilecontentEntity::getNoticeId, (Object)id)));
        if (null != filecontentEntity) {
            vo.setContent(filecontentEntity.getContent());
        }
        if (CollectionUtils.isNotEmpty((Collection)(schemeEntityList = this.schemeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SchemeEntity::getNoticeId, (Object)id)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid())).orderByAsc(SchemeEntity::getSchemeName))))) {
            schemeEntityList.forEach(e -> {
                List schemeDetailEntities = null;
                schemeDetailEntities = this.schemeDetailService.list((Wrapper)Wrappers.lambdaQuery().eq(SchemeDetailEntity::getSchemeId, (Object)e.getId()));
                e.setSchemeDetailList(schemeDetailEntities);
            });
            vo.setSchemeList(BeanMapper.mapList((Iterable)schemeEntityList, SchemeVO.class));
        }
        return vo;
    }

    @Override
    public List<NoticeVO> queryInvitationList(QueryWrapper queryWrapper, Integer signStatus, String tenantId) {
        return ((NoticeMapper)this.baseMapper).queryInvitation(queryWrapper, signStatus, tenantId);
    }

    @Override
    public NumsVO queryCounts() {
        NumsVO numsVO = new NumsVO();
        List<NoticeVO> list = ((NoticeMapper)this.baseMapper).queryCounts(InvocationInfoProxy.getTenantid() + "");
        numsVO.setDbmnums(list.get(0).getNums());
        numsVO.setYbmnums(list.get(1).getNums());
        numsVO.setDbjnums(list.get(2).getNums());
        numsVO.setQstpnums(list.get(3).getNums());
        numsVO.setBjznums(list.get(4).getNums());
        numsVO.setYdbnums(list.get(5).getNums());
        numsVO.setTtnums(list.get(6).getNums());
        return numsVO;
    }
}

