/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ThirdSystemUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String GCY_CACHE_KEY_PREFIX = "GCY::";

    public String getToken(String tokenUrl, CacheManager cacheManager) {
        String key = "GCY::ACCESS_TOKEN";
        String accessroken = (String)((Object)cacheManager.get(key));
        this.logger.debug("\u83b7\u53d6accessroken:=====" + accessroken);
        if (StringUtils.isBlank((CharSequence)accessroken)) {
            JSONObject result = this.getForObject(tokenUrl);
            JSONObject dataObject = (JSONObject)result.get((Object)"data");
            if (!((Boolean)dataObject.get((Object)"querysucflag")).booleanValue()) {
                throw new BusinessException((String)dataObject.get((Object)"errormsg"));
            }
            accessroken = (String)dataObject.get((Object)"access_token");
            Integer expiresTime = (Integer)dataObject.get((Object)"expires_in");
            cacheManager.setex(key, (Serializable)((Object)accessroken), expiresTime.intValue());
            this.logger.debug("\u83b7\u53d6accessroken:" + accessroken);
        }
        return accessroken;
    }

    public JSONObject getForObject(String url) {
        JSONObject result;
        HashMap headers = new HashMap();
        try {
            result = JSONObject.parseObject((String)HttpTookit.get((String)url, null, headers));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new BusinessException("\u8c03\u7528\u7b2c\u4e09\u65b9\u670d\u52a1\u8c03\u7528\u62a5\u9519");
        }
        return result;
    }

    private CommonResponse<JSONObject> sendGetReq(String tokenUrl, String url, Map<String, Object> params, CacheManager cacheManager) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(5);
        String accessToken = this.getToken(tokenUrl, cacheManager);
        if (null == accessToken) {
            throw new BusinessException("\u83b7\u53d6\u670d\u52a1accessToken\u5931\u8d25\uff01");
        }
        headers.put("access_token", accessToken);
        String reqResp = HttpTookit.get((String)url, params, headers, (int)10000, (int)20000);
        this.logger.info("\u53d1\u9001get\u8bf7\u6c42\u3010\u5730\u5740\uff1a {}, \u53c2\u6570\uff1a{}, header: {}\u3011, \u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{url, JSON.toJSONString(params), headers, reqResp});
        JSONObject jsonData = JSONObject.parseObject((String)reqResp);
        if (0 != Integer.parseInt(jsonData.get((Object)"code").toString())) {
            return CommonResponse.error((String)(null != jsonData.get((Object)"msg") ? jsonData.get((Object)"msg").toString() : "\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff01"));
        }
        return CommonResponse.success((Object)jsonData);
    }

    public CommonResponse<JSONObject> sendPostReq(String tokenUrl, String url, String paramJson, CacheManager cacheManager) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(5);
        String accessToken = this.getToken(tokenUrl, cacheManager);
        if (null == accessToken) {
            throw new BusinessException("\u83b7\u53d6\u670d\u52a1accessToken\u5931\u8d25\uff01");
        }
        headers.put("access_token", accessToken);
        String reqResp = HttpTookit.postByJson((String)url, (String)paramJson, headers, (Integer)10000, (Integer)20000);
        this.logger.info("\u53d1\u9001post\u8bf7\u6c42\u3010\u5730\u5740\uff1a {}, \u53c2\u6570\uff1a{}, header: {}\u3011, \u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{url, paramJson, headers, reqResp});
        JSONObject jsonData = JSONObject.parseObject((String)reqResp);
        if (0 != Integer.parseInt(jsonData.get((Object)"code").toString())) {
            return CommonResponse.error((String)(null != jsonData.get((Object)"msg") ? jsonData.get((Object)"msg").toString() : "\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff01"));
        }
        return CommonResponse.success((Object)jsonData);
    }
}

