/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.winbid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.winbid.bean.WinbidContentEntity;
import com.ejianc.business.supbid.winbid.bean.WinbidEntity;
import com.ejianc.business.supbid.winbid.service.IWinbidContentService;
import com.ejianc.business.supbid.winbid.service.IWinbidService;
import com.ejianc.business.supbid.winbid.vo.WinbidVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"winbid"})
@Api(value="\u4e2d\u6807\u5b9e\u4f53", tags={"\u4e2d\u6807\u5b9e\u4f53"})
public class WinbidController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IWinbidService service;
    @Autowired
    private IWinbidContentService winbidContentService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WinbidVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody WinbidVO saveorUpdateVO) {
        WinbidEntity entity = (WinbidEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, WinbidEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        WinbidVO vo = (WinbidVO)BeanMapper.map((Object)((Object)entity), WinbidVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u5b9a\u6807\u3001\u6d41\u6807\u3001\u5e9f\u6807\u63a8\u9001\u63a5\u53e3")
    @RequestMapping(value={"/winbidSave"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> winbidSave(@RequestBody List<WinbidVO> listVO) {
        return this.service.save(listVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WinbidVO> queryDetail(@RequestParam Long id) {
        WinbidEntity entity = (WinbidEntity)((Object)this.service.selectById(id));
        WinbidVO vo = (WinbidVO)BeanMapper.map((Object)((Object)entity), WinbidVO.class);
        WinbidContentEntity winbidContentEntity = (WinbidContentEntity)((Object)this.winbidContentService.getOne((Wrapper)Wrappers.lambdaQuery().eq(WinbidContentEntity::getWinbidId, (Object)id)));
        if (null != winbidContentEntity) {
            vo.setContent(winbidContentEntity.getContent());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6839\u636e\u7acb\u9879id\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryWinbidDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WinbidVO> queryWinbidDetail(@RequestParam String sourceId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryWinbidDetail(sourceId));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WinbidVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u6807/\u5e9f\u6807\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WinbidVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("winbidType", new Parameter("ne", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WinbidVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Winbid-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refWinbidData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WinbidVO>> refWinbidData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WinbidVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

