package com.ejianc.business.supbid.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.material.bean.SchemeDetailEntity;
import com.ejianc.business.supbid.material.bean.SchemeEntity;
import com.ejianc.business.supbid.material.bean.SchemeRecordEntity;
import com.ejianc.business.supbid.material.service.ISchemeDetailService;
import com.ejianc.business.supbid.material.service.ISchemeRecordService;
import com.ejianc.business.supbid.material.service.ISchemeService;
import com.ejianc.business.supbid.material.vo.SchemeVO;
import com.ejianc.business.supbid.notice.bean.ContentEntity;
import com.ejianc.business.supbid.notice.bean.FilecontentEntity;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.mapper.NoticeMapper;
import com.ejianc.business.supbid.notice.service.IContentService;
import com.ejianc.business.supbid.notice.service.IFilecontentService;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.notice.vo.*;
import com.ejianc.business.supbid.util.ThirdSystemUtils;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 公告实体
 * 
 * @author generator
 * 
 */
@Service("noticeService")
public class NoticeServiceImpl extends BaseServiceImpl<NoticeMapper, NoticeEntity> implements INoticeService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_TYPE = "BT211123000000003";

    @Autowired
    private CacheManager cacheManager;

    @Value("${gcyUrl.signUpUrl}")
    private String signUpUrl;

    @Value("${gcyUrl.pushSellUrl}")
    private String pushSellUrl;

    @Value("${gcyUrl.tokenUrl}")
    private String tokenUrl;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IContentService contentService;

    @Autowired
    private INoticeService service;

    @Autowired
    private IFilecontentService filecontentService;

    @Autowired
    private ISchemeService schemeService;
    @Autowired
    private ISchemeRecordService schemeRecordService;
    @Autowired
    private ISchemeDetailService schemeDetailService;
    @Autowired
    private ISignService signService;

    @Override
    public CommonResponse<Boolean> save2(HttpServletRequest request, MultipartFile[] files,MultipartFile file1) {
        logger.info("进入接口--");
        logger.info("request--"+request);
        String notice = request.getParameter("noticeEntity");
        logger.info("实体信息--"+notice);
        NoticeVO saveorUpdateVO = JSON.parseObject(notice, new TypeReference<NoticeVO>() { });

        boolean flag = false;
        saveorUpdateVO.setAbolishType(0);
        if(0==saveorUpdateVO.getNoticeType()){//公告
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getNoticeContent())){
                ContentEntity contentEntity = new ContentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setNoticeContent(saveorUpdateVO.getNoticeContent());
                contentService.save(contentEntity);
            }
            if(1==saveorUpdateVO.getTenderType()){
                //邀请招标  需要生成报名表，状态为待报名
                List<SignEntity> signEntities = new ArrayList<>();
                List<ApplyVO> applyVOList = saveorUpdateVO.getApplyList();
                if(CollectionUtils.isNotEmpty(applyVOList)){
                    applyVOList.forEach(e->{
                        SignEntity signEntity = new SignEntity();
                        signEntity.setSourceId(saveorUpdateVO.getSourceId());
                        signEntity.setNoticeId(entity.getId());
                        signEntity.setSignStatus(9);//待报名
                        signEntity.setSourceSupplierId(e.getSourceSupplierId());
                        signEntity.setTenantId(e.getTenantId());
                        signEntities.add(signEntity);
                    });
                    signService.saveOrUpdateBatch(signEntities);
                }
            }

            //上传附件
            if(null!=files&&files.length>0){
                logger.info(request+"文件流信息--"+files.length);
                for(int i=0;i<files.length;i++){
                    Boolean upFlag = this.upFile("noticeFiles",Long.toString(entity.getId()),"",files[i],request);
                    logger.info(request+"文件上传结果--"+upFlag+"----"+i);
                }
            }

        }else if(1==saveorUpdateVO.getNoticeType()){//文件
            NoticeEntity noticeEntity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId()));
            noticeEntity.setProjectLinkName(saveorUpdateVO.getProjectLinkName());
            noticeEntity.setProjectLinkPhone(saveorUpdateVO.getProjectLinkPhone());
            noticeEntity.setOfferStartTime(saveorUpdateVO.getOfferStartTime());
            noticeEntity.setOfferEndTime(saveorUpdateVO.getOfferEndTime());
            noticeEntity.setBrandFlag(saveorUpdateVO.getBrandFlag());
            noticeEntity.setMemo(saveorUpdateVO.getMemo());
//            upFile(String sourceType,String sourceId,String billType,InputStream inputStream,String fileName,HttpRequest request)
//            logger.info("文件流信息--"+saveorUpdateVO.getInputStream());
//            Boolean upFlag = this.upFile("noticeFile","","BT211123000000003",saveorUpdateVO.getInputStream(),"123.jpg",request);
//            logger.info("上传返回信息--"+upFlag);
            flag = super.saveOrUpdate(noticeEntity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(noticeEntity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }
            //需将状态改为已报名的数据改为  待报价
            LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SignEntity::getSourceId,saveorUpdateVO.getSourceId());
            updateWrapper.eq(SignEntity::getSignStatus,0);//查询已报名
            updateWrapper.set(SignEntity::getSignStatus,1);//待报价
            signService.update(updateWrapper);
            //上传附件
            if(null!=files&&files.length>0){
                logger.info(request+"文件流信息--"+files.length);
                for(int i=0;i<files.length;i++){
                    Boolean upFlag = this.upFile("noticeFiles",Long.toString(noticeEntity.getId()),BILL_TYPE,files[i],request);
                    logger.info(request+"文件上传结果--"+upFlag+"----"+i);
                }
            }
            if(null!=file1){
                logger.info(request+"文件模板--"+file1.getOriginalFilename());
                Boolean upFlag = this.upFile("templateFiles",Long.toString(noticeEntity.getId()),BILL_TYPE,file1,request);
                logger.info(request+"文件上传结果--"+upFlag);
            }

        }else if(2==saveorUpdateVO.getNoticeType()){
            //询价
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }
            //上传附件
            if(null!=files&&files.length>0){
                logger.info(request+"文件流信息--"+files.length);
                for(int i=0;i<files.length;i++){
                    Boolean upFlag = this.upFile("noticeFiles",Long.toString(entity.getId()),BILL_TYPE,files[i],request);
                    logger.info(request+"文件上传结果--"+upFlag+"----"+i);
                }
            }
        }else if(3==saveorUpdateVO.getNoticeType()){
            //  竞争性/单一来源/紧急性   默认均为邀请供应商
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }

            List<SignEntity> signEntities = new ArrayList<>();
            List<ApplyVO> applyVOList = saveorUpdateVO.getApplyList();
            if(CollectionUtils.isNotEmpty(applyVOList)){
                applyVOList.forEach(e->{
                    SignEntity signEntity = new SignEntity();
                    signEntity.setSourceId(saveorUpdateVO.getSourceId());
                    signEntity.setNoticeId(entity.getId());
                    signEntity.setSignStatus(1);//待报价
                    signEntity.setSourceSupplierId(e.getSourceSupplierId());
                    signEntity.setTenantId(e.getTenantId());
                    signEntities.add(signEntity);
                });
                signService.saveOrUpdateBatch(signEntities);
            }
            //上传附件
            if(null!=files&&files.length>0){
                logger.info(request+"文件流信息--"+files.length);
                for(int i=0;i<files.length;i++){
                    Boolean upFlag = this.upFile("noticeFiles",Long.toString(entity.getId()),BILL_TYPE,files[i],request);
                    logger.info(request+"文件上传结果--"+upFlag+"----"+i);
                }
            }
        }else if(4==saveorUpdateVO.getNoticeType()){
            if(null!=saveorUpdateVO.getTalkNum()&&1==saveorUpdateVO.getTalkNum()){
                //如果是第一轮   需根据sourceId与传来的tenantId将子表复制到历史记录表
                List<SchemeEntity> schemeEntityList = schemeService.list((Wrappers.<SchemeEntity>lambdaQuery().eq(SchemeEntity::getSourceId, saveorUpdateVO.getSourceId())));
                if(CollectionUtils.isNotEmpty(schemeEntityList)){
                    schemeEntityList.forEach(e->{
                        SchemeEntity schemeEntity = schemeService.selectById(e.getId());
                        SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity,SchemeRecordEntity.class);
                        schemeRecordEntity.setId(null);
                        schemeRecordEntity.setTalkNum(0);//首轮
                        schemeRecordEntity.getSchemeDetailList().forEach(k->{
                            k.setId(null);
                            k.setSchemeId(null);
                        });
                        schemeRecordService.saveOrUpdate(schemeRecordEntity,false);
                    });
                }
            }
            //  洽商谈判 主表更新字段
            NoticeEntity entity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId()));
            entity.setTenderName(saveorUpdateVO.getTenderName());
            entity.setOfferStartTime(saveorUpdateVO.getOfferStartTime());
            entity.setOfferEndTime(saveorUpdateVO.getOfferEndTime());
            entity.setTalkMoney(saveorUpdateVO.getTalkMoney());
            entity.setTalkNum(saveorUpdateVO.getTalkNum());
            entity.setMemo(saveorUpdateVO.getMemo());
            flag = super.saveOrUpdate(entity, false);
            //将未淘汰的报名状态改为洽商谈判
            List<SignEntity> signEntities = signService.list(Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getNoticeId,entity.getId()).eq(SignEntity::getSourceId, saveorUpdateVO.getSourceId()).ne(SignEntity::getSignStatus,5));
            if(CollectionUtils.isNotEmpty(signEntities)){
                signEntities.forEach(e->{
                    e.setSignStatus(2);//洽商谈判
                });
                signService.saveOrUpdateBatch(signEntities);
            }
            //上传附件
            if(null!=files&&files.length>0){
                logger.info(request+"文件流信息--"+files.length);
                for(int i=0;i<files.length;i++){
                    Boolean upFlag = this.upFile("noticeFiles",Long.toString(entity.getId()),BILL_TYPE,files[i],request);
                    logger.info(request+"文件上传结果--"+upFlag+"----"+i);
                }
            }
        }
        return CommonResponse.success("保存或修改单据成功！",flag);

    }

    @Override
    public CommonResponse<Boolean> save(NoticeVO saveorUpdateVO) {
        boolean flag = false;
        saveorUpdateVO.setAbolishType(0);
        if(0==saveorUpdateVO.getNoticeType()){//公告
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getNoticeContent())){
                ContentEntity contentEntity = new ContentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setNoticeContent(saveorUpdateVO.getNoticeContent());
                contentService.save(contentEntity);
            }
            if(1==saveorUpdateVO.getTenderType()){
                //邀请招标  需要生成报名表，状态为待报名
                List<SignEntity> signEntities = new ArrayList<>();
                List<ApplyVO> applyVOList = saveorUpdateVO.getApplyList();
                if(CollectionUtils.isNotEmpty(applyVOList)){
                    applyVOList.forEach(e->{
                        SignEntity signEntity = new SignEntity();
                        signEntity.setSourceId(saveorUpdateVO.getSourceId());
                        signEntity.setNoticeId(entity.getId());
                        signEntity.setSignStatus(9);//待报名
                        signEntity.setSourceSupplierId(e.getSourceSupplierId());
                        signEntity.setTenantId(e.getTenantId());
                        signEntities.add(signEntity);
                    });
                    signService.saveOrUpdateBatch(signEntities);
                }
            }
        }else if(1==saveorUpdateVO.getNoticeType()){//文件
            NoticeEntity noticeEntity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId()));
            noticeEntity.setProjectLinkName(saveorUpdateVO.getProjectLinkName());
            noticeEntity.setProjectLinkPhone(saveorUpdateVO.getProjectLinkPhone());
            noticeEntity.setOfferStartTime(saveorUpdateVO.getOfferStartTime());
            noticeEntity.setOfferEndTime(saveorUpdateVO.getOfferEndTime());
            noticeEntity.setBrandFlag(saveorUpdateVO.getBrandFlag());
            noticeEntity.setMemo(saveorUpdateVO.getMemo());
            flag = super.saveOrUpdate(noticeEntity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(noticeEntity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }
            //需将状态改为已报名的数据改为  待报价
            LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SignEntity::getSourceId,saveorUpdateVO.getSourceId());
            updateWrapper.eq(SignEntity::getSignStatus,0);//查询已报名
            updateWrapper.set(SignEntity::getSignStatus,1);//待报价
            signService.update(updateWrapper);
        }else if(2==saveorUpdateVO.getNoticeType()){
            //询价
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }
        }else if(3==saveorUpdateVO.getNoticeType()){
            //  竞争性/单一来源/紧急性   默认均为邀请供应商
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }

            List<SignEntity> signEntities = new ArrayList<>();
            List<ApplyVO> applyVOList = saveorUpdateVO.getApplyList();
            if(CollectionUtils.isNotEmpty(applyVOList)){
                applyVOList.forEach(e->{
                    SignEntity signEntity = new SignEntity();
                    signEntity.setSourceId(saveorUpdateVO.getSourceId());
                    signEntity.setNoticeId(entity.getId());
                    signEntity.setSignStatus(1);//待报价
                    signEntity.setSourceSupplierId(e.getSourceSupplierId());
                    signEntity.setTenantId(e.getTenantId());
                    signEntities.add(signEntity);
                });
                signService.saveOrUpdateBatch(signEntities);
            }
        }else if(4==saveorUpdateVO.getNoticeType()){
            if(null!=saveorUpdateVO.getTalkNum()&&1==saveorUpdateVO.getTalkNum()){
                //如果是第一轮   需根据sourceId与传来的tenantId将子表复制到历史记录表
                List<SchemeEntity> schemeEntityList = schemeService.list((Wrappers.<SchemeEntity>lambdaQuery().eq(SchemeEntity::getSourceId, saveorUpdateVO.getSourceId())));
                if(CollectionUtils.isNotEmpty(schemeEntityList)){
                    schemeEntityList.forEach(e->{
                        SchemeEntity schemeEntity = schemeService.selectById(e.getId());
                        SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity,SchemeRecordEntity.class);
                        schemeRecordEntity.setId(null);
                        schemeRecordEntity.setTalkNum(0);//首轮
                        schemeRecordEntity.getSchemeDetailList().forEach(k->{
                            k.setId(null);
                            k.setSchemeId(null);
                        });
                        schemeRecordService.saveOrUpdate(schemeRecordEntity,false);
                    });
                }
            }
            //  洽商谈判 主表更新字段
            NoticeEntity entity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId()));
            entity.setTenderName(saveorUpdateVO.getTenderName());
            entity.setOfferStartTime(saveorUpdateVO.getOfferStartTime());
            entity.setOfferEndTime(saveorUpdateVO.getOfferEndTime());
            entity.setTalkMoney(saveorUpdateVO.getTalkMoney());
            entity.setTalkNum(saveorUpdateVO.getTalkNum());
            entity.setMemo(saveorUpdateVO.getMemo());
            flag = super.saveOrUpdate(entity, false);
            //将未淘汰的报名状态改为洽商谈判
            List<SignEntity> signEntities = signService.list(Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getNoticeId,entity.getId()).eq(SignEntity::getSourceId, saveorUpdateVO.getSourceId()).ne(SignEntity::getSignStatus,5));
            if(CollectionUtils.isNotEmpty(signEntities)){
                signEntities.forEach(e->{
                    e.setSignStatus(2);//洽商谈判
                });
                signService.saveOrUpdateBatch(signEntities);
            }
        }

        return CommonResponse.success("保存或修改单据成功！",flag);
    }


    @Override
    public CommonResponse<NoticeVO> saveFile(NoticeVO saveorUpdateVO) throws Exception {
        NoticeVO dbVo = queryFileDetail(saveorUpdateVO.getId());
        List<SchemeVO> schemeVOList = saveorUpdateVO.getSchemeList();
        List<SchemeVO> delList = new ArrayList<>();//删除的数据
        List<SchemeVO> dbList = dbVo.getSchemeList();//数据库里的数据
        List<SignVO> signVOList = saveorUpdateVO.getSignList();
        NoticeVO resVo = null;
        NoticeEntity noticeEntity = null;
        if(null!=saveorUpdateVO.getTalkNum()&&0<saveorUpdateVO.getTalkNum()){
            //说明是洽商谈判保存  这种场景不允许修改保存
            //1,将原子表数据 移到记录表
            if(CollectionUtils.isNotEmpty(schemeVOList)){
                schemeVOList.forEach(e->{
                    SchemeEntity schemeEntity = schemeService.selectById(e.getId());
                    SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity,SchemeRecordEntity.class);
                    schemeRecordEntity.setId(null);
                    schemeRecordEntity.setTalkNum(saveorUpdateVO.getTalkNum());//首轮
                    schemeRecordEntity.getSchemeDetailList().forEach(k->{
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    schemeRecordService.saveOrUpdate(schemeRecordEntity,false);
                });
            }
            //新增修改的数据
            List<SchemeEntity> schemeEntityList=BeanMapper.mapList(schemeVOList,SchemeEntity.class);
            schemeEntityList.forEach(e->{
                schemeService.saveOrUpdate(e,false);
            });
            resVo = queryFileDetail(saveorUpdateVO.getId());
        }else{
            if(CollectionUtils.isNotEmpty(schemeVOList)){
                Map<Long,String> map = new HashMap<>();
                schemeVOList.forEach(k->{
                    if(null!=k.getId()){
                        map.put(k.getId(),k.getSchemeName());
                    }
                });

                if(CollectionUtils.isNotEmpty(dbList)){
                    dbList.forEach(d->{
                        if(!map.containsKey(d.getId())){
                            delList.add(d);
                        }
                    });
                }
                if(CollectionUtils.isNotEmpty(delList)){
                    schemeService.removeByIds(delList,false);
                }
                //新增修改的数据
                List<SchemeEntity> schemeEntityList=BeanMapper.mapList(schemeVOList,SchemeEntity.class);
                schemeEntityList.forEach(e->{
                    schemeService.saveOrUpdate(e,false);
                });
            }
            resVo = queryFileDetail(saveorUpdateVO.getId());
        }
        SignEntity signEntity = null;
        if(2==saveorUpdateVO.getTenderType()&&null==signVOList.get(0).getsId()){
            signEntity = BeanMapper.map(signVOList.get(0),SignEntity.class);
            signEntity.setSourceId(saveorUpdateVO.getSourceId());
            signEntity.setNoticeId(saveorUpdateVO.getId());
            signEntity.setSignStatus(3);//报价中
            signEntity.setSourceSupplierId("1212517281");
            signEntity.setTenantId(InvocationInfoProxy.getTenantid());
        }else{
            signEntity = signService.selectById(signVOList.get(0).getsId());
            signEntity.setSignEmployeeId(signVOList.get(0).getSignEmployeeId());
            signEntity.setSignEmployeeMobile(signVOList.get(0).getSignEmployeeMobile());
            signEntity.setSignEmployeeName(signVOList.get(0).getSignEmployeeName());
            signEntity.setInvoiceNote(signVOList.get(0).getInvoiceNote());
            signEntity.setSignStatus(3);
        }
        signService.saveOrUpdate(signEntity,false);
        //调用第三方报名接口 推送报价
        BjNoticeVO bjNoticeVO =  BeanMapper.map(signEntity,BjNoticeVO.class);
        bjNoticeVO.setSourceSupplierId(signEntity.getSourceSupplierId());
        bjNoticeVO.setSchemeTime(new Date());
        bjNoticeVO.setEmployeeId(signEntity.getSignEmployeeId());
        bjNoticeVO.setEmployeeName(signEntity.getSignEmployeeName());
        bjNoticeVO.setEmployeeMobile(signEntity.getSignEmployeeMobile());
        bjNoticeVO.setDetailList(resVo.getDetailList());
        bjNoticeVO.setSchemeList(resVo.getSchemeList());
        CommonResponse<JSONObject> response = null;
        response = new ThirdSystemUtils().sendPostReq(tokenUrl,pushSellUrl, JSON.toJSONString(bjNoticeVO),cacheManager);
        if(!response.isSuccess()) {
            throw new BusinessException("调用第三方接口失败!");
        }
        return CommonResponse.success("保存或修改单据成功！",resVo);
    }

    @Override
    public CommonResponse<Boolean> updateTime(NoticeVO saveorUpdateVO) {
        LambdaUpdateWrapper<NoticeEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(NoticeEntity::getSourceId,saveorUpdateVO.getSourceId());
        if(null!=saveorUpdateVO.getNoticeEndTime()){
            updateWrapper.set(NoticeEntity::getNoticeEndTime,saveorUpdateVO.getNoticeEndTime());
        }
        if(null!=saveorUpdateVO.getOfferEndTime()){
            updateWrapper.set(NoticeEntity::getOfferEndTime,saveorUpdateVO.getOfferEndTime());
        }
        return CommonResponse.success("修改成功！",service.update(updateWrapper));
    }

    @Override
    public Boolean updateSupOffer(List<SupOfferVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)){
            vos.forEach(e->{
                List<SchemeEntity> schemeEntityList = schemeService.list((Wrappers.<SchemeEntity>lambdaQuery().eq(SchemeEntity::getSourceId, e.getSourceId())).eq(SchemeEntity::getTenantId, e.getTenantId()));
                if(CollectionUtils.isNotEmpty(schemeEntityList)){
                    schemeEntityList.forEach(i->{
                        SchemeEntity schemeEntity = schemeService.selectById(i.getId());
                        SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity,SchemeRecordEntity.class);
                        schemeRecordEntity.setId(null);
                        schemeRecordEntity.setTalkNum(e.getTalkNum());
                        schemeRecordEntity.getSchemeDetailList().forEach(k->{
                            k.setId(null);
                            k.setSchemeId(null);
                        });
                        schemeRecordService.saveOrUpdate(schemeRecordEntity,false);
                    });
                }
            });
        }
        return true;
    }

    @Override
    public NoticeVO queryDetail(Long id) {
        NoticeEntity noticeEntity = super.selectById(id);
        NoticeVO vo = BeanMapper.map(noticeEntity, NoticeVO.class);
        List<SignEntity> signEntities = signService.list(Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getNoticeId, id).eq(SignEntity::getTenantId,InvocationInfoProxy.getTenantid()));
        List<SignVO> signVOList =  BeanMapper.mapList(signEntities, SignVO.class);
        List<SignVO> signList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(signEntities)){
            Long sid = signEntities.get(0).getId();
            signVOList.get(0).setsId(sid);
            signList.add(signVOList.get(0));
            vo.setSignList(signList);
        }
        ContentEntity contentEntity = contentService.getOne((Wrappers.<ContentEntity>lambdaQuery().eq(ContentEntity::getNoticeId, id)));
        if(null!=contentEntity){
            vo.setNoticeContent(contentEntity.getNoticeContent());
        }
        return vo;
    }

    @Override
    public NoticeVO queryFileDetail(Long id) {
        NoticeEntity noticeEntity = super.selectById(id);
        NoticeVO vo = BeanMapper.map(noticeEntity, NoticeVO.class);
        List<SignEntity> signEntities = signService.list(Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getNoticeId, id).eq(SignEntity::getTenantId,InvocationInfoProxy.getTenantid()));
        List<SignVO> signVOList =  BeanMapper.mapList(signEntities, SignVO.class);
        List<SignVO> signList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(signEntities)){
            Long sid = signEntities.get(0).getId();
            signVOList.get(0).setsId(sid);
            signList.add(signVOList.get(0));
            vo.setSignList(signList);
        }

        FilecontentEntity filecontentEntity = filecontentService.getOne((Wrappers.<FilecontentEntity>lambdaQuery().eq(FilecontentEntity::getNoticeId, id)));
        if(null!=filecontentEntity){
            vo.setContent(filecontentEntity.getContent());
        }
        //查询方案信息
        List<SchemeEntity> schemeEntityList = schemeService.list((Wrappers.<SchemeEntity>lambdaQuery().eq(SchemeEntity::getNoticeId, id)).eq(SchemeEntity::getTenantId, InvocationInfoProxy.getTenantid()).orderByAsc(SchemeEntity::getSchemeName));
        if(CollectionUtils.isNotEmpty(schemeEntityList)){
            schemeEntityList.forEach(e->{
                List<SchemeDetailEntity> schemeDetailEntities = null;
                schemeDetailEntities = schemeDetailService.list((Wrappers.<SchemeDetailEntity>lambdaQuery().eq(SchemeDetailEntity::getSchemeId, e.getId())));
                e.setSchemeDetailList(schemeDetailEntities);
            });
            vo.setSchemeList(BeanMapper.mapList(schemeEntityList,SchemeVO.class));
        }
        return vo;
    }

    @Override
    public List<NoticeVO> queryInvitationList(QueryWrapper queryWrapper, Integer signStatus,String tenantId) {
        return baseMapper.queryInvitation(queryWrapper,signStatus,tenantId);
    }

    @Override
    public NumsVO queryCounts() {
        NumsVO numsVO = new NumsVO();
        List<NoticeVO> list = baseMapper.queryCounts(InvocationInfoProxy.getTenantid()+"");
        numsVO.setDbmnums(list.get(0).getNums());
        numsVO.setYbmnums(list.get(1).getNums());
        numsVO.setDbjnums(list.get(2).getNums());
        numsVO.setQstpnums(list.get(3).getNums());
        numsVO.setBjznums(list.get(4).getNums());
        numsVO.setYdbnums(list.get(5).getNums());
        numsVO.setTtnums(list.get(6).getNums());
        return numsVO;
    }


    public boolean upFile(String sourceType,String sourceId,String billType,MultipartFile file,HttpServletRequest request){
        String authority = request.getHeader("authority");
        logger.info("获取认证信息--"+authority);
        if(null != authority) {
            InvocationInfoProxy.setExtendAttribute("authority", authority);
            Map<String,String> params = new HashMap<>();
            params.put("sourceType", sourceType);
            params.put("sourceId", sourceId);
            params.put("billType", billType);
            params.put("originalFileNameStr", file.getOriginalFilename());
            Map<String,String> headers = new HashMap<>();
            headers.put("authority", authority);
            AttachmentVO attachmentVO = null;
            try {
                //保存新的模板文件
                String fileUploadRespStr = postFile(BASE_HOST +"ejc-file-web/attachment/upload", params, headers, file.getInputStream(),file.getOriginalFilename());
                logger.info("模板文件信息--"+fileUploadRespStr);
                CommonResponse<List<AttachmentVO>> attachmentResp = JSONObject.parseObject(fileUploadRespStr, CommonResponse.class);
                logger.info("上传文件返回信息--"+attachmentResp);
                if(!attachmentResp.isSuccess()) {
                    logger.error("保存模板文件失败sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, 原因：{}",
                            sourceId, sourceType, billType, file.getOriginalFilename(), attachmentResp.getMsg());
                    return false;
                }
                attachmentVO = JSONObject.parseObject(JSONObject.toJSONString(attachmentResp.getData().get(0)), AttachmentVO.class);
            } catch (Exception e) {
                logger.error("保存模板文件失败sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, 原因：{}",
                        sourceId, sourceType, billType, file.getOriginalFilename(), e.getMessage());
                return false;
            }
            logger.info("模板文件保存成功：{}", JSONObject.toJSONString(attachmentVO));
        } else {
            return false;
        }
        return true;
    }

    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, InputStream inputStream,String fileName) throws Exception {
        String charset = "UTF-8";
        HttpClient client = null;

        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        Integer readTimeout = 10000;

        try {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("file",
                        inputStream, ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), fileName);
                for(String key : params.keySet()) {
                    builder.addPart(key, new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
                }
                HttpEntity entity = builder.build();
                post.setEntity(entity);

                RequestConfig.Builder customReqConf = RequestConfig.custom();
                if (connTimeout != null) {
                    customReqConf.setConnectTimeout(connTimeout);
            }

            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout);
            }

            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key = null;
                Iterator it = headers.keySet().iterator();

                while(it.hasNext()) {
                    key = (String)it.next();
                    post.addHeader(key, (String)headers.get(key));
                }
            } else {
                request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }

            HttpResponse res;
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = ((HttpClient)client).execute(post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager(cm).build();
                res = ((HttpClient)client).execute(post);
            }

            result = IOUtils.toString(res.getEntity().getContent(), charset);
        } finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
        }

        return result;
    }
}
