package com.ejianc.business.supbid.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.vo.BmNoticeVO;
import com.ejianc.business.supbid.notice.vo.NoticeVO;
import com.ejianc.business.supbid.notice.vo.NumsVO;
import com.ejianc.business.supbid.notice.vo.SignVO;
import com.ejianc.business.supbid.util.SendMsgUtils;
import com.ejianc.business.supbid.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import feign.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.notice.mapper.SignMapper;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.ISignService;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 报名实体
 *
 * @author generator
 */
@Service("signService")
public class SignServiceImpl extends BaseServiceImpl<SignMapper, SignEntity> implements ISignService {

    /** 废标标志：0-正常 */
    private static final Integer ABOLISH_TYPE_0 = 0;
    /** 废标标志：1-流标 */
    private static final Integer ABOLISH_TYPE_1 = 1;
    /** 废标标志：2-废标 */
    private static final Integer ABOLISH_TYPE_2 = 2;
    /** 采购方式：1-单位采购 */
    private static final Integer PURCHASE_TYPE_1 = 1;

    @Autowired
    private CacheManager cacheManager;

    @Value("${gcyUrl.signUpUrl}")
    private String signUpUrl;

    @Value("${gcyUrl.tokenUrl}")
    private String tokenUrl;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private INoticeService noticeService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public CommonResponse<SignVO> save(SignVO saveorUpdateVO) {
        SignEntity entity = BeanMapper.map(saveorUpdateVO, SignEntity.class);
        if (null != saveorUpdateVO.getsId()) {
            entity.setId(saveorUpdateVO.getsId());
        }
        entity.setSourceSupplierId("478618055086850100");
        entity.setSignStatus(0);//已报名

        BmNoticeVO bmNoticeVO = BeanMapper.map(entity, BmNoticeVO.class);
        Long attachId = null;
        if (CollectionUtils.isNotEmpty(saveorUpdateVO.getAttachIds())) {
            attachId = saveorUpdateVO.getAttachIds().get(0);
            InputStream inputStream = null;
            try {
                Response fileResponse = attachmentApi.downloadFileById(attachId);
                Response.Body body = fileResponse.body();
                inputStream = body.asInputStream();
                bmNoticeVO.setInputStream(inputStream);
                bmNoticeVO.setFileName("123");
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        bmNoticeVO.setEmployeeId(entity.getSignEmployeeId());
        bmNoticeVO.setEmployeeName(entity.getSignEmployeeName());
        bmNoticeVO.setEmployeeMobile(entity.getSignEmployeeMobile());
        bmNoticeVO.setTenantId(InvocationInfoProxy.getTenantid());
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        String now = sdf.format(new Date());
        bmNoticeVO.setSignTime(new Date());
        bmNoticeVO.setSourceSupplierId(entity.getSourceSupplierId());
        bmNoticeVO.setSupplierName("腾讯小马哥");
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        try {
            response = new ThirdSystemUtils()
                    .sendPostReq(tokenUrl, signUpUrl, JSON.toJSONString(bmNoticeVO), cacheManager);
            if (!response.isSuccess()) {
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }

        super.saveOrUpdate(entity, false);
        SignVO vo = BeanMapper.map(entity, SignVO.class);
        vo.setsId(entity.getId());
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public Boolean updateSignStatus(List<SignVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            vos.forEach(e->{
                LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(SignEntity::getTenantId, e.getTenantId());
                updateWrapper.eq(SignEntity::getSourceId, e.getSourceId());
                updateWrapper.eq(SignEntity::getSourceSupplierId, e.getSourceSupplierId());
                updateWrapper.set(SignEntity::getSignStatus, 5);//已淘汰
                updateWrapper.set(SignEntity::getOutReason, e.getOutReason());
                super.update(updateWrapper);
            });
        }
        return true;
    }

    @Override
    public Boolean updateBidOut(String sourceId, int type, String outReason) {
        LambdaUpdateWrapper<NoticeEntity> updateWrappern = new LambdaUpdateWrapper<>();
        updateWrappern.eq(NoticeEntity::getSourceId, sourceId);
        updateWrappern.set(NoticeEntity::getAbolishType, type);
        noticeService.update(updateWrappern);

        LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SignEntity::getSourceId, sourceId);
        updateWrapper.ne(SignEntity::getSignStatus, 5);
        updateWrapper.set(SignEntity::getSignStatus, 5);//已淘汰
        updateWrapper.set(SignEntity::getOutReason, outReason);
        boolean flag = super.update(updateWrapper);
        // 推送内部消息
        if (ABOLISH_TYPE_1.equals(type) || ABOLISH_TYPE_2.equals(type)) {
            String text = "";
            if (ABOLISH_TYPE_1.equals(type)) text = "已流标";
            if (ABOLISH_TYPE_2.equals(type)) text = "已废标";
            // 查询所需信息
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("sourceId",new Parameter(QueryParam.EQ, sourceId));
            List<SignEntity> signEntityList = super.queryList(queryParam);
            List<NoticeEntity> noticeEntityList = noticeService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty(signEntityList) && CollectionUtils.isNotEmpty(noticeEntityList)) {
                // 接收消息的user
                List<String> userList = new ArrayList<>();
                for (SignEntity sign : signEntityList) {
                    if (sign.getSignId() != null) {
                        userList.add(sign.getSignId().toString()); // 报名操作人
                    }
                    if (sign.getSchemeId() != null) {
                        userList.add(sign.getSchemeId().toString()); // 报价操作人
                    }
                }
                // 去重，防止一个人接收到多条相同的信息
                userList = userList.stream().distinct().collect(Collectors.toList());
                // 获取公告信息
                NoticeEntity noticeEntity = noticeEntityList.get(0);
                String projectName = noticeEntity.getProjectName();
                // 单位采购使用orgName
                if (PURCHASE_TYPE_1.equals(noticeEntity.getPurchaseType())) projectName = noticeEntity.getOrgName();
                // 组装标题及内容
                String formurl = baseHost + "ejc-supbid-frontend/#/eliminated?id=" + noticeEntity.getId();
                String subject = "【" + noticeEntity.getUnitName() + "】招标的【" + projectName + "】" + text;
                String content = "【" + noticeEntity.getUnitName() + "】招标的【" + projectName + "】" + text +
                        "，<a href= '" + formurl + "'" + ">点击查看详情</a>";
                new SendMsgUtils().sendSysMsg(userList, subject, content, pushMessageApi);
            }
        }
        return flag;
    }
}

