/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.notice.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.vo.NoticeVO;
import com.ejianc.business.supbid.notice.vo.NumsVO;
import com.ejianc.business.supbid.notice.vo.SupOfferVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"notice"})
@Api(value="\u516c\u544a\u5b9e\u4f53", tags={"\u516c\u544a\u5b9e\u4f53"})
public class NoticeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private INoticeService service;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody NoticeVO saveorUpdateVO) {
        return this.service.save(saveorUpdateVO);
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate2"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> saveOrUpdate2(HttpServletRequest request, @RequestParam(value="file") MultipartFile[] files, MultipartFile file1) {
        return this.service.save2(request, files, file1);
    }

    @ApiOperation(value="\u6587\u4ef6\u65b0\u589e")
    @RequestMapping(value={"/saveFile"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<NoticeVO> saveFile(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody NoticeVO saveorUpdateVO) throws Exception {
        return this.service.saveFile(saveorUpdateVO);
    }

    @ApiOperation(value="\u5ef6\u957f\u622a\u6b62\u65f6\u95f4")
    @RequestMapping(value={"/updateTime"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> updateTime(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody NoticeVO saveorUpdateVO) {
        return this.service.updateTime(saveorUpdateVO);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u8865\u5145\u62a5\u4ef7\u63a5\u53e3")
    @RequestMapping(value={"/updateSupOffer"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> updateSupOffer(@RequestBody List<SupOfferVO> supOfferList) {
        return CommonResponse.success((String)"\u6210\u529f\uff01", (Object)this.service.updateSupOffer(supOfferList));
    }

    @ApiOperation(value="\u516c\u544a\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<NoticeVO> queryDetail(@RequestParam Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @ApiOperation(value="\u6587\u4ef6\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryFileDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<NoticeVO> queryFileDetail(@RequestParam Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryFileDetail(id));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<NoticeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u9080\u8bf7\u62db\u6807\u5f85\u62a5\u540d")
    @RequestMapping(value={"/queryApplyList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<NoticeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), NoticeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u62a5\u540d\u72b6\u6001\u5217\u8868")
    @RequestMapping(value={"/querySignList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<NoticeVO>> querySignList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        param.getOrderMap().put("create_time", "desc");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Integer signStatus = Integer.parseInt(((Parameter)param.getParams().get("signStatus")).getValue().toString());
        List<NoticeVO> listres = this.service.queryInvitationList(wrapper, signStatus, InvocationInfoProxy.getTenantid() + "");
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", listres);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u91cf")
    @RequestMapping(value={"/queryCounts"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<NumsVO> queryCounts(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.queryCounts());
    }

    @ApiOperation(value="\u67e5\u8be2\u516c\u5f00\u62db\u6807\u5217\u8868")
    @RequestMapping(value={"/queryAllList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<NoticeVO>> queryAllList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(2);
        ArrayList<Integer> abolishTypeList = new ArrayList<Integer>();
        abolishTypeList.add(1);
        abolishTypeList.add(2);
        param.getParams().put("tenderType", new Parameter("in", list));
        param.getParams().put("abolishType", new Parameter("not_in", abolishTypeList));
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), NoticeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Notice-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refNoticeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<NoticeVO>> refNoticeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), NoticeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

