/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.mapper.SignMapper;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.notice.vo.BmNoticeVO;
import com.ejianc.business.supbid.notice.vo.SignVO;
import com.ejianc.business.supbid.util.SendMsgUtils;
import com.ejianc.business.supbid.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="signService")
public class SignServiceImpl
extends BaseServiceImpl<SignMapper, SignEntity>
implements ISignService {
    private static final Integer ABOLISH_TYPE_0 = 0;
    private static final Integer ABOLISH_TYPE_1 = 1;
    private static final Integer ABOLISH_TYPE_2 = 2;
    private static final Integer PURCHASE_TYPE_1 = 1;
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${gcyUrl.signUpUrl}")
    private String signUpUrl;
    @Value(value="${gcyUrl.tokenUrl}")
    private String tokenUrl;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public CommonResponse<SignVO> save(SignVO saveorUpdateVO) {
        SignEntity entity = (SignEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SignEntity.class));
        if (null != saveorUpdateVO.getsId()) {
            entity.setId(saveorUpdateVO.getsId());
        }
        entity.setSourceSupplierId("478618055086850100");
        entity.setSignStatus(0);
        BmNoticeVO bmNoticeVO = (BmNoticeVO)BeanMapper.map((Object)((Object)entity), BmNoticeVO.class);
        Long attachId = null;
        if (CollectionUtils.isNotEmpty((Collection)saveorUpdateVO.getAttachIds())) {
            attachId = (Long)saveorUpdateVO.getAttachIds().get(0);
            InputStream inputStream = null;
            try {
                Response fileResponse = this.attachmentApi.downloadFileById(attachId);
                Response.Body body = fileResponse.body();
                inputStream = body.asInputStream();
                bmNoticeVO.setInputStream(inputStream);
                bmNoticeVO.setFileName("123");
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        bmNoticeVO.setEmployeeId(entity.getSignEmployeeId());
        bmNoticeVO.setEmployeeName(entity.getSignEmployeeName());
        bmNoticeVO.setEmployeeMobile(entity.getSignEmployeeMobile());
        bmNoticeVO.setTenantId(InvocationInfoProxy.getTenantid());
        bmNoticeVO.setSignTime(new Date());
        bmNoticeVO.setSourceSupplierId(entity.getSourceSupplierId());
        bmNoticeVO.setSupplierName("\u817e\u8baf\u5c0f\u9a6c\u54e5");
        CommonResponse<JSONObject> response = null;
        try {
            response = new ThirdSystemUtils().sendPostReq(this.tokenUrl, this.signUpUrl, JSON.toJSONString((Object)bmNoticeVO), this.cacheManager);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        super.saveOrUpdate((Object)entity, false);
        SignVO vo = (SignVO)BeanMapper.map((Object)((Object)entity), SignVO.class);
        vo.setsId(entity.getId());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public Boolean updateSignStatus(List<SignVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            vos.forEach(e -> {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getTenantId, (Object)e.getTenantId());
                updateWrapper.eq(SignEntity::getSourceId, (Object)e.getSourceId());
                updateWrapper.eq(SignEntity::getSourceSupplierId, (Object)e.getSourceSupplierId());
                updateWrapper.set(SignEntity::getSignStatus, (Object)5);
                updateWrapper.set(SignEntity::getOutReason, (Object)e.getOutReason());
                super.update((Wrapper)updateWrapper);
            });
        }
        return true;
    }

    @Override
    public Boolean updateBidOut(String sourceId, int type, String outReason) {
        LambdaUpdateWrapper updateWrappern = new LambdaUpdateWrapper();
        updateWrappern.eq(NoticeEntity::getSourceId, (Object)sourceId);
        updateWrappern.set(NoticeEntity::getAbolishType, (Object)type);
        this.noticeService.update((Wrapper)updateWrappern);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(SignEntity::getSourceId, (Object)sourceId);
        updateWrapper.ne(SignEntity::getSignStatus, (Object)5);
        updateWrapper.set(SignEntity::getSignStatus, (Object)5);
        updateWrapper.set(SignEntity::getOutReason, (Object)outReason);
        boolean flag = super.update((Wrapper)updateWrapper);
        if (ABOLISH_TYPE_1.equals(type) || ABOLISH_TYPE_2.equals(type)) {
            String text = "";
            if (ABOLISH_TYPE_1.equals(type)) {
                text = "\u5df2\u6d41\u6807";
            }
            if (ABOLISH_TYPE_2.equals(type)) {
                text = "\u5df2\u5e9f\u6807";
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("sourceId", new Parameter("eq", (Object)sourceId));
            List signEntityList = super.queryList(queryParam);
            List noticeEntityList = this.noticeService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)signEntityList) && CollectionUtils.isNotEmpty((Collection)noticeEntityList)) {
                List<Object> userList = new ArrayList();
                for (SignEntity sign : signEntityList) {
                    if (sign.getSignId() != null) {
                        userList.add(sign.getSignId().toString());
                    }
                    if (sign.getSchemeId() == null) continue;
                    userList.add(sign.getSchemeId().toString());
                }
                userList = userList.stream().distinct().collect(Collectors.toList());
                NoticeEntity noticeEntity = (NoticeEntity)((Object)noticeEntityList.get(0));
                String projectName = noticeEntity.getProjectName();
                if (PURCHASE_TYPE_1.equals(noticeEntity.getPurchaseType())) {
                    projectName = noticeEntity.getOrgName();
                }
                String formurl = this.baseHost + "ejc-supbid-frontend/#/eliminated?id=" + noticeEntity.getId();
                String subject = "\u3010" + noticeEntity.getUnitName() + "\u3011\u62db\u6807\u7684\u3010" + projectName + "\u3011" + text;
                String content = "\u3010" + noticeEntity.getUnitName() + "\u3011\u62db\u6807\u7684\u3010" + projectName + "\u3011" + text + "\uff0c<a href= '" + formurl + "'>\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>";
                new SendMsgUtils().sendSysMsg(userList, subject, content, this.pushMessageApi);
            }
        }
        return flag;
    }
}

