/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class ThirdSystemUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String GCY_CACHE_KEY_PREFIX = "GCY::";

    public String getToken(String tokenUrl, CacheManager cacheManager) {
        String key = "GCY::ACCESS_TOKEN";
        String accessroken = (String)((Object)cacheManager.get(key));
        this.logger.debug("\u83b7\u53d6accessroken:=====" + accessroken);
        if (StringUtils.isBlank((CharSequence)accessroken)) {
            JSONObject result = this.getForObject(tokenUrl);
            JSONObject dataObject = (JSONObject)result.get((Object)"data");
            if (!((Boolean)dataObject.get((Object)"querysucflag")).booleanValue()) {
                throw new BusinessException((String)dataObject.get((Object)"errormsg"));
            }
            accessroken = (String)dataObject.get((Object)"access_token");
            Integer expiresTime = (Integer)dataObject.get((Object)"expires_in");
            cacheManager.setex(key, (Serializable)((Object)accessroken), expiresTime.intValue());
            this.logger.debug("\u83b7\u53d6accessroken:" + accessroken);
        }
        return accessroken;
    }

    public JSONObject getForObject(String url) {
        JSONObject result;
        HashMap headers = new HashMap();
        try {
            result = JSONObject.parseObject((String)HttpTookit.get((String)url, null, headers));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new BusinessException("\u8c03\u7528\u7b2c\u4e09\u65b9\u670d\u52a1\u8c03\u7528\u62a5\u9519");
        }
        return result;
    }

    private CommonResponse<JSONObject> sendGetReq(String tokenUrl, String url, Map<String, Object> params, CacheManager cacheManager) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(5);
        String accessToken = this.getToken(tokenUrl, cacheManager);
        if (null == accessToken) {
            throw new BusinessException("\u83b7\u53d6\u670d\u52a1accessToken\u5931\u8d25\uff01");
        }
        headers.put("access_token", accessToken);
        String reqResp = HttpTookit.get((String)url, params, headers, (int)10000, (int)20000);
        this.logger.info("\u53d1\u9001get\u8bf7\u6c42\u3010\u5730\u5740\uff1a {}, \u53c2\u6570\uff1a{}, header: {}\u3011, \u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{url, JSON.toJSONString(params), headers, reqResp});
        JSONObject jsonData = JSONObject.parseObject((String)reqResp);
        if (0 != Integer.parseInt(jsonData.get((Object)"code").toString())) {
            return CommonResponse.error((String)(null != jsonData.get((Object)"msg") ? jsonData.get((Object)"msg").toString() : "\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff01"));
        }
        return CommonResponse.success((Object)jsonData);
    }

    public CommonResponse<JSONObject> sendPostReq(String tokenUrl, String url, String paramJson, CacheManager cacheManager) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(5);
        String accessToken = this.getToken(tokenUrl, cacheManager);
        if (null == accessToken) {
            throw new BusinessException("\u83b7\u53d6\u670d\u52a1accessToken\u5931\u8d25\uff01");
        }
        headers.put("access_token", accessToken);
        String reqResp = HttpTookit.postByJson((String)url, (String)paramJson, headers, (Integer)10000, (Integer)20000);
        this.logger.info("\u53d1\u9001post\u8bf7\u6c42\u3010\u5730\u5740\uff1a {}, \u53c2\u6570\uff1a{}, header: {}\u3011, \u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{url, paramJson, headers, reqResp});
        JSONObject jsonData = JSONObject.parseObject((String)reqResp);
        if (0 != Integer.parseInt(jsonData.get((Object)"code").toString())) {
            return CommonResponse.error((String)(null != jsonData.get((Object)"msg") ? jsonData.get((Object)"msg").toString() : "\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff01"));
        }
        return CommonResponse.success((Object)jsonData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postFile(String tokenUrl, String url, Map<String, String> params, Map<String, String> headers, InputStream inputStream, CacheManager cacheManager, String fileName) throws Exception {
        String charset = "UTF-8";
        CloseableHttpClient client = null;
        String accessToken = this.getToken(tokenUrl, cacheManager);
        if (null == accessToken) {
            throw new BusinessException("\u83b7\u53d6\u670d\u52a1accessToken\u5931\u8d25\uff01");
        }
        headers.put("access_token", accessToken);
        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        Integer readTimeout = 10000;
        try {
            HttpResponse res;
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Charset.forName("UTF-8"));
            if (null != inputStream) {
                builder.addBinaryBody("file", inputStream, ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), fileName);
            }
            for (String key : params.keySet()) {
                builder.addPart(key, (ContentBody)new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key2 = null;
                for (String key2 : headers.keySet()) {
                    post.addHeader(key2, headers.get(key2));
                }
            } else {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
                res = client.execute((HttpUriRequest)post);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        post.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }
}

