/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.winbid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.util.SendMsgUtils;
import com.ejianc.business.supbid.winbid.bean.WinbidContentEntity;
import com.ejianc.business.supbid.winbid.bean.WinbidDetailEntity;
import com.ejianc.business.supbid.winbid.bean.WinbidEntity;
import com.ejianc.business.supbid.winbid.mapper.WinbidMapper;
import com.ejianc.business.supbid.winbid.service.IWinbidContentService;
import com.ejianc.business.supbid.winbid.service.IWinbidDetailService;
import com.ejianc.business.supbid.winbid.service.IWinbidService;
import com.ejianc.business.supbid.winbid.vo.WinbidVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="winbidService")
public class WinbidServiceImpl
extends BaseServiceImpl<WinbidMapper, WinbidEntity>
implements IWinbidService {
    private static final Integer PURCHASE_TYPE_1 = 1;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private ISignService signService;
    @Autowired
    private IWinbidDetailService winbidDetailService;
    @Autowired
    private IWinbidContentService winbidContentService;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public WinbidVO queryWinbidDetail(String sourceId) {
        List list = super.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(WinbidEntity::getSourceId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List winbidEntityList = this.winbidDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(WinbidDetailEntity::getSourceId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
            WinbidEntity winbidEntity = (WinbidEntity)((Object)list.get(0));
            winbidEntity.setWinbidDetailList(winbidEntityList);
            WinbidVO vo = (WinbidVO)BeanMapper.map((Object)((Object)winbidEntity), WinbidVO.class);
            WinbidContentEntity winbidContentEntity = (WinbidContentEntity)((Object)this.winbidContentService.getOne((Wrapper)Wrappers.lambdaQuery().eq(WinbidContentEntity::getWinbidId, (Object)winbidEntity.getId())));
            if (null != winbidContentEntity) {
                vo.setContent(winbidContentEntity.getContent());
            }
            return vo;
        }
        return null;
    }

    @Override
    public CommonResponse<Boolean> save(List<WinbidVO> listVO) {
        if (CollectionUtils.isNotEmpty(listVO)) {
            List signEntityList;
            QueryParam param = new QueryParam();
            param.getParams().put("sourceId", new Parameter("eq", (Object)listVO.get(0).getSourceId()));
            param.getParams().put("signStatus", new Parameter("eq", (Object)5));
            List outSignEntityList = this.signService.queryList(param);
            List outList = outSignEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            listVO.forEach(e -> {
                WinbidEntity winbidEntity = (WinbidEntity)((Object)((Object)BeanMapper.map((Object)e, WinbidEntity.class)));
                super.saveOrUpdate((Object)winbidEntity, false);
                if (StringUtils.isNotEmpty((CharSequence)e.getContent())) {
                    WinbidContentEntity contentEntity = new WinbidContentEntity();
                    contentEntity.setWinbidId(winbidEntity.getId());
                    contentEntity.setContent(e.getContent());
                    this.winbidContentService.save((Object)contentEntity);
                }
                if (null != e.getWinbidType() && 0 == e.getWinbidType()) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.eq(SignEntity::getSourceId, (Object)e.getSourceId());
                    updateWrapper.eq(BaseEntity::getTenantId, (Object)e.getTenantId());
                    updateWrapper.set(SignEntity::getSignStatus, (Object)4);
                    this.signService.update((Wrapper)updateWrapper);
                    LambdaUpdateWrapper updateWrapper2 = new LambdaUpdateWrapper();
                    updateWrapper2.eq(SignEntity::getSourceId, (Object)e.getSourceId());
                    updateWrapper2.ne(SignEntity::getSignStatus, (Object)4);
                    updateWrapper2.set(SignEntity::getSignStatus, (Object)5);
                    updateWrapper2.set(SignEntity::getOutReason, (Object)"\u672a\u4e2d\u6807");
                    this.signService.update((Wrapper)updateWrapper2);
                }
            });
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("sourceId", new Parameter("eq", (Object)listVO.get(0).getSourceId()));
            List noticeEntityList = this.noticeService.queryList(queryParam);
            queryParam.getParams().put("signStatus", new Parameter("eq", (Object)5));
            if (CollectionUtils.isNotEmpty(outList)) {
                queryParam.getParams().put("id", new Parameter("not_in", outList));
            }
            if (CollectionUtils.isNotEmpty((Collection)(signEntityList = this.signService.queryList(queryParam))) && CollectionUtils.isNotEmpty((Collection)noticeEntityList)) {
                List<Object> userList = new ArrayList();
                for (SignEntity sign : signEntityList) {
                    if (sign.getSignId() != null) {
                        userList.add(sign.getSignId().toString());
                    }
                    if (sign.getSchemeId() == null) continue;
                    userList.add(sign.getSchemeId().toString());
                }
                userList = userList.stream().distinct().collect(Collectors.toList());
                NoticeEntity noticeEntity = (NoticeEntity)((Object)noticeEntityList.get(0));
                String projectName = noticeEntity.getProjectName();
                if (PURCHASE_TYPE_1.equals(noticeEntity.getPurchaseType())) {
                    projectName = noticeEntity.getOrgName();
                }
                String formurl = this.baseHost + "ejc-supbid-frontend/#/eliminated?id=" + noticeEntity.getId();
                String subject = "\u5f88\u9057\u61be,\u4f60\u6295\u6807\u7684\u3010" + projectName + "\u3011\u672a\u4e2d\u6807\uff0c\u611f\u8c22\u60a8\u7684\u53c2\u4e0e\uff01";
                String content = "\u5f88\u9057\u61be,\u4f60\u6295\u6807\u7684\u3010" + projectName + "\u3011\u672a\u4e2d\u6807\uff0c\u611f\u8c22\u60a8\u7684\u53c2\u4e0e\uff01\uff0c<a href= '" + formurl + "'>\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>";
                new SendMsgUtils().sendSysMsg(userList, subject, content, this.pushMessageApi);
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)true);
    }
}

