/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.notice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.mapper.SignMapper;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.notice.vo.BmNoticeVO;
import com.ejianc.business.supbid.notice.vo.SignVO;
import com.ejianc.business.supbid.util.SendMsgUtils;
import com.ejianc.business.supbid.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import feign.Response;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="signService")
public class SignServiceImpl
extends BaseServiceImpl<SignMapper, SignEntity>
implements ISignService {
    private static final Integer ABOLISH_TYPE_0 = 0;
    private static final Integer ABOLISH_TYPE_1 = 1;
    private static final Integer ABOLISH_TYPE_2 = 2;
    private static final Integer PURCHASE_TYPE_1 = 1;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${gcyUrl.signUpUrl}")
    private String signUpUrl;
    @Value(value="${gcyUrl.tokenUrl}")
    private String tokenUrl;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public CommonResponse<SignVO> save(SignVO saveorUpdateVO) throws Exception {
        SignEntity entity = (SignEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SignEntity.class));
        if (null != saveorUpdateVO.getsId()) {
            entity.setId(saveorUpdateVO.getsId());
        } else {
            List signEntityList = super.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SignEntity::getSourceId, (Object)saveorUpdateVO.getSourceId())).in(BaseEntity::getTenantId, new Object[]{InvocationInfoProxy.getTenantid()}));
            if (CollectionUtils.isNotEmpty((Collection)signEntityList)) {
                return CommonResponse.error((String)"\u60a8\u7684\u5355\u636e\u5df2\u88ab\u5176\u4ed6\u540c\u4e8b\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
            }
        }
        NoticeEntity noticeEntity = (NoticeEntity)((Object)this.noticeService.selectById(entity.getNoticeId()));
        String systemId = noticeEntity.getSystemId();
        CommonResponse supplierResponse = this.cooperateEnterpriseApi.getCooperateSupplierIdByTenantIdAndEnterpriseId(InvocationInfoProxy.getTenantid(), systemId);
        if (!supplierResponse.isSuccess()) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u4fe1\u606f\uff01");
        }
        String sourceSupplierId = ((Long)supplierResponse.getData()).toString();
        entity.setSourceSupplierId(sourceSupplierId);
        entity.setSignStatus(0);
        super.saveOrUpdate((Object)entity, false);
        SignVO vo = (SignVO)BeanMapper.map((Object)((Object)entity), SignVO.class);
        vo.setsId(entity.getId());
        BmNoticeVO bmNoticeVO = (BmNoticeVO)BeanMapper.map((Object)((Object)entity), BmNoticeVO.class);
        bmNoticeVO.setEmployeeId(entity.getSignEmployeeId());
        bmNoticeVO.setEmployeeName(entity.getSignEmployeeName());
        bmNoticeVO.setEmployeeMobile(entity.getSignEmployeeMobile());
        bmNoticeVO.setTenantId(InvocationInfoProxy.getTenantid());
        bmNoticeVO.setSignTime(new Date());
        bmNoticeVO.setSourceSupplierId(entity.getSourceSupplierId());
        CommonResponse listCommonResponse = this.attachmentApi.queryListBySourceId(entity.getId(), "BT211123000000004", "bmFiles", null);
        Long attachId = null;
        String fileName = "";
        InputStream inputStream = null;
        if (listCommonResponse.isSuccess()) {
            List data = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                attachId = ((AttachmentVO)data.get(0)).getId();
                fileName = ((AttachmentVO)data.get(0)).getFileName();
                Response fileResponse = this.attachmentApi.downloadFileById(attachId);
                Response.Body body = fileResponse.body();
                inputStream = body.asInputStream();
            }
            String bmNotice = JSONObject.toJSONString((Object)bmNoticeVO);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("bmNoticeVO", bmNotice);
            this.logger.info("bmNoticeVO--" + bmNotice);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.logger.info("signUpUrl--" + this.signUpUrl + "---tokenUrl----" + this.tokenUrl);
            String string = new ThirdSystemUtils().postFile(this.tokenUrl, this.signUpUrl, params, headers, inputStream, this.cacheManager, fileName);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public Boolean updateSignStatus(List<SignVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            ArrayList supTendentIds = new ArrayList();
            ArrayList sourceSupplierIds = new ArrayList();
            String sourceId = vos.get(0).getSourceId();
            vos.forEach(e -> {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getTenantId, (Object)e.getTenantId());
                updateWrapper.eq(SignEntity::getSourceId, (Object)e.getSourceId());
                updateWrapper.eq(SignEntity::getSourceSupplierId, (Object)e.getSourceSupplierId());
                updateWrapper.set(SignEntity::getSignStatus, (Object)5);
                updateWrapper.set(SignEntity::getOutReason, (Object)e.getOutReason());
                super.update((Wrapper)updateWrapper);
                supTendentIds.add(e.getTenantId());
                sourceSupplierIds.add(e.getSourceSupplierId());
            });
            List signEntityList = super.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SignEntity::getSourceId, (Object)sourceId)).eq(SignEntity::getSignStatus, (Object)5)).in(BaseEntity::getTenantId, supTendentIds)).in(SignEntity::getSourceSupplierId, sourceSupplierIds));
            List noticeEntityList = this.noticeService.list((Wrapper)Wrappers.lambdaQuery().eq(NoticeEntity::getSourceId, (Object)sourceId));
            this.logger.info("\u5f00\u59cb\u7ec4\u7ec7\u6d88\u606f\u53d1\u9001\u5185\u5bb9===========");
            if (CollectionUtils.isNotEmpty((Collection)signEntityList) && CollectionUtils.isNotEmpty((Collection)noticeEntityList)) {
                for (SignEntity sign : signEntityList) {
                    ArrayList<String> userList = new ArrayList<String>();
                    if (sign.getSignId() != null) {
                        userList.add(sign.getSignId().toString());
                    }
                    userList = userList.stream().distinct().collect(Collectors.toList());
                    NoticeEntity noticeEntity = (NoticeEntity)((Object)noticeEntityList.get(0));
                    String projectName = noticeEntity.getProjectName();
                    if (PURCHASE_TYPE_1.equals(noticeEntity.getPurchaseType())) {
                        projectName = noticeEntity.getOrgName();
                    }
                    String formurl = this.baseHost + "ejc-supbid-frontend/#/eliminated?id=" + noticeEntity.getId();
                    String subject = "\u60a8\u6295\u6807\u7684\u3010" + noticeEntity.getUnitName() + "\u3011\u6240\u62db\u6807\u7684\u3010" + projectName + "\u3011\u5df2\u88ab\u62db\u6807\u65b9\u5e9f\u6807";
                    String content = "\u60a8\u6295\u6807\u7684\u3010" + noticeEntity.getUnitName() + "\u3011\u6240\u62db\u6807\u7684\u3010" + projectName + "\u3011\u5df2\u88ab\u62db\u6807\u65b9\u5e9f\u6807\uff0c<a href= '" + formurl + "'>\u67e5\u770b\u8be6\u60c5</a>";
                    new SendMsgUtils().sendSysMsg(userList, subject, content, sign.getTenantId(), this.pushMessageApi);
                }
            }
        }
        return true;
    }

    @Override
    public Boolean updateBidOut(String sourceId, int type, String outReason) {
        boolean abolishTypeFlag = ABOLISH_TYPE_1.equals(type) || ABOLISH_TYPE_2.equals(type);
        List<Object> outList = new ArrayList();
        if (abolishTypeFlag) {
            QueryParam param = new QueryParam();
            param.getParams().put("sourceId", new Parameter("eq", (Object)sourceId));
            param.getParams().put("signStatus", new Parameter("eq", (Object)5));
            List outSignEntityList = super.queryList(param);
            outList = outSignEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        LambdaUpdateWrapper updateWrappern = new LambdaUpdateWrapper();
        updateWrappern.eq(NoticeEntity::getSourceId, (Object)sourceId);
        updateWrappern.set(NoticeEntity::getAbolishType, (Object)type);
        this.noticeService.update((Wrapper)updateWrappern);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(SignEntity::getSourceId, (Object)sourceId);
        updateWrapper.ne(SignEntity::getSignStatus, (Object)5);
        updateWrapper.set(SignEntity::getSignStatus, (Object)5);
        updateWrapper.set(SignEntity::getOutReason, (Object)outReason);
        boolean flag = super.update((Wrapper)updateWrapper);
        if (abolishTypeFlag) {
            String text = "";
            if (ABOLISH_TYPE_1.equals(type)) {
                text = "\u5df2\u6d41\u6807";
            }
            if (ABOLISH_TYPE_2.equals(type)) {
                text = "\u5df2\u5e9f\u6807";
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("sourceId", new Parameter("eq", (Object)sourceId));
            if (CollectionUtils.isNotEmpty(outList)) {
                queryParam.getParams().put("id", new Parameter("not_in", outList));
            }
            List signEntityList = super.queryList(queryParam);
            List noticeEntityList = this.noticeService.queryList(queryParam);
            this.logger.info("\u5f00\u59cb\u7ec4\u7ec7\u6d88\u606f\u53d1\u9001\u5185\u5bb9===========");
            if (CollectionUtils.isNotEmpty((Collection)signEntityList) && CollectionUtils.isNotEmpty((Collection)noticeEntityList)) {
                for (SignEntity sign : signEntityList) {
                    ArrayList<String> userList = new ArrayList<String>();
                    if (sign.getSignId() != null) {
                        userList.add(sign.getSignId().toString());
                    }
                    if (sign.getSchemeId() != null) {
                        userList.add(sign.getSchemeId().toString());
                    }
                    userList = userList.stream().distinct().collect(Collectors.toList());
                    NoticeEntity noticeEntity = (NoticeEntity)((Object)noticeEntityList.get(0));
                    String projectName = noticeEntity.getProjectName();
                    if (PURCHASE_TYPE_1.equals(noticeEntity.getPurchaseType())) {
                        projectName = noticeEntity.getOrgName();
                    }
                    String formurl = this.baseHost + "ejc-supbid-frontend/#/eliminated?id=" + noticeEntity.getId();
                    String subject = "\u3010" + noticeEntity.getUnitName() + "\u3011\u62db\u6807\u7684\u3010" + projectName + "\u3011" + text;
                    String content = "\u3010" + noticeEntity.getUnitName() + "\u3011\u62db\u6807\u7684\u3010" + projectName + "\u3011" + text + "\uff0c<a href= '" + formurl + "'>\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>";
                    new SendMsgUtils().sendSysMsg(userList, subject, content, sign.getTenantId(), this.pushMessageApi);
                }
            }
        }
        return flag;
    }
}

