package com.ejianc.business.supbid.win.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.supbid.win.bean.WinDetailEntity;
/**
 * 中标公告
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supbid_win")
public class WinEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="source_type")
    private String sourceType; // 系统标识
    @TableField(value="source_id")
    private String sourceId; // 来源id
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="source_project_id")
    private String sourceProjectId; // 发布项目ID
    @TableField(value="project_name")
    private String projectName; // 发布项目名称
    @TableField(value="project_code")
    private String projectCode; // 发布项目编号
    @TableField(value="source_org_id")
    private String sourceOrgId; // 发布组织ID
    @TableField(value="org_name")
    private String orgName; // 发布组织名称
    @TableField(value="source_unit_id")
    private String sourceUnitId; // 招标单位ID
    @TableField(value="unit_name")
    private String unitName; // 招标单位名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="type")
    private String type; // 类型(1-材料采购招标，2-分包招标,3-设备采购招标，4-设备租赁招标，5-周转材租赁招标，6-其他招标)
    @TableField(value="tender_name")
    private String tenderName; // 招标名称
    @TableField(value="tender_type")
    private Integer tenderType; // 招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
    @TableField(value="source_employee_id")
    private String sourceEmployeeId; // 招标联系人
    @TableField(value="employee_name")
    private String employeeName; // 招标联系人名称
    @TableField(value="employee_mobile")
    private String employeeMobile; // 招标联系人电话
    @TableField(value="purchase_type")
    private Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    @TableField(value="project_link_name")
    private String projectLinkName; // 项目联系人
    @TableField(value="project_link_phone")
    private String projectLinkPhone; // 项目联系人电话
    @TableField(value="purchase_name")
    private String purchaseName; // 采购类别
    @TableField(value="abolish_type")
    private Integer abolishType; // 流/废标（0-正常，1-流标，2-废标)
    @TableField(value="win_date")
    private Date winDate; // 中标时间
    @TableField(value="win_title")
    private String winTitle; // 中标标题
    @TableField(value="system_id")
    private String systemId;
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="winDetailService" ,pidName = "winId")//此处有pid="xxx"，默认值pid="pid"
    private List<WinDetailEntity> winDetailList = new ArrayList<>(); // 中标公告明细
    

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getSourceProjectId() {
        return sourceProjectId;
    }

    public void setSourceProjectId(String sourceProjectId) {
        this.sourceProjectId = sourceProjectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getSourceOrgId() {
        return sourceOrgId;
    }

    public void setSourceOrgId(String sourceOrgId) {
        this.sourceOrgId = sourceOrgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getSourceUnitId() {
        return sourceUnitId;
    }

    public void setSourceUnitId(String sourceUnitId) {
        this.sourceUnitId = sourceUnitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public String getTenderName() {
        return tenderName;
    }

    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    public Integer getTenderType() {
        return tenderType;
    }

    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }
    public String getSourceEmployeeId() {
        return sourceEmployeeId;
    }

    public void setSourceEmployeeId(String sourceEmployeeId) {
        this.sourceEmployeeId = sourceEmployeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getProjectLinkName() {
        return projectLinkName;
    }

    public void setProjectLinkName(String projectLinkName) {
        this.projectLinkName = projectLinkName;
    }
    public String getProjectLinkPhone() {
        return projectLinkPhone;
    }

    public void setProjectLinkPhone(String projectLinkPhone) {
        this.projectLinkPhone = projectLinkPhone;
    }
    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
    public Integer getAbolishType() {
        return abolishType;
    }

    public void setAbolishType(Integer abolishType) {
        this.abolishType = abolishType;
    }
    public Date getWinDate() {
        return winDate;
    }

    public void setWinDate(Date winDate) {
        this.winDate = winDate;
    }
    public String getWinTitle() {
        return winTitle;
    }

    public void setWinTitle(String winTitle) {
        this.winTitle = winTitle;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public List<WinDetailEntity> getWinDetailList() {
        return winDetailList;
    }

    public void setWinDetailList(List<WinDetailEntity> winDetailList) {
        this.winDetailList = winDetailList;
    }
}
