package com.ejianc.business.supbid.win.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.win.vo.WinVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.win.mapper.WinMapper;
import com.ejianc.business.supbid.win.bean.WinEntity;
import com.ejianc.business.supbid.win.service.IWinService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 中标公告
 *
 * @author generator
 */
@Service("winService")
public class WinServiceImpl extends BaseServiceImpl<WinMapper, WinEntity> implements IWinService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;

    /**
     * 新增或修改
     *
     * @param saveOrUpdateVO 中标数据
     * @return 变更结果
     */
    @Override
    public boolean saveWin(WinVO saveOrUpdateVO) {
        logger.info("接收中标公告，sourceID->[{}]", saveOrUpdateVO.getSourceId());
        WinEntity entity = BeanMapper.map(saveOrUpdateVO, WinEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            // 新增时查询是否已存在中标公告，一个项目只能存在一个中标公告，多次传中标公告则进行修改操作
            QueryParam param = new QueryParam();
            param.getParams().put("sourceId", new Parameter(QueryParam.EQ, entity.getSourceId()));
            List<WinEntity> winEntityList = super.queryList(param);
            if (CollectionUtils.isNotEmpty(winEntityList)) {
                entity.setId(winEntityList.get(0).getId());
            }
        }
        return super.saveOrUpdate(entity, false);
    }

    /**
     * 查询中标公告列表
     * 公开招标、询价：所有供应商都能看到
     * 其他类型的招标：只有参与报价的供应商才能看到；
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<WinVO> queryWinList(QueryParam param) {
        // 模糊搜索配置字段示例
        List<String> fuzzyFields = param.getFuzzyFields();

        param.getOrderMap().put("create_time", QueryParam.DESC);
        // 租户隔离
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 招标方式为公开、询价，或者是参与报价
        List<Integer> tenderTypeList = new ArrayList<>();
        tenderTypeList.add(0);//公开
        tenderTypeList.add(2);//询价
        // 查询合作企业的systemId
        CommonResponse<List<String>> response = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            logger.error("获取合作企业信息失败！失败原因：{}",response.getMsg());
            throw new BusinessException("获取合作企业信息失败");
        }
        List<String> systemIdList = response.getData();
        logger.info("合作企业信息：{}",systemIdList);
        List<WinVO> winVOList = baseMapper.queryWinList(changeToQueryWrapper(param), tenderTypeList,
                String.valueOf(InvocationInfoProxy.getTenantid()), systemIdList);
        IPage<WinEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());
        IPage<WinVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(winVOList);
        return pageData;
    }

    /**
     * 根据ID查询详情
     *
     * @param id 单据id
     * @return 详情
     */
    @Override
    public WinVO queryWinDetail(Long id) {
        WinEntity entity = super.selectById(id);
        if (entity == null) {
            return new WinVO();
        }
        WinVO vo = BeanMapper.map(entity, WinVO.class);
        vo.setTypeName(getTypeName(vo.getType()));
        return vo;
    }

    /**
     * 根据type获取招标类型名称
     * @param type 招标类型代码
     * @return 招标类型名称
     */
    private String getTypeName(String type) {
        if (StringUtils.isEmpty(type)) return null;
        switch (type) {
            case "MATERIAL":
                return "材料招标";
            case "SUB":
                return "分包招标";
            case "PURCHASE":
                return "设备采购招标";
            case "RENT":
                return "设备租赁招标";
            case "RMAT":
                return "周转材租赁招标";
            case "OTHER":
                return "其他招标";
        }
        return null;
    }
}
