package com.ejianc.business.supbid.winbid.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.util.SendMsgUtils;
import com.ejianc.business.supbid.winbid.bean.WinbidContentEntity;
import com.ejianc.business.supbid.winbid.bean.WinbidDetailEntity;
import com.ejianc.business.supbid.winbid.service.IWinbidContentService;
import com.ejianc.business.supbid.winbid.service.IWinbidDetailService;
import com.ejianc.business.supbid.winbid.vo.WinbidVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.winbid.mapper.WinbidMapper;
import com.ejianc.business.supbid.winbid.bean.WinbidEntity;
import com.ejianc.business.supbid.winbid.service.IWinbidService;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 中标实体
 *
 * @author generator
 */
@Service("winbidService")
public class WinbidServiceImpl extends BaseServiceImpl<WinbidMapper, WinbidEntity> implements IWinbidService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * 采购方式：1-单位采购
     */
    private static final Integer PURCHASE_TYPE_1 = 1;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private ISignService signService;

    @Autowired
    private IWinbidDetailService winbidDetailService;

    @Autowired
    private IWinbidContentService winbidContentService;

    @Autowired
    private INoticeService noticeService;

    @Autowired
    private IPushMessageApi pushMessageApi;


    @Override
    public WinbidVO queryWinbidDetail(String sourceId) {
        List<WinbidEntity> list = super
                .list(Wrappers.<WinbidEntity>lambdaQuery().eq(WinbidEntity::getSourceId, sourceId)
                        .eq(WinbidEntity::getTenantId, InvocationInfoProxy.getTenantid()));
        if (CollectionUtils.isNotEmpty(list)) {
            List<WinbidDetailEntity> winbidEntityList = winbidDetailService
                    .list(Wrappers.<WinbidDetailEntity>lambdaQuery().eq(WinbidDetailEntity::getSourceId, sourceId)
                            .eq(WinbidDetailEntity::getTenantId, InvocationInfoProxy.getTenantid()));
            WinbidEntity winbidEntity = list.get(0);
            winbidEntity.setWinbidDetailList(winbidEntityList);
            WinbidVO vo = BeanMapper.map(winbidEntity, WinbidVO.class);
            WinbidContentEntity winbidContentEntity = winbidContentService
                    .getOne((Wrappers.<WinbidContentEntity>lambdaQuery()
                            .eq(WinbidContentEntity::getWinbidId, winbidEntity.getId())));
            if (null != winbidContentEntity) {
                vo.setContent(winbidContentEntity.getContent());
            }
            return vo;
        }
        else {
            return null;
        }
    }

    @Override
    public CommonResponse<Boolean> save(List<WinbidVO> listVO) {
        if (CollectionUtils.isNotEmpty(listVO)) {
            // 先查出已剔除的供应商
            QueryParam param = new QueryParam();
            param.getParams().put("sourceId", new Parameter(QueryParam.EQ, listVO.get(0).getSourceId()));
            param.getParams().put("signStatus", new Parameter(QueryParam.EQ, 5));
            List<SignEntity> outSignEntityList = signService.queryList(param);
            // 已剔除的供应商ID集合
            List<Long> outList = outSignEntityList.stream().map(SignEntity::getId).collect(Collectors.toList());

            listVO.forEach(e->{
                WinbidEntity winbidEntity = BeanMapper.map(e, WinbidEntity.class);
                if(CollectionUtils.isNotEmpty(winbidEntity.getWinbidDetailList())){
                    winbidEntity.getWinbidDetailList().forEach(k->{
                        k.setTenantId(winbidEntity.getTenantId());
                    });
                }
                super.saveOrUpdate(winbidEntity, false);
                if (StringUtils.isNotEmpty(e.getContent())) {
                    WinbidContentEntity contentEntity = new WinbidContentEntity();
                    contentEntity.setWinbidId(winbidEntity.getId());
                    contentEntity.setContent(e.getContent());
                    contentEntity.setTenantId(winbidEntity.getTenantId());
                    winbidContentService.save(contentEntity);
                }
                if (null != e.getWinbidType() && 0 == e.getWinbidType()) {
                    //将对应报名表更新为已定标  剩下的改为已淘汰
                    LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(SignEntity::getSourceId, e.getSourceId());
                    updateWrapper.eq(SignEntity::getTenantId, e.getTenantId());//查询已报名
                    updateWrapper.set(SignEntity::getSignStatus, 4);//已定标
                    signService.update(updateWrapper);
                }
            });
            // 定标发送消息通知
            if (null != listVO.get(0).getWinbidType() && 0 == listVO.get(0).getWinbidType()) {
                LambdaUpdateWrapper<SignEntity> updateWrapper2 = new LambdaUpdateWrapper<>();
                updateWrapper2.eq(SignEntity::getSourceId, listVO.get(0).getSourceId());
                updateWrapper2.ne(SignEntity::getSignStatus, 4);//没用定标的全部改为淘汰
                updateWrapper2.set(SignEntity::getSignStatus, 5);//已淘汰
                updateWrapper2.set(SignEntity::getOutReason, "未中标");
                signService.update(updateWrapper2);
                // 发送内部消息
                // 查询所需信息
                logger.info("开始组织消息发送内容===========");
                QueryParam queryParam = new QueryParam();
                // 中标未中标的SourceId相同，取第一个SourceId
                queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, listVO.get(0).getSourceId()));
                List<NoticeEntity> noticeEntityList = noticeService.queryList(queryParam);
                // 查询所有已淘汰的供应商
                queryParam.getParams().put("signStatus", new Parameter(QueryParam.EQ, 5));
                // 已剔除的供应商不发送消息
                if (CollectionUtils.isNotEmpty(outList))
                    queryParam.getParams().put("id", new Parameter(QueryParam.NOT_IN, outList));
                List<SignEntity> signEntityList = signService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(signEntityList) && CollectionUtils.isNotEmpty(noticeEntityList)) {
                    logger.info("未中标供应商数量【{}】", signEntityList.size());
                    // 接收消息的user
                    List<String> userList;
                    for (SignEntity sign : signEntityList) {
                        userList = new ArrayList<>();
                        if (sign.getSignId() != null) userList.add(sign.getSignId().toString()); // 报名操作人
                        if (sign.getSchemeId() != null) userList.add(sign.getSchemeId().toString()); // 报价操作人
                        // 去重，防止一个人接收到多条相同的信息
                        userList = userList.stream().distinct().collect(Collectors.toList());
                        // 获取公告信息，公告信息只有一条
                        NoticeEntity noticeEntity = noticeEntityList.get(0);
                        String projectName = noticeEntity.getProjectName();
                        // 单位采购使用orgName
                        if (PURCHASE_TYPE_1.equals(noticeEntity.getPurchaseType()))
                            projectName = noticeEntity.getOrgName();
                        // 组装标题及内容
                        String formurl = baseHost + "ejc-supbid-frontend/#/eliminated?id=" + noticeEntity.getId();
                        String subject = "很遗憾,你投标的【" + projectName + "】未中标，感谢您的参与！";
                        String content = "很遗憾,你投标的【" + projectName + "】未中标，感谢您的参与！" +
                                "<a href= '" + formurl + "'" + ">点击查看详情</a>";
                        new SendMsgUtils().sendSysMsg(userList, subject, content, sign.getTenantId(), pushMessageApi);
                    }
                }
            }
        }
        return CommonResponse.success("操作成功！", true);
    }
}
