/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.win.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.win.bean.WinEntity;
import com.ejianc.business.supbid.win.mapper.WinMapper;
import com.ejianc.business.supbid.win.service.IWinService;
import com.ejianc.business.supbid.win.vo.WinVO;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="winService")
public class WinServiceImpl
extends BaseServiceImpl<WinMapper, WinEntity>
implements IWinService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;

    @Override
    public boolean saveWin(WinVO saveOrUpdateVO) {
        this.logger.info("\u63a5\u6536\u4e2d\u6807\u516c\u544a\uff0csourceID->[{}]", (Object)saveOrUpdateVO.getSourceId());
        WinEntity entity = (WinEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WinEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            QueryParam param = new QueryParam();
            param.getParams().put("sourceId", new Parameter("eq", (Object)entity.getSourceId()));
            List winEntityList = super.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)winEntityList)) {
                entity.setId(((WinEntity)((Object)winEntityList.get(0))).getId());
            }
        }
        return super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public IPage<WinVO> queryWinList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("employeeName");
        fuzzyFields.add("employeeMobile");
        fuzzyFields.add("unitName");
        fuzzyFields.add("tenderName");
        param.getOrderMap().put("create_time", "desc");
        ArrayList<Integer> tenderTypeList = new ArrayList<Integer>();
        tenderTypeList.add(0);
        tenderTypeList.add(2);
        CommonResponse response = this.cooperateEnterpriseApi.getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)response.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        List systemIdList = (List)response.getData();
        this.logger.info("\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\uff1a{}", (Object)systemIdList);
        List<WinVO> winVOList = ((WinMapper)this.baseMapper).queryWinList((QueryWrapper<WinEntity>)WinServiceImpl.changeToQueryWrapper((QueryParam)param), tenderTypeList, String.valueOf(InvocationInfoProxy.getTenantid()), systemIdList);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)winVOList.size());
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(winVOList);
        return pageData;
    }

    @Override
    public WinVO queryWinDetail(Long id) {
        WinEntity entity = (WinEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            return new WinVO();
        }
        WinVO vo = (WinVO)BeanMapper.map((Object)((Object)entity), WinVO.class);
        vo.setTypeName(this.getTypeName(vo.getType()));
        return vo;
    }

    private String getTypeName(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        switch (type) {
            case "MATERIAL": {
                return "\u6750\u6599\u62db\u6807";
            }
            case "SUB": {
                return "\u5206\u5305\u62db\u6807";
            }
            case "PURCHASE": {
                return "\u8bbe\u5907\u91c7\u8d2d\u62db\u6807";
            }
            case "RENT": {
                return "\u8bbe\u5907\u79df\u8d41\u62db\u6807";
            }
            case "RMAT": {
                return "\u5468\u8f6c\u6750\u79df\u8d41\u62db\u6807";
            }
            case "OTHER": {
                return "\u5176\u4ed6\u62db\u6807";
            }
        }
        return null;
    }
}

