/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.winbid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.util.SendMsgUtils;
import com.ejianc.business.supbid.winbid.bean.WinbidContentEntity;
import com.ejianc.business.supbid.winbid.bean.WinbidDetailEntity;
import com.ejianc.business.supbid.winbid.bean.WinbidEntity;
import com.ejianc.business.supbid.winbid.mapper.WinbidMapper;
import com.ejianc.business.supbid.winbid.service.IWinbidContentService;
import com.ejianc.business.supbid.winbid.service.IWinbidDetailService;
import com.ejianc.business.supbid.winbid.service.IWinbidService;
import com.ejianc.business.supbid.winbid.vo.WinbidVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="winbidService")
public class WinbidServiceImpl
extends BaseServiceImpl<WinbidMapper, WinbidEntity>
implements IWinbidService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer PURCHASE_TYPE_1 = 1;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private ISignService signService;
    @Autowired
    private IWinbidDetailService winbidDetailService;
    @Autowired
    private IWinbidContentService winbidContentService;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;

    @Override
    public WinbidVO queryWinbidDetail(String sourceId) {
        List list = super.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(WinbidEntity::getSourceId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List winbidEntityList = this.winbidDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(WinbidDetailEntity::getSourceId, (Object)sourceId)).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid()));
            WinbidEntity winbidEntity = (WinbidEntity)((Object)list.get(0));
            winbidEntity.setWinbidDetailList(winbidEntityList);
            WinbidVO vo = (WinbidVO)BeanMapper.map((Object)((Object)winbidEntity), WinbidVO.class);
            WinbidContentEntity winbidContentEntity = (WinbidContentEntity)((Object)this.winbidContentService.getOne((Wrapper)Wrappers.lambdaQuery().eq(WinbidContentEntity::getWinbidId, (Object)winbidEntity.getId())));
            if (null != winbidContentEntity) {
                vo.setContent(winbidContentEntity.getContent());
            }
            return vo;
        }
        return null;
    }

    @Override
    public CommonResponse<Boolean> save(List<WinbidVO> listVO) {
        if (CollectionUtils.isNotEmpty(listVO)) {
            QueryParam param = new QueryParam();
            param.getParams().put("sourceId", new Parameter("eq", (Object)listVO.get(0).getSourceId()));
            param.getParams().put("signStatus", new Parameter("eq", (Object)5));
            List outSignEntityList = this.signService.queryList(param);
            List outList = outSignEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            listVO.forEach(e -> {
                WinbidEntity winbidEntity = (WinbidEntity)((Object)((Object)BeanMapper.map((Object)e, WinbidEntity.class)));
                if (CollectionUtils.isNotEmpty(winbidEntity.getWinbidDetailList())) {
                    winbidEntity.getWinbidDetailList().forEach(k -> k.setTenantId(winbidEntity.getTenantId()));
                }
                if (CollectionUtils.isNotEmpty(winbidEntity.getSubWinbidDetailList())) {
                    winbidEntity.getSubWinbidDetailList().forEach(k -> k.setTenantId(winbidEntity.getTenantId()));
                }
                super.saveOrUpdate((Object)winbidEntity, false);
                if (StringUtils.isNotEmpty((CharSequence)e.getContent())) {
                    WinbidContentEntity contentEntity = new WinbidContentEntity();
                    contentEntity.setWinbidId(winbidEntity.getId());
                    contentEntity.setContent(e.getContent());
                    contentEntity.setTenantId(winbidEntity.getTenantId());
                    this.winbidContentService.save((Object)contentEntity);
                }
                if (null != e.getWinbidType() && 0 == e.getWinbidType()) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.eq(SignEntity::getSourceId, (Object)e.getSourceId());
                    updateWrapper.eq(BaseEntity::getTenantId, (Object)e.getTenantId());
                    updateWrapper.set(SignEntity::getSignStatus, (Object)4);
                    this.signService.update((Wrapper)updateWrapper);
                }
            });
            if (null != listVO.get(0).getWinbidType() && 0 == listVO.get(0).getWinbidType()) {
                List signEntityList;
                LambdaUpdateWrapper updateWrapper2 = new LambdaUpdateWrapper();
                updateWrapper2.eq(SignEntity::getSourceId, (Object)listVO.get(0).getSourceId());
                updateWrapper2.ne(SignEntity::getSignStatus, (Object)4);
                updateWrapper2.set(SignEntity::getSignStatus, (Object)5);
                updateWrapper2.set(SignEntity::getOutReason, (Object)"\u672a\u4e2d\u6807");
                this.signService.update((Wrapper)updateWrapper2);
                this.logger.info("\u5f00\u59cb\u7ec4\u7ec7\u6d88\u606f\u53d1\u9001\u5185\u5bb9===========");
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("sourceId", new Parameter("eq", (Object)listVO.get(0).getSourceId()));
                List noticeEntityList = this.noticeService.queryList(queryParam);
                queryParam.getParams().put("signStatus", new Parameter("eq", (Object)5));
                if (CollectionUtils.isNotEmpty(outList)) {
                    queryParam.getParams().put("id", new Parameter("not_in", outList));
                }
                if (CollectionUtils.isNotEmpty((Collection)(signEntityList = this.signService.queryList(queryParam))) && CollectionUtils.isNotEmpty((Collection)noticeEntityList)) {
                    this.logger.info("\u672a\u4e2d\u6807\u4f9b\u5e94\u5546\u6570\u91cf\u3010{}\u3011", (Object)signEntityList.size());
                    for (SignEntity sign : signEntityList) {
                        ArrayList<String> userList = new ArrayList<String>();
                        if (sign.getSignId() != null) {
                            userList.add(sign.getSignId().toString());
                        }
                        if (sign.getSchemeId() != null) {
                            userList.add(sign.getSchemeId().toString());
                        }
                        userList = userList.stream().distinct().collect(Collectors.toList());
                        NoticeEntity noticeEntity = (NoticeEntity)((Object)noticeEntityList.get(0));
                        String projectName = noticeEntity.getProjectName();
                        if (PURCHASE_TYPE_1.equals(noticeEntity.getPurchaseType())) {
                            projectName = noticeEntity.getOrgName();
                        }
                        String formurl = this.baseHost + "ejc-supbid-frontend/#/eliminated?id=" + noticeEntity.getId();
                        String subject = "\u5f88\u9057\u61be,\u4f60\u6295\u6807\u7684\u3010" + projectName + "\u3011\u672a\u4e2d\u6807\uff0c\u611f\u8c22\u60a8\u7684\u53c2\u4e0e\uff01";
                        String content = "\u5f88\u9057\u61be,\u4f60\u6295\u6807\u7684\u3010" + projectName + "\u3011\u672a\u4e2d\u6807\uff0c\u611f\u8c22\u60a8\u7684\u53c2\u4e0e\uff01<a href= '" + formurl + "'>\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>";
                        new SendMsgUtils().sendSysMsg(userList, subject, content, sign.getTenantId(), this.pushMessageApi);
                    }
                }
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)true);
    }

    @Override
    public IPage<WinbidVO> queryHomeList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("memo");
        CommonResponse response = this.cooperateEnterpriseApi.getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)response.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        List systemIdList = (List)response.getData();
        if (CollectionUtils.isNotEmpty((Collection)systemIdList)) {
            param.getParams().put("systemId", new Parameter("in", (Object)systemIdList));
        }
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WinbidVO.class));
        return pageData;
    }
}

