package com.ejianc.business.supbid.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.material.bean.SchemeDetailEntity;
import com.ejianc.business.supbid.material.bean.SchemeEntity;
import com.ejianc.business.supbid.material.bean.SchemeRecordEntity;
import com.ejianc.business.supbid.material.service.ISchemeDetailService;
import com.ejianc.business.supbid.material.service.ISchemeRecordService;
import com.ejianc.business.supbid.material.service.ISchemeService;
import com.ejianc.business.supbid.material.vo.SchemeVO;
import com.ejianc.business.supbid.notice.bean.ContentEntity;
import com.ejianc.business.supbid.notice.bean.FilecontentEntity;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.mapper.NoticeMapper;
import com.ejianc.business.supbid.notice.service.IContentService;
import com.ejianc.business.supbid.notice.service.IFilecontentService;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.notice.vo.*;
import com.ejianc.business.supbid.purchase.bean.PurchaseSchemeDetailEntity;
import com.ejianc.business.supbid.purchase.bean.PurchaseSchemeEntity;
import com.ejianc.business.supbid.purchase.bean.PurchaseSchemeRecordEntity;
import com.ejianc.business.supbid.purchase.service.IPurchaseSchemeDetailService;
import com.ejianc.business.supbid.purchase.service.IPurchaseSchemeRecordService;
import com.ejianc.business.supbid.purchase.service.IPurchaseSchemeService;
import com.ejianc.business.supbid.purchase.vo.PurchaseSchemeVO;
import com.ejianc.business.supbid.sub.bean.SubSchemeDetailEntity;
import com.ejianc.business.supbid.sub.bean.SubSchemeEntity;
import com.ejianc.business.supbid.sub.bean.SubSchemeRecordEntity;
import com.ejianc.business.supbid.sub.service.ISubSchemeDetailService;
import com.ejianc.business.supbid.sub.service.ISubSchemeRecordService;
import com.ejianc.business.supbid.sub.service.ISubSchemeService;
import com.ejianc.business.supbid.sub.vo.SubDetailVO;
import com.ejianc.business.supbid.sub.vo.SubSchemeVO;
import com.ejianc.business.supbid.util.CommonUtils;
import com.ejianc.business.supbid.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import feign.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 公告实体
 *
 * @author generator
 *
 */
@Service("noticeService")
public class NoticeServiceImpl extends BaseServiceImpl<NoticeMapper, NoticeEntity> implements INoticeService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_TYPE = "BT211123000000003";

    /** 招标门户中查询条件：发布时间 */
    private static final String QUERY_HOME_PUBLISH_TIME = "publishTime";
    /** 招标门户中查询条件：报名/报价倒计时是否结束 0-展示全部，1-倒计时未结束，2-倒计时已结束 */
    private static final String QUERY_HOME_OVER_FLAG = "overFlag";


    @Autowired
    private CacheManager cacheManager;

    @Value("${gcyUrl.signUpUrl}")
    private String signUpUrl;

    // 材料
    @Value("${gcyUrl.pushSellUrl}")
    private String pushSellUrl;
    // 分包
    @Value("${gcyUrl.subPushSellUrl}")
    private String subPushSellUrl;
    // 设备
    @Value("${gcyUrl.purchasePushSellUrl}")
    private String purchasePushSellUrl;

    @Value("${gcyUrl.tokenUrl}")
    private String tokenUrl;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IContentService contentService;

    @Autowired
    private INoticeService service;

    @Autowired
    private IFilecontentService filecontentService;

    @Autowired
    private ISchemeService schemeService;
    /** 分包方案 */
    @Autowired
    private ISubSchemeService subSchemeService;
    /** 设备采购方案 */
    @Autowired
    private IPurchaseSchemeService purchaseSchemeService;

    @Autowired
    private ISchemeRecordService schemeRecordService;
    /** 分包方案记录 */
    @Autowired
    private ISubSchemeRecordService subSchemeRecordService;
    /** 设备采购方案记录 */
    @Autowired
    private IPurchaseSchemeRecordService purchaseSchemeRecordService;

    @Autowired
    private ISchemeDetailService schemeDetailService;
    /** 分包方案 */
    @Autowired
    private ISubSchemeDetailService subSchemeDetailService;
    /** 设备采购方案 */
    @Autowired
    private IPurchaseSchemeDetailService purchaseSchemeDetailService;
    @Autowired
    private ISignService signService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;


    @Override
    public CommonResponse<Boolean> saveWj(HttpServletRequest request, MultipartFile file) {
        logger.info("进入接口--");
        logger.info("request--" + request);
        String notice = request.getParameter("noticeEntity");
        logger.info("实体信息--" + notice);
        NoticeVO saveorUpdateVO = JSON.parseObject(notice, new TypeReference<NoticeVO>() {
        });
        boolean flag = false;
        saveorUpdateVO.setAbolishType(0);
        if(1==saveorUpdateVO.getNoticeType()) {//文件
            NoticeEntity noticeEntity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId()));
            noticeEntity.setProjectLinkName(saveorUpdateVO.getProjectLinkName());
            noticeEntity.setProjectLinkPhone(saveorUpdateVO.getProjectLinkPhone());
            noticeEntity.setOfferStartTime(saveorUpdateVO.getOfferStartTime());
            noticeEntity.setOfferEndTime(saveorUpdateVO.getOfferEndTime());
            noticeEntity.setBrandFlag(saveorUpdateVO.getBrandFlag());
            noticeEntity.setMemo(saveorUpdateVO.getMemo());
            noticeEntity.setSystemId(saveorUpdateVO.getSystemId());
            flag = super.saveOrUpdate(noticeEntity, false);
            if (StringUtils.isNotEmpty(saveorUpdateVO.getContent())) {
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(noticeEntity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }
            //需将状态改为已报名的数据改为  待报价
            LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SignEntity::getSourceId, saveorUpdateVO.getSourceId());
            updateWrapper.eq(SignEntity::getSignStatus, 0);//查询已报名
            updateWrapper.set(SignEntity::getSignStatus, 1);//待报价
            signService.update(updateWrapper);
            if (null != file) {
                logger.info(request + "文件模板--" + file.getOriginalFilename());
                Boolean upFlag = this.upFile("templateFiles", Long.toString(noticeEntity.getId()), BILL_TYPE, file, request);
                logger.info(request + "文件上传结果--" + upFlag);
            }
        }
        return CommonResponse.success("保存或修改单据成功！",flag);

    }

    @Override
    public CommonResponse<Boolean> addFile(HttpServletRequest request, MultipartFile file) {
        Boolean upFlag = false;
        if (null != file) {
            String sourceId = request.getParameter("sourceId");
            NoticeEntity noticeEntity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId,sourceId));
            logger.info(request + "文件模板--" + file.getOriginalFilename()+"---surceId:"+sourceId+"----noticeId"+noticeEntity.getId());
            upFlag = this.upFile("noticeFiles",Long.toString(noticeEntity.getId()), BILL_TYPE, file, request);
            logger.info(request + "文件上传结果--" + upFlag);
        }
        return CommonResponse.success("上传成功！",upFlag);
    }

    @Override
    public CommonResponse<String> delFile(String sourceId,List<String> fileNames) {
        NoticeEntity noticeEntity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId,sourceId));
        attachmentApi.deleteFileByParams(Long.valueOf(noticeEntity.getId()),BILL_TYPE,"noticeFiles",fileNames);
        return attachmentApi.delete(sourceId);
    }

    @Override
    public CommonResponse<Boolean> save(NoticeVO saveorUpdateVO) {
        boolean flag = false;
        saveorUpdateVO.setAbolishType(0);
        logger.info("接收到推送数据：{}",JSONObject.toJSONString(saveorUpdateVO));
        if(0==saveorUpdateVO.getNoticeType()){//公告
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getNoticeContent())){
                ContentEntity contentEntity = new ContentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setNoticeContent(saveorUpdateVO.getNoticeContent());
                contentService.save(contentEntity);
            }
            if(1==saveorUpdateVO.getTenderType()){
                //邀请招标  需要生成报名表，状态为待报名
                List<SignEntity> signEntities = new ArrayList<>();
                List<ApplyVO> applyVOList = saveorUpdateVO.getApplyList();
                if(CollectionUtils.isNotEmpty(applyVOList)){
                    applyVOList.forEach(e->{
                        SignEntity signEntity = new SignEntity();
                        signEntity.setSourceId(saveorUpdateVO.getSourceId());
                        signEntity.setNoticeId(entity.getId());
                        signEntity.setSignStatus(9);//待报名
                        signEntity.setSourceSupplierId(e.getSourceSupplierId());
                        signEntity.setTenantId(e.getTenantId());
                        signEntities.add(signEntity);
                    });
                    signService.saveOrUpdateBatch(signEntities);
                }
            }
        }else if(1==saveorUpdateVO.getNoticeType()){//文件
            NoticeEntity noticeEntity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId()));
            noticeEntity.setProjectLinkName(saveorUpdateVO.getProjectLinkName());
            noticeEntity.setProjectLinkPhone(saveorUpdateVO.getProjectLinkPhone());
            noticeEntity.setOfferStartTime(saveorUpdateVO.getOfferStartTime());
            noticeEntity.setOfferEndTime(saveorUpdateVO.getOfferEndTime());
            noticeEntity.setBrandFlag(saveorUpdateVO.getBrandFlag());
            noticeEntity.setMemo(saveorUpdateVO.getMemo());
            noticeEntity.setSystemId(saveorUpdateVO.getSystemId());
            flag = super.saveOrUpdate(noticeEntity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(noticeEntity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }
            //需将状态改为已报名的数据改为  待报价
            LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SignEntity::getSourceId,saveorUpdateVO.getSourceId());
            updateWrapper.eq(SignEntity::getSignStatus,0);//查询已报名
            updateWrapper.set(SignEntity::getSignStatus,1);//待报价
            signService.update(updateWrapper);
        }else if(2==saveorUpdateVO.getNoticeType()){
            //询价
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }
        }else if(3==saveorUpdateVO.getNoticeType()){
            //  竞争性/单一来源/紧急性   默认均为邀请供应商
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }

            List<SignEntity> signEntities = new ArrayList<>();
            List<ApplyVO> applyVOList = saveorUpdateVO.getApplyList();
            if(CollectionUtils.isNotEmpty(applyVOList)){
                applyVOList.forEach(e->{
                    SignEntity signEntity = new SignEntity();
                    signEntity.setSourceId(saveorUpdateVO.getSourceId());
                    signEntity.setNoticeId(entity.getId());
                    signEntity.setSignStatus(1);//待报价
                    signEntity.setSourceSupplierId(e.getSourceSupplierId());
                    signEntity.setTenantId(e.getTenantId());
                    signEntities.add(signEntity);
                });
                signService.saveOrUpdateBatch(signEntities);
            }
        }else if(4==saveorUpdateVO.getNoticeType()){
            //  洽商谈判 主表更新字段
            NoticeEntity entity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery()
                    .eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId()));
            //如果是第一轮   需根据sourceId与传来的tenantId将子表复制到历史记录表
            if (null != saveorUpdateVO.getTalkNum() && 1 == saveorUpdateVO.getTalkNum()) {
                // 材料招标
                if (CommonUtils.TYPE_MATERIAL.equals(entity.getType())) {
                    this.saveMaterial(saveorUpdateVO);
                }
                // 分包招标
                else if (CommonUtils.TYPE_SUB.equals(entity.getType())) {
                    this.saveSub(saveorUpdateVO);
                }
                // 设备采购
                else if (CommonUtils.TYPE_PURCHASE.equals(entity.getType())) {
                    this.savePurchase(saveorUpdateVO);
                }
                else {
                    logger.error("招标类型不存在[{}]", entity.getType());
                    throw new BusinessException("招标类型不存在");
                }
            }
            entity.setTenderName(saveorUpdateVO.getTenderName());
            entity.setOfferStartTime(saveorUpdateVO.getOfferStartTime());
            entity.setOfferEndTime(saveorUpdateVO.getOfferEndTime());
            entity.setTalkMoney(saveorUpdateVO.getTalkMoney());
            entity.setTalkNum(saveorUpdateVO.getTalkNum());
            entity.setMemo(saveorUpdateVO.getMemo());
            flag = super.saveOrUpdate(entity, false);
            //将未淘汰的报名状态改为洽商谈判
            List<SignEntity> signEntities = signService
                    .list(Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getNoticeId, entity.getId())
                            .eq(SignEntity::getSourceId, saveorUpdateVO.getSourceId())
                            .ne(SignEntity::getSignStatus, 5));
            if (CollectionUtils.isNotEmpty(signEntities)) {
                signEntities.forEach(e -> {
                    e.setSignStatus(2);//洽商谈判
                });
                signService.saveOrUpdateBatch(signEntities);
            }
        }
        logger.info("公告接收成功-----sourceId:{}", saveorUpdateVO.getSourceId());
        return CommonResponse.success("保存或修改单据成功！", flag);
    }

    /**
     * 接收公告处理材料招标信息
     *
     * @param saveorUpdateVO 接收到的公告信息
     */
    private void saveMaterial(NoticeVO saveorUpdateVO) {
        List<SchemeEntity> schemeEntityList = schemeService.list((Wrappers.<SchemeEntity>lambdaQuery()
                .eq(SchemeEntity::getSourceId, saveorUpdateVO.getSourceId())));
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                SchemeEntity schemeEntity = schemeService.selectById(e.getId());
                SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity, SchemeRecordEntity.class);
                schemeRecordEntity.setId(null);
                schemeRecordEntity.setTalkNum(0);//首轮
                schemeRecordEntity.getSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                schemeRecordService.saveOrUpdate(schemeRecordEntity, false);
            });
        }
    }

    /**
     * 接收公告处理分包招标信息
     *
     * @param saveorUpdateVO 接收到的公告信息
     */
    private void saveSub(NoticeVO saveorUpdateVO) {
        List<SubSchemeEntity> subSchemeEntityList = subSchemeService.list((Wrappers.<SubSchemeEntity>lambdaQuery()
                .eq(SubSchemeEntity::getSourceId, saveorUpdateVO.getSourceId())));
        if (CollectionUtils.isNotEmpty(subSchemeEntityList)) {
            subSchemeEntityList.forEach(e -> {
                SubSchemeEntity subSchemeEntity = subSchemeService.selectById(e.getId());
                SubSchemeRecordEntity subSchemeRecordEntity = BeanMapper.map(subSchemeEntity, SubSchemeRecordEntity.class);
                subSchemeRecordEntity.setId(null);
                subSchemeRecordEntity.setTalkNum(0);//首轮
                subSchemeRecordEntity.getSubSchemeDetailRecordList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                subSchemeRecordService.saveOrUpdate(subSchemeRecordEntity, false);
            });
        }
    }

    /**
     * 接收公告处理设备采购招标信息
     *
     * @param saveorUpdateVO 接收到的公告信息
     */
    private void savePurchase(NoticeVO saveorUpdateVO) {
        List<PurchaseSchemeEntity> purchaseSchemeEntityList = purchaseSchemeService
                .list((Wrappers.<PurchaseSchemeEntity>lambdaQuery()
                        .eq(PurchaseSchemeEntity::getSourceId, saveorUpdateVO.getSourceId())));
        if (CollectionUtils.isNotEmpty(purchaseSchemeEntityList)) {
            purchaseSchemeEntityList.forEach(e -> {
                PurchaseSchemeEntity purchaseSchemeEntity = purchaseSchemeService.selectById(e.getId());
                PurchaseSchemeRecordEntity purchaseSchemeRecordEntity = BeanMapper
                        .map(purchaseSchemeEntity, PurchaseSchemeRecordEntity.class);
                purchaseSchemeRecordEntity.setId(null);
                purchaseSchemeRecordEntity.setTalkNum(0);//首轮
                purchaseSchemeRecordEntity.getPurchaseSchemeDetailRecordList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                purchaseSchemeRecordService.saveOrUpdate(purchaseSchemeRecordEntity, false);
            });
        }

    }


    /**
     * 报价
     *
     * @param saveorUpdateVO 报价信息
     * @return 报价结果
     * @throws Exception 异常信息
     */
    @Override
    public CommonResponse<NoticeVO> saveFile(NoticeVO saveorUpdateVO) throws Exception {
        NoticeVO dbVo = queryFileDetail(saveorUpdateVO.getId());
        List<SignVO> signVOList = saveorUpdateVO.getSignList();
        NoticeVO resVo = null;
        NoticeEntity noticeEntity = null;
        // 材料招标
        if (CommonUtils.TYPE_MATERIAL.equals(dbVo.getType())) {
            this.saveFileMaterial(saveorUpdateVO, dbVo);
        }
        // 分包招标
        else if (CommonUtils.TYPE_SUB.equals(dbVo.getType())) {
            this.saveFileSub(saveorUpdateVO, dbVo);
        }
        // 设备采购
        else if (CommonUtils.TYPE_PURCHASE.equals(dbVo.getType())) {
            this.saveFilePurchase(saveorUpdateVO, dbVo);
        }
        else {
            logger.error("招标类型不存在[{}]", dbVo.getType());
            throw new BusinessException("招标类型不存在");
        }

        SignEntity signEntity = null;
        // 获取systemId
        String systemId = super.selectById(saveorUpdateVO.getId()).getSystemId();
        if (2 == saveorUpdateVO.getTenderType() && null == signVOList.get(0).getsId()) {
            signEntity = BeanMapper.map(signVOList.get(0), SignEntity.class);
            signEntity.setSourceId(saveorUpdateVO.getSourceId());
            signEntity.setNoticeId(saveorUpdateVO.getId());
            signEntity.setSignStatus(3);//报价中

            // 租户ID和供应商ID对应关系
//            Map<String,String> sourceTenantMap = new HashMap<>();
//            sourceTenantMap.put("1471726626618441730","1406947724700246112");
//            sourceTenantMap.put("1471729176256151553","1406947724700246113");
//            sourceTenantMap.put("1471731643794554881","1406947724700246114");
//            sourceTenantMap.put("1472852233918054402","527888337260777477");
//            sourceTenantMap.put("1473189202070044674","528220972239556690");
//            sourceTenantMap.put("1473189172567310338","528222266413027386");
//            sourceTenantMap.put("1473189113180160002","528222429273657395");
//            sourceTenantMap.put("1473190529172996098","528222690796900362");
//            // 根据租户ID查找供应商ID
//            String sourceSupplierId = sourceTenantMap.get(InvocationInfoProxy.getTenantid().toString());
            CommonResponse<Long> supplierResponse = cooperateEnterpriseApi
                    .getCooperateSupplierIdByTenantIdAndEnterpriseId(InvocationInfoProxy.getTenantid(), systemId);
            if (!supplierResponse.isSuccess()) {
                return CommonResponse.error("未查询到供应商信息！");
            }
            String sourceSupplierId = supplierResponse.getData().toString();
//            signEntity.setSourceSupplierId("1212517281");
            signEntity.setSourceSupplierId(sourceSupplierId);
            signEntity.setTenantId(InvocationInfoProxy.getTenantid());
        }else{
            signEntity = signService.selectById(signVOList.get(0).getsId());
            signEntity.setSignEmployeeId(signVOList.get(0).getSignEmployeeId());
            signEntity.setSignEmployeeMobile(signVOList.get(0).getSignEmployeeMobile());
            signEntity.setSignEmployeeName(signVOList.get(0).getSignEmployeeName());
            signEntity.setSchemeId(signVOList.get(0).getSchemeId());
            signEntity.setSchemeName(signVOList.get(0).getSchemeName());
            signEntity.setInvoiceNote(signVOList.get(0).getInvoiceNote());
            signEntity.setSignStatus(3);
        }
        signService.saveOrUpdate(signEntity, false);
        resVo = queryFileDetail(saveorUpdateVO.getId());
        //调用第三方报名接口 推送报价
        BjNoticeVO bjNoticeVO = BeanMapper.map(signEntity, BjNoticeVO.class);
        bjNoticeVO.setSourceSupplierId(signEntity.getSourceSupplierId());
        bjNoticeVO.setSchemeTime(new Date());
        bjNoticeVO.setEmployeeId(signEntity.getSignEmployeeId());
        bjNoticeVO.setEmployeeName(signEntity.getSignEmployeeName());
        bjNoticeVO.setEmployeeMobile(signEntity.getSignEmployeeMobile());

        String url;
        // 材料招标
        if (CommonUtils.TYPE_MATERIAL.equals(resVo.getType())) {
            bjNoticeVO.setDetailList(resVo.getDetailList());
            bjNoticeVO.setSchemeList(resVo.getSchemeList());
            url = pushSellUrl;
        }
        // 分包招标
        else if (CommonUtils.TYPE_SUB.equals(resVo.getType())) {
            bjNoticeVO.setSubDetailList(resVo.getSubDetailList());
            bjNoticeVO.setSubSchemeList(resVo.getSubSchemeList());
            url = subPushSellUrl;
        }
        // 设备采购
        else if (CommonUtils.TYPE_PURCHASE.equals(resVo.getType())) {
            bjNoticeVO.setPurchaseDetailList(resVo.getPurchaseDetailList());
            bjNoticeVO.setPurchaseSchemeList(resVo.getPurchaseSchemeList());
            url = purchasePushSellUrl;
        }
        else {
            logger.error("招标类型不存在[{}]", resVo.getType());
            throw new BusinessException("招标类型不存在");
        }
//        CommonResponse<JSONObject> response = null;
//        response = new ThirdSystemUtils().sendPostReq(tokenUrl,pushSellUrl, JSON.toJSONString(bjNoticeVO),
//        cacheManager);
//        if(!response.isSuccess()) {
//            throw new BusinessException("调用第三方接口失败!");
//        }
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi
                .queryListBySourceId(signEntity.getId(), "BT211123000000004", "bjFiles", null);
        Long attachId = null;
        String fileName = "";
        InputStream inputStream = null;
        if (listCommonResponse.isSuccess()) {
            List<AttachmentVO> data = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(data)) {
                attachId = data.get(0).getId();
                fileName = data.get(0).getFileName();
                Response fileResponse = attachmentApi.downloadFileById(attachId);
                Response.Body body = fileResponse.body();
                inputStream = body.asInputStream();
            }
            String bjNotice = JSONObject.toJSONString(bjNoticeVO);
            logger.info("实体信息---" + bjNotice);
            Map<String, String> params = new HashMap<>();
            params.put("bjNoticeVO", bjNotice);
            Map<String, String> headers = new HashMap<>();

            // 公有云--->>>私有云
            // 组装文件参数
            // Map<"file",Map<"文件名称",InputStream>>
            Map<String, Map<String, InputStream>> files = null;
            if (null != inputStream) {
                files = new HashMap<>();
                Map<String, InputStream> fileMap = new HashMap<>();
                fileMap.put(fileName, inputStream);
                files.put("file", fileMap);
            }
            logger.info("-----开始调用私有云----");
            logger.info("参数--->>>url:[{}],systemId:[{}],params:【{}】,files:【{}】", url, systemId, params, files);
            CommonResponse<String> commonResponse = systemDataPushService
                    .exchangeDataAndFilesWithThirdSystem(url, params, systemId, files);
            logger.info("-----调用私有云结束----调用结果：{}", commonResponse.isSuccess());
            // 校验返回结果
            CommonUtils.checkCommonResponse(commonResponse, logger);
//            if (!commonResponse.isSuccess()) {
//                logger.error("推送数据失败！失败原因：{}", commonResponse.getMsg());
//                // 上面已操作过数据库，需要抛出异常进行回滚
//                throw new BusinessException("推送数据失败！");
//            }
//            String s = new ThirdSystemUtils().postFile(tokenUrl, pushSellUrl, params, headers, inputStream,
//            cacheManager,fileName);
        }

        return CommonResponse.success("保存或修改单据成功！", resVo);
    }

    /**
     * 处理材料招标报价信息
     *
     * @param saveorUpdateVO 前端传入的公告报价信息
     * @param dbVo           查询出的公告报价信息
     */
    private void saveFileMaterial(NoticeVO saveorUpdateVO, NoticeVO dbVo) {
        List<SchemeVO> schemeVOList = saveorUpdateVO.getSchemeList();
        List<SchemeVO> delList = new ArrayList<>();//删除的数据
        List<SchemeVO> dbList = dbVo.getSchemeList();//数据库里的数据
        if (null != saveorUpdateVO.getTalkNum() && 0 < saveorUpdateVO.getTalkNum()) {
            //说明是洽商谈判保存  这种场景不允许修改保存
            //1,将原子表数据 移到记录表
            // 20220113修改：供方接收招标方发布的洽商谈判时，已经将首轮报价记录，此时记录表需要记录最新（当前轮次）的报价
            if (CollectionUtils.isNotEmpty(schemeVOList)) {
                schemeVOList.forEach(e -> {
//                    SchemeEntity schemeEntity = schemeService.selectById(e.getId());
//                    SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity, SchemeRecordEntity.class);
                    SchemeRecordEntity schemeRecordEntity = BeanMapper.map(e, SchemeRecordEntity.class);
                    schemeRecordEntity.setId(null);
                    schemeRecordEntity.setTalkNum(saveorUpdateVO.getTalkNum());//当前轮次
                    schemeRecordEntity.getSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    schemeRecordService.saveOrUpdate(schemeRecordEntity, false);
                });
            }
            //新增修改的数据
            List<SchemeEntity> schemeEntityList = BeanMapper.mapList(schemeVOList, SchemeEntity.class);
            schemeEntityList.forEach(e -> {
                schemeService.saveOrUpdate(e, false);
            });
        }
        else {
            if (CollectionUtils.isNotEmpty(schemeVOList)) {
                Map<Long, String> map = new HashMap<>();
                schemeVOList.forEach(k -> {
                    if (null != k.getId()) {
                        map.put(k.getId(), k.getSchemeName());
                    }
                });

                if (CollectionUtils.isNotEmpty(dbList)) {
                    dbList.forEach(d -> {
                        if (!map.containsKey(d.getId())) {
                            delList.add(d);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(delList)) {
                    schemeService.removeByIds(delList, false);
                }
                //新增修改的数据
                List<SchemeEntity> schemeEntityList = BeanMapper.mapList(schemeVOList, SchemeEntity.class);
                schemeEntityList.forEach(e -> {
                    schemeService.saveOrUpdate(e, false);
                });
            }
        }
    }

    /**
     * 处理分包招标报价信息
     *
     * @param saveorUpdateVO 前端传入的公告报价信息
     * @param dbVo           查询出的公告报价信息
     */
    private void saveFileSub(NoticeVO saveorUpdateVO, NoticeVO dbVo) {
        List<SubSchemeVO> subSchemeVOList = saveorUpdateVO.getSubSchemeList();
        List<SubSchemeVO> delList = new ArrayList<>();//删除的数据
        List<SubSchemeVO> dbList = dbVo.getSubSchemeList();//数据库里的数据
        if (null != saveorUpdateVO.getTalkNum() && 0 < saveorUpdateVO.getTalkNum()) {
            //说明是洽商谈判保存  这种场景不允许修改保存
            //1,将原子表数据 移到记录表
            // 20220113修改：供方接收标方发布的洽商谈判时，已经将首轮报价记录，此时记录表需要记录最新（当前轮次）的报价
            if (CollectionUtils.isNotEmpty(subSchemeVOList)) {
                subSchemeVOList.forEach(e -> {
//                    SubSchemeEntity subSchemeEntity = subSchemeService.selectById(e.getId());
//                    SubSchemeRecordEntity subSchemeRecordEntity = BeanMapper
//                            .map(subSchemeEntity, SubSchemeRecordEntity.class);
                    SubSchemeRecordEntity subSchemeRecordEntity = BeanMapper.map(e, SubSchemeRecordEntity.class);
                    subSchemeRecordEntity.setId(null);
                    subSchemeRecordEntity.setTalkNum(saveorUpdateVO.getTalkNum());//当前轮次
                    subSchemeRecordEntity.getSubSchemeDetailRecordList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    subSchemeRecordService.saveOrUpdate(subSchemeRecordEntity, false);
                });
            }
            //新增修改的数据
            List<SubSchemeEntity> subSchemeEntityList = BeanMapper.mapList(subSchemeVOList, SubSchemeEntity.class);
//            subSchemeService.saveOrUpdateBatch(subSchemeEntityList, subSchemeEntityList.size());
            subSchemeEntityList.forEach(e -> {
                subSchemeService.saveOrUpdate(e, false);
            });
        }
        else {
            if (CollectionUtils.isNotEmpty(subSchemeVOList)) {
                Map<Long, String> map = new HashMap<>();
                subSchemeVOList.forEach(k -> {
                    if (null != k.getId()) {
                        map.put(k.getId(), k.getSchemeName());
                    }
                });

                if (CollectionUtils.isNotEmpty(dbList)) {
                    dbList.forEach(d -> {
                        if (!map.containsKey(d.getId())) {
                            delList.add(d);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(delList)) {
                    subSchemeService.removeByIds(delList, false);
                }
                //新增修改的数据
                List<SubSchemeEntity> subSchemeEntityList = BeanMapper.mapList(subSchemeVOList, SubSchemeEntity.class);
//                subSchemeService.saveOrUpdateBatch(subSchemeEntityList, subSchemeEntityList.size());
                subSchemeEntityList.forEach(e -> {
                    subSchemeService.saveOrUpdate(e, false);
                });
            }
        }
    }

    /**
     * 处理设备采购招标报价信息
     *
     * @param saveorUpdateVO 前端传入的公告报价信息
     * @param dbVo           查询出的公告报价信息
     */
    private void saveFilePurchase(NoticeVO saveorUpdateVO, NoticeVO dbVo) {
        List<PurchaseSchemeVO> purchaseSchemeList = saveorUpdateVO.getPurchaseSchemeList();
        List<PurchaseSchemeVO> delList = new ArrayList<>();//删除的数据
        List<PurchaseSchemeVO> dbList = dbVo.getPurchaseSchemeList();//数据库里的数据
        if (null != saveorUpdateVO.getTalkNum() && 0 < saveorUpdateVO.getTalkNum()) {
            //说明是洽商谈判保存  这种场景不允许修改保存
            //1,将原子表数据 移到记录表
            // 20220113修改：供方接收招标方发布的洽商谈判时，已经将首轮报价记录，此时记录表需要记录最新（当前轮次）的报价
            if (CollectionUtils.isNotEmpty(purchaseSchemeList)) {
                purchaseSchemeList.forEach(e -> {
//                    SchemeEntity schemeEntity = schemeService.selectById(e.getId());
//                    SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity, SchemeRecordEntity.class);
                    PurchaseSchemeRecordEntity purchaseSchemeRecordEntity = BeanMapper
                            .map(e, PurchaseSchemeRecordEntity.class);
                    purchaseSchemeRecordEntity.setId(null);
                    purchaseSchemeRecordEntity.setTalkNum(saveorUpdateVO.getTalkNum());//当前轮次
                    purchaseSchemeRecordEntity.getPurchaseSchemeDetailRecordList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    purchaseSchemeRecordService.saveOrUpdate(purchaseSchemeRecordEntity, false);
                });
            }
            //新增修改的数据
            List<PurchaseSchemeEntity> purchaseSchemeEntityList = BeanMapper
                    .mapList(purchaseSchemeList, PurchaseSchemeEntity.class);
            purchaseSchemeEntityList.forEach(e -> {
                purchaseSchemeService.saveOrUpdate(e, false);
            });
        }
        else {
            if (CollectionUtils.isNotEmpty(purchaseSchemeList)) {
                Map<Long, String> map = new HashMap<>();
                purchaseSchemeList.forEach(k -> {
                    if (null != k.getId()) {
                        map.put(k.getId(), k.getSchemeName());
                    }
                });

                if (CollectionUtils.isNotEmpty(dbList)) {
                    dbList.forEach(d -> {
                        if (!map.containsKey(d.getId())) {
                            delList.add(d);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(delList)) {
                    schemeService.removeByIds(delList, false);
                }
                //新增修改的数据
                List<PurchaseSchemeEntity> purchaseSchemeEntityList = BeanMapper
                        .mapList(purchaseSchemeList, PurchaseSchemeEntity.class);
                purchaseSchemeEntityList.forEach(e -> {
                    purchaseSchemeService.saveOrUpdate(e, false);
                });
            }
        }
    }


    @Override
    public CommonResponse<Boolean> updateTime(NoticeVO saveorUpdateVO) {
        LambdaUpdateWrapper<NoticeEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId());
        if (null != saveorUpdateVO.getNoticeEndTime()) {
            updateWrapper.set(NoticeEntity::getNoticeEndTime, saveorUpdateVO.getNoticeEndTime());
        }
        if (null != saveorUpdateVO.getOfferEndTime()) {
            updateWrapper.set(NoticeEntity::getOfferEndTime, saveorUpdateVO.getOfferEndTime());
        }
        return CommonResponse.success("修改成功！", service.update(updateWrapper));
    }

    @Override
    public Boolean updateSupOffer(List<SupOfferVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)){
            NoticeEntity noticeEntity = super.getOne((Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId, vos.get(0).getSourceId())));
            String type = noticeEntity.getType();
            switch(type)
            {
                case CommonUtils.TYPE_MATERIAL:
                    materialRecord(vos);
                    break;
                case CommonUtils.TYPE_SUB:
                    subRecord(vos);
                    break;
                case CommonUtils.TYPE_PURCHASE:
                    System.out.println("良好");
                    break;
                case "RENT" :
                    System.out.println("及格");
                    break;
                case "RMAT" :
                    System.out.println("你需要再努力努力");
                    break;
                default :
                    System.out.println("未知等级");
            }
        }
        return true;
    }

    public void materialRecord(List<SupOfferVO> vos){
        vos.forEach(e->{
            List<SchemeEntity> schemeEntityList = schemeService.list((Wrappers.<SchemeEntity>lambdaQuery().eq(SchemeEntity::getSourceId, e.getSourceId())).eq(SchemeEntity::getTenantId, e.getTenantId()));
            if(CollectionUtils.isNotEmpty(schemeEntityList)){
                schemeEntityList.forEach(i->{
                    SchemeEntity schemeEntity = schemeService.selectById(i.getId());
                    SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity,SchemeRecordEntity.class);
                    schemeRecordEntity.setId(null);
                    schemeRecordEntity.setTalkNum(e.getTalkNum());
                    schemeRecordEntity.getSchemeDetailList().forEach(k->{
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    schemeRecordService.saveOrUpdate(schemeRecordEntity,false);
                });
            }
        });
    }

    public void subRecord(List<SupOfferVO> vos){
        vos.forEach(e->{
            List<SubSchemeEntity> schemeEntityList = subSchemeService.list((Wrappers.<SubSchemeEntity>lambdaQuery().eq(SubSchemeEntity::getSourceId, e.getSourceId())).eq(SubSchemeEntity::getTenantId, e.getTenantId()));
            if(CollectionUtils.isNotEmpty(schemeEntityList)){
                schemeEntityList.forEach(i->{
                    SubSchemeEntity schemeEntity = subSchemeService.selectById(i.getId());
                    SubSchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity,SubSchemeRecordEntity.class);
                    schemeRecordEntity.setId(null);
                    schemeRecordEntity.setTalkNum(e.getTalkNum());
                    schemeRecordEntity.getSubSchemeDetailRecordList().forEach(k->{
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    subSchemeRecordService.saveOrUpdate(schemeRecordEntity,false);
                });
            }
        });
    }

    @Override
    public NoticeVO queryDetail(Long id) {
        NoticeEntity noticeEntity = super.selectById(id);
        NoticeVO vo = BeanMapper.map(noticeEntity, NoticeVO.class);
        List<SignEntity> signEntities = signService.list(Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getNoticeId, id).eq(SignEntity::getTenantId,InvocationInfoProxy.getTenantid()));
        List<SignVO> signVOList =  BeanMapper.mapList(signEntities, SignVO.class);
        List<SignVO> signList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(signEntities)){
            Long sid = signEntities.get(0).getId();
            signVOList.get(0).setsId(sid);
            signList.add(signVOList.get(0));
        }
        vo.setSignList(signList);
        ContentEntity contentEntity = contentService.getOne((Wrappers.<ContentEntity>lambdaQuery().eq(ContentEntity::getNoticeId, id)));
        if(null!=contentEntity){
            vo.setNoticeContent(contentEntity.getNoticeContent());
        }
        return vo;
    }

    /**
     * 查询公告详情
     * @param id 公告id
     * @return 公告详情
     */
    @Override
    public NoticeVO queryFileDetail(Long id) {
        NoticeEntity noticeEntity = super.selectById(id);
        NoticeVO vo = BeanMapper.map(noticeEntity, NoticeVO.class);
        List<SignEntity> signEntities = signService
                .list(Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getNoticeId, id)
                        .eq(SignEntity::getTenantId, InvocationInfoProxy.getTenantid()));
        List<SignVO> signVOList = BeanMapper.mapList(signEntities, SignVO.class);
        List<SignVO> signList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(signEntities)) {
            Long sid = signEntities.get(0).getId();
            signVOList.get(0).setsId(sid);
            signList.add(signVOList.get(0));
        }
        vo.setSignList(signList);
        FilecontentEntity filecontentEntity = filecontentService
                .getOne((Wrappers.<FilecontentEntity>lambdaQuery().eq(FilecontentEntity::getNoticeId, id)));
        if (null != filecontentEntity) {
            vo.setContent(filecontentEntity.getContent());
        }

        // 材料招标
        if (CommonUtils.TYPE_MATERIAL.equals(noticeEntity.getType())) {
            this.queryMaterialScheme(noticeEntity, vo);
        }
        // 分包
        else if (CommonUtils.TYPE_SUB.equals(noticeEntity.getType())) {
            this.querySubScheme(noticeEntity, vo);
            if(CollectionUtils.isNotEmpty(vo.getSubDetailList())){
                // 分包取消默认值
                for (SubDetailVO subDetailVO: vo.getSubDetailList()) {
                    subDetailVO.setMny(null);
                    subDetailVO.setTaxMny(null);
                }
            }
        }
        // 设备采购
        else if (CommonUtils.TYPE_PURCHASE.equals(noticeEntity.getType())) {
            this.queryPurchaseScheme(noticeEntity, vo);
        }
        else {
            logger.error("招标类型不存在[{}]", noticeEntity.getType());
            throw new BusinessException("招标类型不存在");
        }

        return vo;
    }

    /**
     * 查询材料招标报价方案
     *
     * @param noticeEntity 公告实体
     * @param vo           公告vo
     */
    private void queryMaterialScheme(NoticeEntity noticeEntity, NoticeVO vo) {
        //查询方案信息
        List<SchemeEntity> schemeEntityList = schemeService
                .list((Wrappers.<SchemeEntity>lambdaQuery().eq(SchemeEntity::getNoticeId, noticeEntity.getId()))
                        .eq(SchemeEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(SchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                List<SchemeDetailEntity> schemeDetailEntities = null;
                schemeDetailEntities = schemeDetailService.list((Wrappers.<SchemeDetailEntity>lambdaQuery()
                        .eq(SchemeDetailEntity::getSchemeId, e.getId())));
                e.setSchemeDetailList(schemeDetailEntities);
            });
            vo.setSchemeList(BeanMapper.mapList(schemeEntityList, SchemeVO.class));
        }
    }

    /**
     * 查询分包方案信息
     *
     * @param noticeEntity 公告实体
     * @param vo           公告vo
     */
    private void querySubScheme(NoticeEntity noticeEntity, NoticeVO vo) {
        //查询分包方案信息
        List<SubSchemeEntity> subSchemeEntityList = subSchemeService
                .list(Wrappers.<SubSchemeEntity>lambdaQuery().eq(SubSchemeEntity::getNoticeId, noticeEntity.getId())
                        .eq(SubSchemeEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(SubSchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(subSchemeEntityList)) {
            subSchemeEntityList.forEach(e -> {
                List<SubSchemeDetailEntity> subSchemeDetailEntities;
                subSchemeDetailEntities = subSchemeDetailService.list((Wrappers.<SubSchemeDetailEntity>lambdaQuery()
                        .eq(SubSchemeDetailEntity::getSchemeId, e.getId())));
                e.setSubSchemeDetailList(subSchemeDetailEntities);
            });
            vo.setSubSchemeList(BeanMapper.mapList(subSchemeEntityList, SubSchemeVO.class));
        }
    }

    /**
     * 查询设备采购招标报价方案
     *
     * @param noticeEntity 公告实体
     * @param vo           公告vo
     */
    private void queryPurchaseScheme(NoticeEntity noticeEntity, NoticeVO vo) {
        //查询方案信息
        List<PurchaseSchemeEntity> purchaseSchemeEntityList = purchaseSchemeService
                .list((Wrappers.<PurchaseSchemeEntity>lambdaQuery()
                        .eq(PurchaseSchemeEntity::getNoticeId, noticeEntity.getId()))
                        .eq(PurchaseSchemeEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(PurchaseSchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(purchaseSchemeEntityList)) {
            purchaseSchemeEntityList.forEach(e -> {
                List<PurchaseSchemeDetailEntity> purchaseSchemeDetailEntityList = null;
                purchaseSchemeDetailEntityList = purchaseSchemeDetailService
                        .list((Wrappers.<PurchaseSchemeDetailEntity>lambdaQuery()
                                .eq(PurchaseSchemeDetailEntity::getSchemeId, e.getId())));
                e.setPurchaseSchemeDetailList(purchaseSchemeDetailEntityList);
            });
            vo.setPurchaseSchemeList(BeanMapper.mapList(purchaseSchemeEntityList, PurchaseSchemeVO.class));
        }
    }

    @Override
    public List<NoticeVO> queryInvitationList(QueryWrapper queryWrapper, Integer signStatus, String tenantId) {
        return baseMapper.queryInvitation(queryWrapper, signStatus, tenantId);
    }

    @Override
    public List<NoticeVO> queryAllList(QueryWrapper queryWrapper, String tenantId) {
        return baseMapper.queryAllList(queryWrapper, tenantId);
    }

    /**
     * 查询供方门户招标列表数据
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<NoticeVO> queryHomeList(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("employeeName");
        fuzzyFields.add("employeeMobile");
        fuzzyFields.add("unitName");
        fuzzyFields.add("tenderName");
        fuzzyFields.add("content");

        // 对查询参数进行处理
        Map<String, Parameter> parameterMap = param.getParams();
        String overFlag = null;
        // 记录需要处理的key，防止循环异常
        List<String> parameterRemoveList = new ArrayList<>();
        if (parameterMap != null && !parameterMap.isEmpty()) {
            for (String key : parameterMap.keySet()) {
                Parameter parameter = parameterMap.get(key);
                Object value = parameter.getValue();
                // 将前端传入的发布时间转换为数据库字段
                if (QUERY_HOME_PUBLISH_TIME.equals(key) && !parameterValueIsNull(value)) {
                    parameterMap.put("create_time", new Parameter(QueryParam.BETWEEN, value));
                    parameterRemoveList.add(key);
                }
                // 倒计时是否结束条件取出
                if (QUERY_HOME_OVER_FLAG.equals(key) && !parameterValueIsNull(value)) {
                    overFlag = value.toString();
                    parameterRemoveList.add(key);
                }
                // 查询参数值是空的则不做查询条件
                if (parameterValueIsNull(value)) {
                    parameterRemoveList.add(key);
                }
            }
            // 对需要处理的key进行处理
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(parameterRemoveList)) {
                parameterRemoveList.forEach(parameterMap::remove);
            }
        }
//        param.getOrderMap().put("create_time", QueryParam.DESC);
        List<Integer> tenderTypeList = new ArrayList<>();
        tenderTypeList.add(0); // 公开
        tenderTypeList.add(2); // 询价
        // 查询合作企业的systemId
        CommonResponse<List<String>> response = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            logger.error("获取合作企业信息失败！失败原因：{}", response.getMsg());
            throw new BusinessException("获取合作企业信息失败");
        }
        List<String> systemIdList = response.getData();
        logger.info("合作企业信息：{}", systemIdList);
        IPage<NoticeEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<NoticeVO> list = baseMapper.queryHomeList(changeToQueryWrapper(param), tenderTypeList,
                String.valueOf(InvocationInfoProxy.getTenantid()), systemIdList, overFlag, page);
        IPage<NoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }

    /**
     * 判断参数是否为空，为空返回true
     *
     * @param obj 判断参数
     * @return null:true,其他：false
     */
    private boolean parameterValueIsNull(Object obj) {
        if (obj == null) return true;
        return org.apache.commons.lang3.StringUtils.isEmpty(obj.toString());
    }

    @Override
    public NumsVO queryCounts() {
        NumsVO numsVO = new NumsVO();
        List<NoticeVO> list = baseMapper.queryCounts(InvocationInfoProxy.getTenantid() + "");
        numsVO.setDbmnums(list.get(0).getNums());
        numsVO.setYbmnums(list.get(1).getNums());
        numsVO.setDbjnums(list.get(2).getNums());
        numsVO.setQstpnums(list.get(3).getNums());
        numsVO.setBjznums(list.get(4).getNums());
        numsVO.setYdbnums(list.get(5).getNums());
        numsVO.setTtnums(list.get(6).getNums());
        return numsVO;
    }


    public boolean upFile(String sourceType,String sourceId,String billType,MultipartFile file,HttpServletRequest request){
        String authority = request.getHeader("authority");
        logger.info("获取认证信息--"+authority);
        if(null != authority) {
            InvocationInfoProxy.setExtendAttribute("authority", authority);
            Map<String,String> params = new HashMap<>();
            params.put("sourceType", sourceType);
            params.put("sourceId", sourceId);
            params.put("billType", billType);
            params.put("originalFileNameStr", file.getOriginalFilename());
            Map<String,String> headers = new HashMap<>();
            headers.put("authority", authority);
            AttachmentVO attachmentVO = null;
            try {
                //保存新的模板文件
                String fileUploadRespStr = postFile(BASE_HOST +"ejc-file-web/attachment/upload", params, headers, file.getInputStream(),file.getOriginalFilename());
                logger.info("模板文件信息--"+fileUploadRespStr);
                CommonResponse<List<AttachmentVO>> attachmentResp = JSONObject.parseObject(fileUploadRespStr, CommonResponse.class);
                logger.info("上传文件返回信息--"+attachmentResp);
                if(!attachmentResp.isSuccess()) {
                    logger.error("保存模板文件失败sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, 原因：{}",
                            sourceId, sourceType, billType, file.getOriginalFilename(), attachmentResp.getMsg());
                    return false;
                }
                attachmentVO = JSONObject.parseObject(JSONObject.toJSONString(attachmentResp.getData().get(0)), AttachmentVO.class);
            } catch (Exception e) {
                logger.error("保存模板文件失败sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, 原因：{}",
                        sourceId, sourceType, billType, file.getOriginalFilename(), e.getMessage());
                return false;
            }
            logger.info("模板文件保存成功：{}", JSONObject.toJSONString(attachmentVO));
        } else {
            return false;
        }
        return true;
    }

    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, InputStream inputStream,String fileName) throws Exception {
        String charset = "UTF-8";
        HttpClient client = null;

        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        Integer readTimeout = 10000;

        try {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("file",
                        inputStream, ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), fileName);
                for(String key : params.keySet()) {
                    builder.addPart(key, new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
                }
                HttpEntity entity = builder.build();
                post.setEntity(entity);

                RequestConfig.Builder customReqConf = RequestConfig.custom();
                if (connTimeout != null) {
                    customReqConf.setConnectTimeout(connTimeout);
            }

            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout);
            }

            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key = null;
                Iterator it = headers.keySet().iterator();

                while(it.hasNext()) {
                    key = (String)it.next();
                    post.addHeader(key, (String)headers.get(key));
                }
            } else {
                request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }

            HttpResponse res;
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = ((HttpClient)client).execute(post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager(cm).build();
                res = ((HttpClient)client).execute(post);
            }

            result = IOUtils.toString(res.getEntity().getContent(), charset);
        } finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
        }

        return result;
    }
}
