package com.ejianc.business.supbid.purchase.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.material.bean.SchemeRecordEntity;
import com.ejianc.business.supbid.material.vo.SchemeRecordVO;
import com.ejianc.business.supbid.purchase.vo.PurchaseSchemeRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.purchase.mapper.PurchaseSchemeRecordMapper;
import com.ejianc.business.supbid.purchase.bean.PurchaseSchemeRecordEntity;
import com.ejianc.business.supbid.purchase.service.IPurchaseSchemeRecordService;

import java.util.ArrayList;
import java.util.List;

/**
 * 设备采购洽商谈判方案记录表
 *
 * @author generator
 */
@Service("purchaseSchemeRecordService")
public class PurchaseSchemeRecordServiceImpl extends BaseServiceImpl<PurchaseSchemeRecordMapper,
        PurchaseSchemeRecordEntity> implements IPurchaseSchemeRecordService {

    @Override
    public List<PurchaseSchemeRecordVO> queryListbySourceId(Long noticeId) {
        List<PurchaseSchemeRecordVO> res = new ArrayList<>();
        List<PurchaseSchemeRecordEntity> purchaseSchemeRecordEntityList = super
                .list(Wrappers.<PurchaseSchemeRecordEntity>lambdaQuery()
                        .eq(PurchaseSchemeRecordEntity::getNoticeId, noticeId)
                        .eq(PurchaseSchemeRecordEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(PurchaseSchemeRecordEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(purchaseSchemeRecordEntityList)) {
            purchaseSchemeRecordEntityList.forEach(e -> {
                PurchaseSchemeRecordEntity purchaseSchemeRecordEntity = super.selectById(e.getId());
                res.add(BeanMapper.map(purchaseSchemeRecordEntity, PurchaseSchemeRecordVO.class));
            });
        }
        return res;
    }
}