package com.ejianc.business.supbid.sub.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.material.bean.SchemeRecordEntity;
import com.ejianc.business.supbid.material.vo.SchemeRecordVO;
import com.ejianc.business.supbid.sub.vo.SubSchemeRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.sub.mapper.SubSchemeRecordMapper;
import com.ejianc.business.supbid.sub.bean.SubSchemeRecordEntity;
import com.ejianc.business.supbid.sub.service.ISubSchemeRecordService;

import java.util.ArrayList;
import java.util.List;

/**
 * 分包洽商谈判方案记录表
 * 
 * @author generator
 * 
 */
@Service("subSchemeRecordService")
public class SubSchemeRecordServiceImpl extends BaseServiceImpl<SubSchemeRecordMapper, SubSchemeRecordEntity> implements ISubSchemeRecordService{

    /**
     * 根据公告id查询供应商历史报价
     * @param noticeId 公告ID
     * @return 历史报价
     */
    @Override
    public List<SubSchemeRecordVO> queryListBySourceId(Long noticeId) {
        List<SubSchemeRecordVO> res = new ArrayList<>();
        List<SubSchemeRecordEntity> subSchemeRecordEntityList = super
                .list(Wrappers.<SubSchemeRecordEntity>lambdaQuery().eq(SubSchemeRecordEntity::getNoticeId, noticeId)
                        .eq(SubSchemeRecordEntity::getTenantId, InvocationInfoProxy
                                .getTenantid()).orderByAsc(SubSchemeRecordEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(subSchemeRecordEntityList)) {
            subSchemeRecordEntityList.forEach(e -> {
                SubSchemeRecordEntity subSchemeRecordEntity = super.selectById(e.getId());
                res.add(BeanMapper.map(subSchemeRecordEntity, SubSchemeRecordVO.class));
            });
        }
        return res;
    }
}
