/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class CommonUtils {
    private static final String defaultErrMsg = "\u63a8\u9001\u6570\u636e\u5931\u8d25\uff01";
    public static final String TYPE_MATERIAL = "MATERIAL";
    public static final String TYPE_SUB = "SUB";
    public static final String TYPE_PURCHASE = "PURCHASE";

    private CommonUtils() {
    }

    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse) {
        return CommonUtils.checkCommonResponse(commonResponse, true, defaultErrMsg, null);
    }

    public static <T> void checkCommonResponse(CommonResponse<T> commonResponse, Logger logger) {
        CommonUtils.checkCommonResponse(commonResponse, true, defaultErrMsg, logger);
    }

    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse, boolean isThrow, String errMsg, Logger logger) {
        if (!commonResponse.isSuccess()) {
            if (logger != null) {
                logger.info("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u8c03\u7528\u7ed3\u679c\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.isSuccess(), (Object)commonResponse.getMsg());
            }
            if (isThrow) {
                throw new BusinessException(errMsg);
            }
            return false;
        }
        try {
            Object data = commonResponse.getData();
            String dataString = data instanceof String ? String.valueOf(data) : JSONObject.toJSONString((Object)data);
            JSONObject jsonObject = JSONObject.parseObject((String)dataString);
            if (StringUtils.isNotEmpty((CharSequence)dataString) && jsonObject.containsKey((Object)"code")) {
                CommonResponse check = (CommonResponse)JSONObject.toJavaObject((JSON)jsonObject, CommonResponse.class);
                if (isThrow && !check.isSuccess()) {
                    if (logger != null) {
                        logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)check.getMsg());
                    }
                    throw new BusinessException(errMsg);
                }
                return check.isSuccess();
            }
        }
        catch (Exception e) {
            if (logger != null) {
                logger.error("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff01\u8fd4\u56de\u7ed3\u679c\u4e0d\u662fjson\u6216CommonResponse");
            }
            return true;
        }
        return true;
    }
}

