package com.ejianc.business.supbid.rmat.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.supbid.rmat.bean.RmatSchemeDetailRecordEntity;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 周转材租赁洽商谈判方案记录表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supbid_rmat_scheme_record")
public class RmatSchemeRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="notice_id")
    private Long noticeId; // 主表主键
    @TableField(value="source_id")
    private String sourceId; // 招标信息主键
    @TableField(value="scheme_name")
    private String schemeName; // 方案名称
    @TableField(value="money")
    private BigDecimal money; // 报价总额
    @TableField(value="money_tax")
    private BigDecimal moneyTax; // 报价总额(含税)
    @TableField(value="talk_num")
    private Integer talkNum; // 轮数

    @TableField(exist=false)
    @SubEntity(serviceName="rmatSchemeDetailRecordService",pidName = "schemeId")//此处有pid="xxx"，默认值pid="pid"
    private List<RmatSchemeDetailRecordEntity> rmatSchemeDetailList = new ArrayList<>(); // 设备采购洽商谈判方案明细记录表
    

    public Long getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getSchemeName() {
        return schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }

    public List<RmatSchemeDetailRecordEntity> getRmatSchemeDetailList() {
        return rmatSchemeDetailList;
    }

    public void setRmatSchemeDetailList(List<RmatSchemeDetailRecordEntity> rmatSchemeDetailList) {
        this.rmatSchemeDetailList = rmatSchemeDetailList;
    }
}
