package com.ejianc.business.supbid.win.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.win.vo.WinVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.supbid.win.bean.WinEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 中标公告
 *
 * @author generator
 */
@Mapper
public interface WinMapper extends BaseCrudMapper<WinEntity> {

    /**
     * 查询中标公告列表
     *
     * @param queryWrapper   查询条件
     * @param tenderTypeList 招标方式
     * @param tenantId       供应商租户ID
     * @param systemIdList   合作企业systemId
     * @return 查询结果
     */
    List<WinVO> queryWinList(@Param(Constants.WRAPPER) QueryWrapper<WinEntity> queryWrapper,
                             @Param("tenderTypeList") List<Integer> tenderTypeList,
                             @Param("tenantId") String tenantId, @Param("systemIdList") List<String> systemIdList,
                             IPage<WinEntity> page);
}
