package com.ejianc.business.supbid.other.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.other.bean.OtherSchemeRecordEntity;
import com.ejianc.business.supbid.other.vo.OtherSchemeRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.other.mapper.OtherSchemeRecordMapper;
import com.ejianc.business.supbid.other.bean.OtherSchemeRecordEntity;
import com.ejianc.business.supbid.other.service.IOtherSchemeRecordService;

import java.util.ArrayList;
import java.util.List;

/**
 * 其他洽商谈判方案记录表
 * 
 * @author generator
 * 
 */
@Service("otherSchemeRecordService")
public class OtherSchemeRecordServiceImpl extends BaseServiceImpl<OtherSchemeRecordMapper, OtherSchemeRecordEntity> implements IOtherSchemeRecordService{
    @Override
    public List<OtherSchemeRecordVO> queryListbySourceId(Long noticeId) {
        List<OtherSchemeRecordVO> res = new ArrayList<>();
        List<OtherSchemeRecordEntity> otherSchemeRecordEntityList = super
                .list(Wrappers.<OtherSchemeRecordEntity>lambdaQuery()
                        .eq(OtherSchemeRecordEntity::getNoticeId, noticeId)
                        .eq(OtherSchemeRecordEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(OtherSchemeRecordEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(otherSchemeRecordEntityList)) {
            otherSchemeRecordEntityList.forEach(e -> {
                OtherSchemeRecordEntity otherSchemeRecordEntity = super.selectById(e.getId());
                res.add(BeanMapper.map(otherSchemeRecordEntity, OtherSchemeRecordVO.class));
            });
        }
        return res;
    }
}
