package com.ejianc.business.supbid.rmat.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.rmat.bean.RmatSchemeRecordEntity;
import com.ejianc.business.supbid.rmat.vo.RmatSchemeRecordVO;
import com.ejianc.business.supbid.rmat.vo.RmatSchemeRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.rmat.mapper.RmatSchemeRecordMapper;
import com.ejianc.business.supbid.rmat.bean.RmatSchemeRecordEntity;
import com.ejianc.business.supbid.rmat.service.IRmatSchemeRecordService;

import java.util.ArrayList;
import java.util.List;

/**
 * 周转材租赁洽商谈判方案记录表
 * 
 * @author generator
 * 
 */
@Service("rmatSchemeRecordService")
public class RmatSchemeRecordServiceImpl extends BaseServiceImpl<RmatSchemeRecordMapper, RmatSchemeRecordEntity> implements IRmatSchemeRecordService{
    @Override
    public List<RmatSchemeRecordVO> queryListbySourceId(Long noticeId) {
        List<RmatSchemeRecordVO> res = new ArrayList<>();
        List<RmatSchemeRecordEntity> rmatSchemeRecordEntityList = super
                .list(Wrappers.<RmatSchemeRecordEntity>lambdaQuery()
                        .eq(RmatSchemeRecordEntity::getNoticeId, noticeId)
                        .eq(RmatSchemeRecordEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(RmatSchemeRecordEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(rmatSchemeRecordEntityList)) {
            rmatSchemeRecordEntityList.forEach(e -> {
                RmatSchemeRecordEntity rmatSchemeRecordEntity = super.selectById(e.getId());
                res.add(BeanMapper.map(rmatSchemeRecordEntity, RmatSchemeRecordVO.class));
            });
        }
        return res;
    }
}
