package com.ejianc.business.supbid.sub.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.supbid.material.bean.SchemeDetailRecordEntity;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 分包洽商谈判方案记录表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supbid_sub_scheme_record")
public class SubSchemeRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="notice_id")
    private Long noticeId; // 主表主键
    @TableField(value="source_id")
    private String sourceId; // 招标信息主键
    @TableField(value="scheme_name")
    private String schemeName; // 方案名称
    @TableField(value="mny")
    private BigDecimal mny; // 报价总额
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 报价总额(含税)
    @TableField(value="talk_num")
    private Integer talkNum; // 轮数

    @TableField(exist=false)
    @SubEntity(serviceName="subSchemeDetailRecordService",pidName = "schemeId")
    private List<SubSchemeDetailRecordEntity> subSchemeDetailList = new ArrayList<>(); // 报价明细实体记录表

    public List<SubSchemeDetailRecordEntity> getSubSchemeDetailList() {
        return subSchemeDetailList;
    }

    public void setSubSchemeDetailList(List<SubSchemeDetailRecordEntity> subSchemeDetailList) {
        this.subSchemeDetailList = subSchemeDetailList;
    }

    public Long getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getSchemeName() {
        return schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }
    
}
