package com.ejianc.business.supbid.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 文件上传工具类
 */
public class SupbidFileUtils {

    private SupbidFileUtils() {
    }

    /**
     * 文件上传服务
     * @param sourceType 文件类型
     * @param sourceId 单据id
     * @param billType 单据类型
     * @param file 文件流
     * @param request 请求信息
     * @param baseHost 基础路径
     * @param logger 日志信息
     * @return 上传结果
     */
    public static AttachmentVO upFile(String sourceType, String sourceId, String billType, MultipartFile file,
                                      HttpServletRequest request, String baseHost, Logger logger) {
        String authority = request.getHeader("authority");
        logger.info("获取认证信息--" + authority);
        if (null != authority) {
            InvocationInfoProxy.setExtendAttribute("authority", authority);
            Map<String, String> params = new HashMap<>();
            params.put("sourceType", sourceType);
            params.put("sourceId", sourceId);
            params.put("billType", billType);
            params.put("originalFileNameStr", file.getOriginalFilename());
            Map<String, String> headers = new HashMap<>();
            headers.put("authority", authority);
            AttachmentVO attachmentVO = null;
            try {
                //保存新的模板文件
                String fileUploadRespStr = postFile(baseHost + "ejc-file-web/attachment/upload", params, headers, file
                        .getInputStream(), file.getOriginalFilename());
                logger.info("模板文件信息--" + fileUploadRespStr);
                CommonResponse<List<AttachmentVO>> attachmentResp = JSONObject.parseObject(fileUploadRespStr, CommonResponse.class);
                logger.info("上传文件返回信息--" + attachmentResp);
                if (!attachmentResp.isSuccess()) {
                    logger.error("保存模板文件失败sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, 原因：{}",
                            sourceId, sourceType, billType, file.getOriginalFilename(), attachmentResp.getMsg());
                    return null;
                }
                attachmentVO = JSONObject.parseObject(JSONObject.toJSONString(attachmentResp.getData().get(0)), AttachmentVO.class);
            }
            catch (Exception e) {
                logger.error("保存模板文件失败sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, 原因：{}",
                        sourceId, sourceType, billType, file.getOriginalFilename(), e.getMessage());
                return null;
            }
            logger.info("模板文件保存成功：{}", JSONObject.toJSONString(attachmentVO));
            return attachmentVO;
        }
        else {
            return null;
        }
    }

    public static String postFile(String url, Map<String, String> params, Map<String, String> headers,
                                  InputStream inputStream, String fileName) throws Exception {
        String charset = "UTF-8";
        HttpClient client = null;

        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        Integer readTimeout = 10000;

        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create()
                    .setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("file",
                    inputStream, ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), fileName);
            for (String key : params.keySet()) {
                builder.addPart(key, new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA
                        .withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);

            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout);
            }

            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout);
            }

            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key = null;
                Iterator it = headers.keySet().iterator();

                while (it.hasNext()) {
                    key = (String) it.next();
                    post.addHeader(key, (String) headers.get(key));
                }
            }
            else {
                request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }

            HttpResponse res;
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = ((HttpClient) client).execute(post);
            }
            else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager(cm).build();
                res = ((HttpClient) client).execute(post);
            }

            result = IOUtils.toString(res.getEntity().getContent(), charset);
        }
        finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient) client).close();
            }
        }

        return result;
    }
}
