package com.ejianc.business.supbid.win.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.supbid.win.vo.WinVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.supbid.win.bean.WinEntity;

/**
 * 中标公告
 * 
 * @author generator
 * 
 */
public interface IWinService extends IBaseService<WinEntity> {

    /**
     * 新增或修改
     * @param saveOrUpdateVO 中标数据
     * @return 变更结果
     */
    boolean saveWin(WinVO saveOrUpdateVO);

    /**
     * 查询中标公告列表
     * 公开招标、询价：所有供应商都能看到
     * 其他类型的招标：只有参与报价的供应商才能看到；
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<WinVO> queryWinList(QueryParam param);

    /**
     * 根据ID查询详情
     * @param id 单据id
     * @return 详情
     */
    WinVO queryWinDetail(Long id);
    
}
