/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbid.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMsgUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String MSG_TYPE_NOTICE = "notice";

    public void sendSysMsg(List<String> userList, String subject, String content, Long tenantId, IPushMessageApi pushMessageApi) {
        ArrayList<String> messageTypeList = new ArrayList<String>();
        messageTypeList.add("sys");
        String tenantIdStr = "";
        if (tenantId != null) {
            tenantIdStr = tenantId.toString();
        }
        this.sendMsg(messageTypeList, userList, MSG_TYPE_NOTICE, subject, content, tenantIdStr, null, null, null, pushMessageApi);
    }

    public void sendMsg(List<String> messageTypeList, List<String> userList, String msgType, String subject, String content, String tenantId, String cgddAgentid, String cgddSecret, String url, IPushMessageApi pushMessageApi) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageTypeList.contains("sys")) {
            channel.add("sys");
        }
        if (messageTypeList.contains("smsg")) {
            // empty if block
        }
        if (messageTypeList.contains("weChat")) {
            channel.add("weixinee");
        }
        String[] receivers = userList.toArray(new String[0]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[0]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageTypeList.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", (Object)cgddAgentid);
            weixineeParams.put("secret", (Object)cgddSecret);
            weixineeParams.put("msgtype", (Object)"textcard");
            weixineeParams.put("title", (Object)"\u6d88\u606f\u63d0\u9192");
            weixineeParams.put("description", (Object)subject);
            weixineeParams.put("url", (Object)url);
            weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
            parameter.setWeixineeParams(weixineeParams);
        }
        try {
            this.logger.info("\u6d88\u606f\u53d1\u9001\u53c2\u6570---------------->{}", (Object)JSON.toJSONString((Object)parameter));
            CommonResponse result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.info("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------", (Throwable)e);
        }
    }

    public void sendWeiXinMsg(List<String> userList, String subject, String content, String tenantId, HashMap<String, Object> weixinMap, String weixinCheckTemplateId, String mobileUrl, IPushMessageApi pushMessageApi) {
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("weixinSupplier");
        channel.add("sys");
        String[] receivers = userList.toArray(new String[0]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[0]));
        parameter.setMsgType(MSG_TYPE_NOTICE);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (StringUtils.isNotBlank((String)weixinCheckTemplateId)) {
            JSONObject weixinParams = new JSONObject();
            weixinParams.put("template_id", (Object)weixinCheckTemplateId);
            JSONObject wxparams = new JSONObject();
            wxparams.putAll(weixinMap);
            weixinParams.put("data", (Object)wxparams);
            weixinParams.put("url", (Object)mobileUrl);
            parameter.setWeixinParams(weixinParams);
        } else {
            this.logger.info("\u672a\u914d\u7f6e\u5fae\u4fe1\u516c\u4f17\u53f7\u6a21\u677f\uff0c\u6545\u4e0d\u53d1\u5fae\u4fe1\u516c\u4f17\u53f7\u6d88\u606f");
        }
        try {
            this.logger.info("\u5fae\u4fe1\u6d88\u606f\u53d1\u9001\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)parameter));
            CommonResponse result = pushMessageApi.pushMessage(parameter);
            this.logger.info("\u5fae\u4fe1\u6d88\u606f\u53d1\u9001\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }
}

