package com.ejianc.business.supbid.notice.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.supbid.notice.vo.NoticeVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 公告实体
 *
 * @author generator
 */
@Mapper
public interface NoticeMapper extends BaseCrudMapper<NoticeEntity> {

    List<NoticeVO> queryInvitation(@Param(Constants.WRAPPER) QueryWrapper queryWrapper,
                                   @Param("signStatus") Integer signStatus, @Param("tenantId") String tenantId);

    List<NoticeVO> queryAllList(@Param(Constants.WRAPPER) QueryWrapper queryWrapper,
                                @Param("tenantId") String tenantId);

    /**
     * 查询招标门户列表信息
     *
     * @param queryWrapper   查询条件
     * @param tenderTypeList 查询类型
     * @param tenantId       租户ID
     * @param systemIdList   企业ID
     * @param overFlag       倒计时是否结束
     * @param page           分页信息
     * @return 查询结果
     */
    List<NoticeVO> queryHomeList(@Param(Constants.WRAPPER) QueryWrapper<NoticeEntity> queryWrapper,
                                 @Param("tenderTypeList") List<Integer> tenderTypeList,
                                 @Param("tenantId") String tenantId,
                                 @Param("systemIdList") List<String> systemIdList,
                                 @Param("overFlag") String overFlag,
                                 IPage<NoticeEntity> page);

    List<NoticeVO> queryCounts(@Param("tenantId") String tenantId);
}
