package com.ejianc.business.supbid.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.vo.*;
import com.ejianc.business.supbid.util.CommonUtils;
import com.ejianc.business.supbid.util.SendMsgUtils;
import com.ejianc.business.supbid.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import feign.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.notice.mapper.SignMapper;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.ISignService;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 报名实体
 *
 * @author generator
 */
@Service("signService")
public class SignServiceImpl extends BaseServiceImpl<SignMapper, SignEntity> implements ISignService {

    /** 废标标志：0-正常 */
    private static final Integer ABOLISH_TYPE_0 = 0;
    /** 废标标志：1-流标 */
    private static final Integer ABOLISH_TYPE_1 = 1;
    /** 废标标志：2-废标 */
    private static final Integer ABOLISH_TYPE_2 = 2;
    /** 采购方式：1-单位采购 */
    private static final Integer PURCHASE_TYPE_1 = 1;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private CacheManager cacheManager;
    // 材料
    @Value("${gcyUrl.signUpUrl}")
    private String signUpUrl;

    @Value("${gcyUrl.tokenUrl}")
    private String tokenUrl;

    // 分包
    @Value("${gcyUrl.subSignUpUrl}")
    private String subSignUpUrl;
    // 设备
    @Value("${gcyUrl.purchaseSignUpUrl}")
    private String purchaseSignUpUrl;
    // 设备租赁
    @Value("${gcyUrl.rentSignUpUrl}")
    private String rentSignUpUrl;
    // 周转材租赁
    @Value("${gcyUrl.rmatSignUpUrl}")
    private String rmatSignUpUrl;
    // 其他
    @Value("${gcyUrl.otherSignUpUrl}")
    private String otherSignUpUrl;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private INoticeService noticeService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    /**
     * 供应商报名
     *
     * @param saveorUpdateVO
     * @return
     * @throws Exception
     */
    @Override
    public CommonResponse<SignVO> save(SignVO saveorUpdateVO) throws Exception {
        SignEntity entity = BeanMapper.map(saveorUpdateVO, SignEntity.class);
        // 如果存在已报名的数据，则提示重复操作（防止在招标门户页面上打开了多个报名页签，误操作）
        // 20220621 需求修改，报名截止之前，允许修改报名信息
//        List<SignEntity> signEntityList = super
//                .list((Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getSourceId, saveorUpdateVO.getSourceId()))
//                        .in(SignEntity::getTenantId, InvocationInfoProxy.getTenantid())
//                        .eq(SignEntity::getSignStatus, 0));
//        if (CollectionUtils.isNotEmpty(signEntityList)) {
//            return CommonResponse.error("您的单据已被其他同事操作，请刷新后重试！");
//        }
        if (null != saveorUpdateVO.getsId()) {
            entity.setId(saveorUpdateVO.getsId());
        }

        // 获取systemId
        NoticeEntity noticeEntity = noticeService.selectById(entity.getNoticeId());
        if (noticeEntity.getAbolishType() != 0) {
            throw new BusinessException("该标已流标，不可以报名");
        }
        String systemId = noticeEntity.getSystemId();
        // 租户ID和供应商ID对应关系
//        Map<String,String> sourceTenantMap = new HashMap<>();
//        sourceTenantMap.put("1471726626618441730","1406947724700246112");
//        sourceTenantMap.put("1471729176256151553","1406947724700246113");
//        sourceTenantMap.put("1471731643794554881","1406947724700246114");
//        sourceTenantMap.put("1472852233918054402","527888337260777477");
//        sourceTenantMap.put("1473189202070044674","528220972239556690");
//        sourceTenantMap.put("1473189172567310338","528222266413027386");
//        sourceTenantMap.put("1473189113180160002","528222429273657395");
//        sourceTenantMap.put("1473190529172996098","528222690796900362");
//        // 根据租户ID查找供应商ID
//        String sourceSupplierId = sourceTenantMap.get(InvocationInfoProxy.getTenantid().toString());

        noticeService.checkCooperateEnterprise(systemId, 0);
        logger.info("查询供应商信息，查询参数：systemId：{}，tenantId:{}", systemId, InvocationInfoProxy.getTenantid());
        CommonResponse<Long> supplierResponse = cooperateEnterpriseApi
                .getCooperateSupplierIdByTenantIdAndEnterpriseId(InvocationInfoProxy.getTenantid(), systemId);
        if (!supplierResponse.isSuccess()) {
            logger.error("未查询到供应商信息！查询结果：{}，错误信息:{}", supplierResponse.isSuccess(), supplierResponse.getMsg());
            return CommonResponse.error("未查询到供应商信息！");
        }
        String sourceSupplierId = supplierResponse.getData().toString();
//        entity.setSourceSupplierId("478618055086850100");
        entity.setSourceSupplierId(sourceSupplierId);
        entity.setSignStatus(0);//已报名
        super.saveOrUpdate(entity, false);
        SignVO vo = BeanMapper.map(entity, SignVO.class);
        vo.setsId(entity.getId());

        BmNoticeVO bmNoticeVO = BeanMapper.map(entity, BmNoticeVO.class);
        bmNoticeVO.setEmployeeId(entity.getSignEmployeeId());
        bmNoticeVO.setEmployeeName(entity.getSignEmployeeName());
        bmNoticeVO.setEmployeeMobile(entity.getSignEmployeeMobile());
        bmNoticeVO.setTenantId(InvocationInfoProxy.getTenantid());
        bmNoticeVO.setSignTime(new Date());
        bmNoticeVO.setSourceSupplierId(entity.getSourceSupplierId());
        bmNoticeVO.setSubType(noticeEntity.getSubType());
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi
                .queryListBySourceId(entity.getId(), "BT211123000000004", "bmFiles", null);
//        Long attachId = null;
//        String fileName = "";
//        InputStream inputStream = null;
        if (!listCommonResponse.isSuccess()) {
            // 上面已经操作过数据库，此处需要回滚数据
            throw new BusinessException("查询文件失败！");
        }

        List<AttachmentVO> data = listCommonResponse.getData();
        // 组装文件参数
        // Map<"file",Map<"文件名称",InputStream>>
        Map<String, Map<String, InputStream>> files = null;
        Map<String, String> fileSourceTypeMap = new HashMap<>();
        Map<String, String> params = new HashMap<>();
        List<SupplyFileVo> filePathList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(data)) {
//            attachId = data.get(0).getId();
//            fileName = data.get(0).getFileName();
//            files = new HashMap<>();
//            for (AttachmentVO attachmentVO : data) {
//                Map<String, InputStream> fileMap = new HashMap<>(1);
//                Response fileResponse = attachmentApi.downloadFileById(attachmentVO.getId());
//                Response.Body body = fileResponse.body();
////                inputStream = body.asInputStream();
////                String key = attachmentVO.getFileName().substring(0, attachmentVO.getFileName().indexOf("."));
//                String key = attachmentVO.getFileName();
//                fileMap.put(key, body.asInputStream());
//                fileSourceTypeMap.put(key, "BmSupplierFileType");
//                files.put(key, fileMap);
//            }
////            files.put("file", fileMap);
//            params.put("fileSourceType", JSONObject.toJSONString(fileSourceTypeMap));
            // 20220801 修改，文件传全路径
            for (AttachmentVO attachmentVO : data) {
                SupplyFileVo supplyFileVo = new SupplyFileVo();
                supplyFileVo.setFileName(attachmentVO.getFileName());
                supplyFileVo.setFilePath(baseHost + attachmentVO.getFilePath());
                supplyFileVo.setFileId(attachmentVO.getId());
                filePathList.add(supplyFileVo);
            }
        }
        bmNoticeVO.setSupplyFileList(filePathList);
        String bmNotice = JSONObject.toJSONString(bmNoticeVO);
        params.put("bmNoticeVO", bmNotice);
        logger.info("bmNoticeVO--" + bmNotice);
        Map<String, String> headers = new HashMap<>();
        String url;
        // 材料招标
        if (CommonUtils.TYPE_MATERIAL.equals(noticeEntity.getType())) {
            url = signUpUrl;
        }
        // 分包招标
        else if (CommonUtils.TYPE_SUB.equals(noticeEntity.getType())) {
            url = subSignUpUrl;
        }
        // 设备招标
        else if(CommonUtils.TYPE_PURCHASE.equals(noticeEntity.getType())){
            url = purchaseSignUpUrl;
        }
        // 设备租赁
        else if(CommonUtils.TYPE_RENT.equals(noticeEntity.getType())){
            url = rentSignUpUrl;
        }
        // 周转材租赁
        else if(CommonUtils.TYPE_RMAT.equals(noticeEntity.getType())){
            url = rmatSignUpUrl;
        }
        // 其他
        else if (CommonUtils.TYPE_OTHER.equals(noticeEntity.getType())) {
            url = otherSignUpUrl;
        }
        else {
            logger.error("招标类型不存在[{}]", noticeEntity.getType());
            throw new BusinessException("招标类型不存在");
        }
        logger.info("signUpUrl--" + url + "---tokenUrl----" + tokenUrl);
        // 报名报价资质校验
        noticeService.checkSignOrBj(noticeEntity.getSourceId(), entity.getSourceSupplierId(), noticeEntity.getType(), 0, systemId);

        // 公有云--->>>私有云
        logger.info("-----开始调用私有云----");
        logger.info("参数--->>>url:[{}],systemId:[{}],params:【{}】,files:【{}】", url, systemId, params, files);
        CommonResponse<String> commonResponse = systemDataPushService
                .exchangeDataAndFilesWithThirdSystem(url, params, systemId, files);
        logger.info("-----调用私有云结束----调用结果：{}", commonResponse.isSuccess());
        // 校验返回结果
        CommonUtils.checkCommonResponse(commonResponse, logger);
//            if (!commonResponse.isSuccess()) {
//                logger.error("推送数据失败！失败原因：{}", commonResponse.getMsg());
//                // 上面已操作过数据库，需要抛出异常进行回滚
//                throw new BusinessException("推送数据失败！");
//            }
//            String s = new ThirdSystemUtils().postFile(tokenUrl, signUpUrl, params,
//                    headers, inputStream, cacheManager, fileName);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public Boolean updateSignStatus(List<SignVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> supTendentIds = new ArrayList<>();
            List<String> sourceSupplierIds = new ArrayList<>();
            String sourceId = vos.get(0).getSourceId();
            vos.forEach(e->{
                LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(SignEntity::getTenantId, e.getTenantId());
                updateWrapper.eq(SignEntity::getSourceId, e.getSourceId());
                updateWrapper.eq(SignEntity::getSourceSupplierId, e.getSourceSupplierId());
                updateWrapper.set(SignEntity::getSignStatus, 5);//已淘汰
                updateWrapper.set(SignEntity::getOutReason, e.getOutReason());
                super.update(updateWrapper);
                supTendentIds.add(e.getTenantId());
                sourceSupplierIds.add(e.getSourceSupplierId());
            });
            List<SignEntity> signEntityList = super.list((Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getSourceId,sourceId)).eq(SignEntity::getSignStatus,5).in(SignEntity::getTenantId,supTendentIds).in(SignEntity::getSourceSupplierId, sourceSupplierIds));
            List<NoticeEntity> noticeEntityList = noticeService.list((Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId,sourceId)));
            logger.info("开始组织消息发送内容===========");
            if(CollectionUtils.isNotEmpty(signEntityList) && CollectionUtils.isNotEmpty(noticeEntityList)){
                // 接收消息的user
                List<String> userList;
                for (SignEntity sign : signEntityList) {
                    userList = new ArrayList<>();
                    if (sign.getSignId() != null) {
                        userList.add(sign.getSignId().toString()); // 报名操作人
                    }
                    // 去重，防止一个人接收到多条相同的信息
                    userList = userList.stream().distinct().collect(Collectors.toList());
//                userList.signEntityList.stream().map(SignEntity::getSignId).collect(Collectors.toList());
                    // 获取公告信息
                    NoticeEntity noticeEntity = noticeEntityList.get(0);
                    String projectName = noticeEntity.getProjectName();
                    // 单位采购使用orgName
                    if (PURCHASE_TYPE_1.equals(noticeEntity.getPurchaseType())) projectName = noticeEntity.getOrgName();
                    // 组装标题及内容
                    String formurl = baseHost + "ejc-supbid-frontend/#/eliminated?id=" + noticeEntity.getId();
                    String mobileurl = baseHost + "ejc-supbid-mobile/#/inProgressList/eliminated?id=" + noticeEntity.getId();
                    String subject = "您投标的【" + noticeEntity.getUnitName() + "】所招标的【" + projectName + "】已被招标方淘汰";
                    String content = "您投标的【" + noticeEntity.getUnitName() + "】所招标的【" + projectName + "】已被招标方淘汰，" +
                            "<a href= '" + formurl + "'" + ">查看详情</a>";
                    new SendMsgUtils().sendSysMsg(userList, subject, content, sign.getTenantId(), pushMessageApi,mobileurl);
                }
            }
        }
        return true;
    }

    @Override
    public Boolean updateBidOut(String sourceId, int type, String outReason) {
        // 废标标志是流标或者废标时，需要发送消息
        boolean abolishTypeFlag = (ABOLISH_TYPE_1.equals(type) || ABOLISH_TYPE_2.equals(type));
        // 修改状态前，先查询出剔除的供应商ID
        List<Long> outList = new ArrayList<>();
        if (abolishTypeFlag){
            // 先查出已剔除的供应商
            QueryParam param = new QueryParam();
            param.getParams().put("sourceId", new Parameter(QueryParam.EQ, sourceId));
            param.getParams().put("signStatus", new Parameter(QueryParam.EQ, 5));
            List<SignEntity> outSignEntityList = super.queryList(param);
            // 已剔除的供应商ID集合
            outList = outSignEntityList.stream().map(SignEntity::getId).collect(Collectors.toList());
        }
        // 修改供应商状态
        LambdaUpdateWrapper<NoticeEntity> updateWrappern = new LambdaUpdateWrapper<>();
        updateWrappern.eq(NoticeEntity::getSourceId, sourceId);
        updateWrappern.set(NoticeEntity::getAbolishType, type);
        noticeService.update(updateWrappern);

        LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SignEntity::getSourceId, sourceId);
        updateWrapper.ne(SignEntity::getSignStatus, 5);
        updateWrapper.set(SignEntity::getSignStatus, 5);//已淘汰
        updateWrapper.set(SignEntity::getOutReason, outReason);
        boolean flag = super.update(updateWrapper);
        // 推送内部消息
        if (abolishTypeFlag) {
            String text = "";
            if (ABOLISH_TYPE_1.equals(type)) text = "已流标";
            if (ABOLISH_TYPE_2.equals(type)) text = "已废标";
            // 查询所需信息
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("sourceId",new Parameter(QueryParam.EQ, sourceId));
            // 已剔除的供应商不发送消息
            if (CollectionUtils.isNotEmpty(outList)) queryParam.getParams().put("id", new Parameter(QueryParam.NOT_IN, outList));

            List<SignEntity> signEntityList = super.queryList(queryParam);
            List<NoticeEntity> noticeEntityList = noticeService.queryList(queryParam);
            logger.info("开始组织消息发送内容===========");
            if (CollectionUtils.isNotEmpty(signEntityList) && CollectionUtils.isNotEmpty(noticeEntityList)) {
                // 接收消息的user
                List<String> userList;
                for (SignEntity sign : signEntityList) {
                    userList = new ArrayList<>();
                    if (sign.getSignId() != null) userList.add(sign.getSignId().toString()); // 报名操作人
                    if (sign.getSchemeId() != null) userList.add(sign.getSchemeId().toString()); // 报价操作人
                    // 去重，防止一个人接收到多条相同的信息
                    userList = userList.stream().distinct().collect(Collectors.toList());
                    // 获取公告信息
                    NoticeEntity noticeEntity = noticeEntityList.get(0);
                    String projectName = noticeEntity.getProjectName();
                    // 单位采购使用orgName
                    if (PURCHASE_TYPE_1.equals(noticeEntity.getPurchaseType())) projectName = noticeEntity.getOrgName();
                    // 组装标题及内容
                    String formurl = baseHost + "ejc-supbid-frontend/#/eliminated?id=" + noticeEntity.getId();
                    String mobileurl = baseHost + "ejc-supbid-mobile/#/inProgressList/eliminated?id=" + noticeEntity.getId();
                    String subject = "【" + noticeEntity.getUnitName() + "】招标的【" + projectName + "】" + text;
                    String content = "【" + noticeEntity.getUnitName() + "】招标的【" + projectName + "】" + text +
                            "，<a href= '" + formurl + "'" + ">点击查看详情</a>";
                    new SendMsgUtils().sendSysMsg(userList, subject, content, sign.getTenantId(), pushMessageApi,mobileurl);
                }
            }
        }
        return flag;
    }
}

