package com.ejianc.business.supbid.sub.bean;

import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.supbid.sub.bean.SubSchemeDetailEntity;

/**
 * 分包方案实体
 *
 * @author generator
 */
@TableName("ejc_supbid_sub_scheme")
public class SubSchemeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "notice_id")
    private java.lang.Long noticeId; // 主表主键
    @TableField(value = "source_id")
    private String sourceId; // 招标信息主键
    @TableField(value = "scheme_name")
    private String schemeName; // 方案名称
    @TableField(value="mny")
    private BigDecimal mny; // 报价总额
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 报价总额(含税)


    @TableField(exist = false)
    @SubEntity(serviceName = "subSchemeDetailService", pidName = "schemeId")//此处有pid="xxx"，默认值pid="pid"
    private List<SubSchemeDetailEntity> subSchemeDetailList = new ArrayList<>(); // 分包报价明细实体


    public java.lang.Long getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSchemeName() {
        return schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public List<SubSchemeDetailEntity> getSubSchemeDetailList() {
        return subSchemeDetailList;
    }

    public void setSubSchemeDetailList(List<SubSchemeDetailEntity> subSchemeDetailList) {
        this.subSchemeDetailList = subSchemeDetailList;
    }
}
