package com.ejianc.business.supbid.win.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.util.DateUtils;
import com.ejianc.business.supbid.util.SendMsgUtils;
import com.ejianc.business.supbid.win.bean.WinDetailEntity;
import com.ejianc.business.supbid.win.bean.WinEntity;
import com.ejianc.business.supbid.win.mapper.WinMapper;
import com.ejianc.business.supbid.win.service.IWinService;
import com.ejianc.business.supbid.win.vo.WinVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 中标公告
 *
 * @author generator
 */
@Service("winService")
public class WinServiceImpl extends BaseServiceImpl<WinMapper, WinEntity> implements IWinService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;

    @Autowired
    private ISignService signService;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IPushMessageApi pushMessageApi;

    /** 中标公告消息发送模板 */
    private String WEIXIN_TENDER_MSG_INVITATION = "zPmNzDvvFsai2naZFVEuODPWzwgeigu25dsDUvz7kT8";

    /**
     * 采购方式：1-单位采购
     */
    private static final Integer PURCHASE_TYPE_1 = 1;

    /**
     * 新增或修改
     *
     * @param saveOrUpdateVO 中标数据
     * @return 变更结果
     */
    @Override
    public boolean saveWin(WinVO saveOrUpdateVO) {
        logger.info("接收中标公告，sourceID->[{}]", saveOrUpdateVO.getSourceId());
        WinEntity entity = BeanMapper.map(saveOrUpdateVO, WinEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            // 新增时查询是否已存在中标公告，一个项目只能存在一个中标公告，多次传中标公告则进行修改操作
            QueryParam param = new QueryParam();
            param.getParams().put("sourceId", new Parameter(QueryParam.EQ, entity.getSourceId()));
            List<WinEntity> winEntityList = super.queryList(param);
            if (CollectionUtils.isNotEmpty(winEntityList)) {
                entity.setId(winEntityList.get(0).getId());
            }
            QueryParam queryParam = new QueryParam();
            // 所有报价的操作人 都应该收的中标公告消息，包括淘汰的人
            queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getSourceId()));
            List<SignEntity> signEntityList = signService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty(signEntityList)) {
                logger.info("供应商数量【{}】", signEntityList.size());
                // 接收消息的user
                List<String> userList;
                for (SignEntity sign : signEntityList) {
                    userList = new ArrayList<>();
                    if (sign.getSignId() != null) userList.add(sign.getSignId().toString()); // 报名操作人
                    if (sign.getSchemeId() != null) userList.add(sign.getSchemeId().toString()); // 报价操作人
                    try {
                        userList = userList.stream().distinct().collect(Collectors.toList());//消息消费者去重
                        this.sendWeChatMsgByMap(userList, 1, WEIXIN_TENDER_MSG_INVITATION, entity, sign);
                    }
                    catch (Exception e) {
                        logger.info("消息发送失败！失败原因：{}", e.getMessage(), e);
                    }
                }


            }
        }
        return super.saveOrUpdate(entity, false);
    }

    /**
     * 发送微信消息
     *
     * @param userList                   用户列表
     * @param tenderType            招标类型，1公开，2邀请（仅发送消息使用，和其他定义的不一致）
     * @param weixinCheckTemplateId 微信消息模板
     * @param winEntity          公告信息
     * @param signEntity           报名信息
     */
    private void sendWeChatMsgByMap(List<String> userList, Integer tenderType, String weixinCheckTemplateId,
                                    WinEntity winEntity, SignEntity signEntity) {
        if (CollectionUtils.isEmpty(userList)) {
            logger.info("查询信息为空！");
            return;
        }
        logger.info("------开始发送微信消息----");
        logger.info("发送消息数量：{}；发送消息类型（1公开，2邀请）：{}；消息模板：{}", userList.size(), tenderType, weixinCheckTemplateId);
        // 循环处理发送消息
        if (CollectionUtils.isNotEmpty(userList)) {
            // 组装标题及内容
            String formurl;
            String subject;
            String content;
            HashMap<String, Object> weixinMap = new HashMap<>();
            String mobileUrl;
            List<WinDetailEntity> winDetailList = winEntity.getWinDetailList();
            StringBuffer supplierNames = new StringBuffer();
            for(int i=0;i<winDetailList.size();i++){
                if(i==(winDetailList.size()-1)){
                    supplierNames.append(winDetailList.get(i).getSupplierName());
                }else{
                    supplierNames.append(winDetailList.get(i).getSupplierName()+",");
                }
            }
            String winDate = DateUtils.transformationDate(winEntity.getWinDate(), DateUtils.YYYY_MM_DD_HH_MM_SS);
            formurl = "";
            subject = "您好，您参与的竟价项目结果已经公布";
            content = "您好，您参与的竟价项目结果已经公布";
//                        "<a href= '" + formurl + "'" + ">点击查看详情</a>";
            mobileUrl = BASE_HOST+"ejc-supbid-mobile/#/bidWinning?openid={openid}";
            weixinMap.put("first", "您好，您参与的竟价项目结果已经公布"); // 招标名称
            weixinMap.put("keyword1", winEntity.getTenderName()); // 招标名称
            weixinMap.put("keyword2", winDate); // 中标时间
            weixinMap.put("remark", "由 【"+supplierNames+"】中标，点击查看详情");
            new SendMsgUtils().sendWeiXinMsg(userList, subject, content, signEntity.getTenantId().toString(),
                    weixinMap, weixinCheckTemplateId, mobileUrl, pushMessageApi);
        }
        logger.info("------发送微信消息结束----");
    }

    /**
     * 查询中标公告列表
     * 公开招标、询价：所有供应商都能看到
     * 其他类型的招标：只有参与报价的供应商才能看到；
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<WinVO> queryWinList(QueryParam param) {
        // 模糊搜索配置字段示例
        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("employeeName");
//        fuzzyFields.add("employeeMobile");
        fuzzyFields.add("winTitle"); // 标题
        fuzzyFields.add("unitName"); // 中标单位

//        param.getOrderMap().put("create_time", QueryParam.DESC);
        // 租户隔离
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 招标方式为公开、询价，或者是参与报价
        List<Integer> tenderTypeList = new ArrayList<>();
        tenderTypeList.add(0);//公开
        tenderTypeList.add(2);//询价
        // 查询合作企业的systemId
        CommonResponse<List<String>> response = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            logger.error("获取合作企业信息失败！失败原因：{}",response.getMsg());
            throw new BusinessException("获取合作企业信息失败");
        }
        List<String> systemIdList = response.getData();
        logger.info("合作企业信息：{}",systemIdList);
        IPage<WinEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());
        if(CollectionUtils.isNotEmpty(systemIdList)){
            List<WinVO> winVOList = baseMapper.queryWinList(changeToQueryWrapper(param), tenderTypeList,
                    String.valueOf(InvocationInfoProxy.getTenantid()), systemIdList, page);
            IPage<WinVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(winVOList);
            return pageData;
        }else{
            IPage<WinVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            return pageData;
        }
    }

    /**
     * 根据ID查询详情
     *
     * @param id 单据id
     * @return 详情
     */
    @Override
    public WinVO queryWinDetail(Long id) {
        WinEntity entity = super.selectById(id);
        if (entity == null) {
            return new WinVO();
        }
        WinVO vo = BeanMapper.map(entity, WinVO.class);
        vo.setTypeName(getTypeName(vo.getType()));
        return vo;
    }

    /**
     * 根据type获取招标类型名称
     * @param type 招标类型代码
     * @return 招标类型名称
     */
    private String getTypeName(String type) {
        if (StringUtils.isEmpty(type)) return null;
        switch (type) {
            case "MATERIAL":
                return "材料招标";
            case "SUB":
                return "分包招标";
            case "PURCHASE":
                return "设备采购招标";
            case "RENT":
                return "设备租赁招标";
            case "RMAT":
                return "周转材租赁招标";
            case "OTHER":
                return "其他招标";
        }
        return null;
    }
}
