package com.ejianc.business.supbid.notice.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.vo.NoticeVO;
import com.ejianc.business.supbid.notice.vo.NumsVO;
import com.ejianc.business.supbid.notice.vo.SupOfferVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.http.HttpRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

/**
 * 公告实体
 * 
 * @author generator
 * 
 */
public interface INoticeService extends IBaseService<NoticeEntity> {

    CommonResponse<Boolean> save(NoticeVO saveorUpdateVO);

    CommonResponse<Boolean> saveWj(HttpServletRequest request,MultipartFile file);

    CommonResponse<Boolean> addFile(HttpServletRequest request,MultipartFile file);

    CommonResponse<String> delFile(String sourceId,List<String> fileNames);
    CommonResponse<NoticeVO> saveFile(NoticeVO saveorUpdateVO) throws Exception;

    CommonResponse<Boolean> updateTime(NoticeVO saveorUpdateVO);

    Boolean updateSupOffer(List<SupOfferVO> vos);

    NoticeVO queryDetail(Long id);

    NoticeVO queryFileDetail(Long id);

    List<NoticeVO> queryInvitationList(QueryWrapper queryWrapper,Integer tenderType,String tenantId);

    List<NoticeVO> queryAllList(QueryWrapper queryWrapper, String tenantId);

    /**
     * 查询供方门户招标列表数据
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<NoticeVO> queryHomeList(QueryParam param);

    NumsVO queryCounts();

    /**
     * 校验供应商合作企业是否包含该数据，如果招标单位没有与供应商合作，则抛出异常
     *
     * @param systemId 招标单位私有云id
     * @param type     0报名，1报价
     */
    void checkCooperateEnterprise(String systemId, Integer type);

    /**
     * 报名报价前进行校验
     *
     * @param inviteId   招标立项id
     * @param supplierId 供应商id
     * @param type       招标类型
     * @param flag       报名报价类型 0报名1报价
     * @param systemId   systemId
     */
    void checkSignOrBj(String inviteId, String supplierId, String type, Integer flag, String systemId);

    /**
     * 定时统计公开、询价的招标发送消息
     *
     * @param date 日期
     */
    void timingSendMsg(Date date);
}
