package com.ejianc.business.supbid.notice.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.supbid.notice.vo.FileVO;
import com.ejianc.business.supbid.notice.vo.NumsVO;
import com.ejianc.business.supbid.notice.vo.SupOfferVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.vo.NoticeVO;
import org.springframework.web.multipart.MultipartFile;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 公告实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("notice")
@Api(value = "公告实体", tags = {"公告实体"})
public class NoticeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private INoticeService service;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody NoticeVO saveorUpdateVO) {
    	return service.save(saveorUpdateVO);
    }


    @ApiOperation("文件推送接口")
    @RequestMapping(value = "/saveWj", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> saveWj(HttpServletRequest request, @RequestParam(value = "file",required = false) MultipartFile file){
        return service.saveWj(request,file);
    }

    @ApiOperation("新增附件")
    @RequestMapping(value = "/addFile", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> addFile(HttpServletRequest request, @RequestParam("file") MultipartFile file){
        return service.addFile(request,file);
    }

    @ApiOperation("删除附件")
    @RequestMapping(value = "/delFile", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delFile(@RequestBody FileVO vo){
        return service.delFile(vo.getSourceId(),vo.getFileNames());
    }

    @ApiOperation("文件新增")
    @RequestMapping(value = "/saveFile", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<NoticeVO> saveFile(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody NoticeVO saveorUpdateVO) throws Exception{
        return service.saveFile(saveorUpdateVO);
    }

    @ApiOperation("延长截止时间")
    @RequestMapping(value = "/updateTime", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> updateTime(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody NoticeVO saveorUpdateVO) {
        return service.updateTime(saveorUpdateVO);
    }

    @ApiOperation("供应商补充报价接口")
    @RequestMapping(value = "/updateSupOffer", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> updateSupOffer(@RequestBody List<SupOfferVO> supOfferList) {
        return CommonResponse.success("成功！",service.updateSupOffer(supOfferList));
    }

    @ApiOperation("公告查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<NoticeVO> queryDetail(@RequestParam Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }

    @ApiOperation("获取系统当前时间")
    @RequestMapping(value = "/queryNowDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Date> queryNowDate() {
        return CommonResponse.success("查询详情数据成功！",new Date());
    }

    @ApiOperation("文件查询详情")
    @RequestMapping(value = "/queryFileDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<NoticeVO> queryFileDetail(@RequestParam Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryFileDetail(id));
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<NoticeVO> vos) {
        service.removeByIds(vos.stream().map(NoticeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询邀请招标待报名")
    @RequestMapping(value = "/queryApplyList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<NoticeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        IPage<NoticeEntity> page = service.queryPage(param,false);
        IPage<NoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), NoticeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @ApiOperation("查询报名状态列表")
    @RequestMapping(value = "/querySignList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<NoticeVO>> querySignList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        param.getOrderMap().put("create_time",QueryParam.DESC);
        QueryWrapper wrapper = changeToQueryWrapper(param);
        Integer signStatus = Integer.parseInt(param.getParams().get("signStatus").getValue().toString());
        List<NoticeVO> listres = service.queryInvitationList(wrapper,signStatus,InvocationInfoProxy.getTenantid()+"");
        return CommonResponse.success("查询列表数据成功！",listres);
    }


    @ApiOperation("查询数量")
    @RequestMapping(value = "/queryCounts", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<NumsVO> queryCounts(@RequestBody QueryParam param) {
        return CommonResponse.success("查询成功！",service.queryCounts());
    }

    @ApiOperation("查询公开招标列表")
    @RequestMapping(value = "/queryAllList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<NoticeVO>> queryAllList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        List<Integer> list = new ArrayList<>();
        list.add(0);//公开
        list.add(2);//询价

        List<Integer> abolishTypeList = new ArrayList<>();
        abolishTypeList.add(1);//流标
        abolishTypeList.add(2);//废标
        param.getParams().put("tenderType", new Parameter(QueryParam.IN, list));//公开招标列表
        param.getParams().put("abolishType", new Parameter(QueryParam.NOT_IN, abolishTypeList));
        param.getOrderMap().put("create_time", QueryParam.DESC);
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<NoticeVO> listres = service.queryAllList(wrapper, InvocationInfoProxy.getTenantid() + "");
        IPage<NoticeEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());
        IPage<NoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(listres);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("查询招标门户列表")
    @RequestMapping(value = "/queryHomeList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<NoticeVO>> queryHomeList(@RequestBody QueryParam param) {
        IPage<NoticeVO> pageData = service.queryHomeList(param);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<NoticeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Notice-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refNoticeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<NoticeVO>> refNoticeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<NoticeEntity> page = service.queryPage(param,false);
        IPage<NoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), NoticeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description shelfGoods 公开、询价定时发送消息
     */
    @RequestMapping(value = "/timingSendMsg", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> timingSendMsg(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param);
        logger.info("获取到的参数JSON是：" + param + "----");
        service.timingSendMsg(new Date());
        return CommonResponse.success("定时任务处理成功");
    }
}
