package com.ejianc.business.supbid.material.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.material.vo.SchemeRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbid.material.mapper.SchemeRecordMapper;
import com.ejianc.business.supbid.material.bean.SchemeRecordEntity;
import com.ejianc.business.supbid.material.service.ISchemeRecordService;

import java.util.ArrayList;
import java.util.List;

/**
 * 洽商谈判方案记录表
 * 
 * @author generator
 * 
 */
@Service("schemeRecordService")
public class SchemeRecordServiceImpl extends BaseServiceImpl<SchemeRecordMapper, SchemeRecordEntity> implements ISchemeRecordService{

    @Override
    public List<SchemeRecordVO> queryListbySourceId(Long noticeId) {
        List<SchemeRecordVO> res = new ArrayList<>();
        List<SchemeRecordEntity> schemeRecordEntityList = super.list(Wrappers.<SchemeRecordEntity>lambdaQuery().eq(SchemeRecordEntity::getNoticeId,noticeId).eq(SchemeRecordEntity::getTenantId,InvocationInfoProxy.getTenantid()).orderByAsc(SchemeRecordEntity::getSchemeName));
        if(CollectionUtils.isNotEmpty(schemeRecordEntityList)){
            schemeRecordEntityList.forEach(e->{
                SchemeRecordEntity schemeRecordEntity = super.selectById(e.getId());
                res.add(BeanMapper.map(schemeRecordEntity,SchemeRecordVO.class));
            });
        }
        return res;
    }
}
