package com.ejianc.business.supbid.notice.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.supbid.other.bean.OtherDetailEntity;
import com.ejianc.business.supbid.purchase.bean.PurchaseDetailEntity;
import com.ejianc.business.supbid.rent.bean.RentDetailEntity;
import com.ejianc.business.supbid.rmat.bean.*;
import com.ejianc.business.supbid.sub.bean.SubDetailEntity;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.material.bean.SchemeEntity;
import com.ejianc.business.supbid.material.bean.DetailEntity;
import com.ejianc.business.supbid.notice.bean.ContentEntity;
import com.ejianc.business.supbid.notice.bean.FilecontentEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

/**
 * 公告实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supbid_notice")
public class NoticeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="source_type")
    private java.lang.String sourceType; // 系统标识
    @TableField(value="source_id")
    private java.lang.String sourceId; // 系统标识
    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value="source_project_id")
    private java.lang.String sourceProjectId; // 发布项目ID
    @TableField(value="project_name")
    private java.lang.String projectName; // 发布项目名称
    @TableField(value="project_code")
    private java.lang.String projectCode; // 发布项目编号
    @TableField(value="source_org_id")
    private java.lang.String sourceOrgId; // 发布组织ID
    @TableField(value="org_name")
    private java.lang.String orgName; // 发布组织名称
    @TableField(value="source_unit_id")
    private java.lang.String sourceUnitId; // 招标单位ID
    @TableField(value="unit_name")
    private java.lang.String unitName; // 招标单位名称
    @TableField(value="memo")
    private java.lang.String memo; // 备注
    @TableField(value="type")
    private java.lang.String type; // 类型(1-材料采购招标，2-分包招标,3-设备采购招标，4-设备租赁招标，5-周转材租赁招标，6-其他招标)
    @TableField(value="tender_name")
    private java.lang.String tenderName; // 招标名称
    @TableField(value="tender_type")
    private java.lang.Integer tenderType; // 招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
    @TableField(value="purchase_name")
    private java.lang.String purchaseName; // 采购类别
    @TableField(value="purchase_id")
    private java.lang.String purchaseId; // 采购类别
    @TableField(value="source_employee_id")
    private java.lang.String sourceEmployeeId; // 招标联系人
    @TableField(value="employee_name")
    private java.lang.String employeeName; // 招标联系人名称
    @TableField(value="employee_mobile")
    private java.lang.String employeeMobile; // 招标联系人电话
    @TableField(value="purchase_type")
    private java.lang.Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    @TableField(value="project_link_name")
    private java.lang.String projectLinkName; // 项目联系人
    @TableField(value="project_link_phone")
    private java.lang.String projectLinkPhone; // 项目联系人电话
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value="notice_start_time")
    private java.util.Date noticeStartTime; // 报名开始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value="notice_end_time")
    private java.util.Date noticeEndTime; // 报名截止时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value="offer_start_time")
    private java.util.Date offerStartTime; // 报价开始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value="offer_end_time")
    private java.util.Date offerEndTime; // 报价结束时间
    @TableField(value="brand_flag")
    private java.lang.Integer brandFlag; // 是否允许多品牌报价,0-是,1-否
    @TableField(value="value_type")
    private java.lang.Integer valueType; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    @TableField(value="talk_num")
    private Integer talkNum; // 洽商轮数
    @TableField(value="talk_money")
    private java.math.BigDecimal talkMoney; // 洽商参考价

    @TableField(value="abolish_type")
    private Integer abolishType; // 流/废标（0-正常，1-流标，2-废标)
    @TableField(value="system_id")
    private String systemId;
    @TableField(value="material_content")
    private java.lang.String materialContent; // 供货内容
    @TableField(value="material_id")
    private java.lang.String materialId; // 供货内容

    @TableField(value="sub_type")
    private Long subType; // 分包类型（0-专业分包，1-劳务分包）
    @TableField(value="project_qualification")
    private String projectQualification; // 工程资质
    @TableField(value="payment_id")
    private String paymentId; // 付款方式
    @TableField(value="payment_name")
    private String paymentName; // 付款方式
    @TableField(value="pay_scale")
    private BigDecimal payScale; // 付款比例
    @TableField(value="rent_type")
    private Integer rentType; // 租赁方式(0-日租,1-月租,2-工程量租)
    @TableField(value="equipment_type")
    private Long equipmentType; // 设备类型（0-机械设备租赁，1-机械承揽）
    @TableField(value="rental_type")
    private Integer rentalType; // 出租运输方式(1-承租方,2-租赁方)
    @TableField(value="back_type")
    private Integer backType; // 归还运输方式(1-承租方,2-租赁方)
    @TableField(value="rental_stacking")
    private Integer rentalStacking; // 出租堆码(1-承租方,2-租赁方)
    @TableField(value="back_stacking")
    private Integer backStacking; // 归还堆码堆码(1-承租方,2-租赁方)
    @TableField(exist=false)
    @SubEntity(serviceName="detailService",pidName = "noticeId")
    private List<DetailEntity> detailList = new ArrayList<>(); // 清单明细实体

    @TableField(exist=false)
    @SubEntity(serviceName="subDetailService",pidName = "noticeId")
    private List<SubDetailEntity> subDetailList = new ArrayList<>(); // 分包清单明细实体

    @TableField(exist=false)
    @SubEntity(serviceName="purchaseDetailService",pidName = "noticeId")
    private List<PurchaseDetailEntity> purchaseDetailList = new ArrayList<>(); // 设备采购清单明细实体

    @TableField(exist=false)
    @SubEntity(serviceName="rentDetailService",pidName = "noticeId")
    private List<RentDetailEntity> rentDetailList = new ArrayList<>(); // 设备租赁清单明细实体

    @TableField(exist=false)
    @SubEntity(serviceName="rmatDetailService",pidName = "noticeId")
    private List<RmatDetailEntity> rmatDetailList = new ArrayList<>(); // 设备租赁清单明细实体

    @TableField(exist=false)
    @SubEntity(serviceName="rmatRepairService",pidName = "noticeId")
    private List<RmatRepairEntity> rmatRepairList = new ArrayList<>(); // 维修标准

    @TableField(exist=false)
    @SubEntity(serviceName="rmatScrapService",pidName = "noticeId")
    private List<RmatScrapEntity> rmatScrapList = new ArrayList<>(); // 报废标准

    @TableField(exist=false)
    @SubEntity(serviceName="rmatSchemeRepairService",pidName = "noticeId")
    private List<RmatSchemeRepairEntity> rmatSchemeRepairList = new ArrayList<>(); // 维修标准-报价

    @TableField(exist=false)
    @SubEntity(serviceName="rmatSchemeScrapService",pidName = "noticeId")
    private List<RmatSchemeScrapEntity> rmatSchemeScrapList = new ArrayList<>(); // 报废标准-报价

    @TableField(exist=false)
    @SubEntity(serviceName="otherDetailService",pidName = "noticeId")
    private List<OtherDetailEntity> otherDetailList = new ArrayList<>(); // 设备租赁清单明细实体

    @TableField(exist=false)
    @SubEntity(serviceName="signService",pidName = "noticeId")
    private List<SignEntity> signList = new ArrayList<>(); // 报名实体

    public List<RmatSchemeRepairEntity> getRmatSchemeRepairList() {
        return rmatSchemeRepairList;
    }

    public void setRmatSchemeRepairList(List<RmatSchemeRepairEntity> rmatSchemeRepairList) {
        this.rmatSchemeRepairList = rmatSchemeRepairList;
    }

    public List<RmatSchemeScrapEntity> getRmatSchemeScrapList() {
        return rmatSchemeScrapList;
    }

    public void setRmatSchemeScrapList(List<RmatSchemeScrapEntity> rmatSchemeScrapList) {
        this.rmatSchemeScrapList = rmatSchemeScrapList;
    }

    public List<RmatRepairEntity> getRmatRepairList() {
        return rmatRepairList;
    }

    public void setRmatRepairList(List<RmatRepairEntity> rmatRepairList) {
        this.rmatRepairList = rmatRepairList;
    }

    public List<RmatScrapEntity> getRmatScrapList() {
        return rmatScrapList;
    }

    public void setRmatScrapList(List<RmatScrapEntity> rmatScrapList) {
        this.rmatScrapList = rmatScrapList;
    }

    public Integer getRentalType() {
        return rentalType;
    }

    public void setRentalType(Integer rentalType) {
        this.rentalType = rentalType;
    }

    public Integer getBackType() {
        return backType;
    }

    public void setBackType(Integer backType) {
        this.backType = backType;
    }

    public Integer getRentalStacking() {
        return rentalStacking;
    }

    public void setRentalStacking(Integer rentalStacking) {
        this.rentalStacking = rentalStacking;
    }

    public Integer getBackStacking() {
        return backStacking;
    }

    public void setBackStacking(Integer backStacking) {
        this.backStacking = backStacking;
    }

    public Long getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(Long equipmentType) {
        this.equipmentType = equipmentType;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }

    public BigDecimal getTalkMoney() {
        return talkMoney;
    }

    public void setTalkMoney(BigDecimal talkMoney) {
        this.talkMoney = talkMoney;
    }

    public Integer getAbolishType() {
        return abolishType;
    }

    public void setAbolishType(Integer abolishType) {
        this.abolishType = abolishType;
    }

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public List<SubDetailEntity> getSubDetailList() {
        return subDetailList;
    }

    public void setSubDetailList(List<SubDetailEntity> subDetailList) {
        this.subDetailList = subDetailList;
    }

    public List<PurchaseDetailEntity> getPurchaseDetailList() {
        return purchaseDetailList;
    }

    public void setPurchaseDetailList(List<PurchaseDetailEntity> purchaseDetailList) {
        this.purchaseDetailList = purchaseDetailList;
    }

    public List<RmatDetailEntity> getRmatDetailList() {
        return rmatDetailList;
    }

    public void setRmatDetailList(List<RmatDetailEntity> rmatDetailList) {
        this.rmatDetailList = rmatDetailList;
    }

    public List<OtherDetailEntity> getOtherDetailList() {
        return otherDetailList;
    }

    public void setOtherDetailList(List<OtherDetailEntity> otherDetailList) {
        this.otherDetailList = otherDetailList;
    }

    /**
     * 系统标识
     */
    public java.lang.String getSourceType() {
        return sourceType;
    }

    /**
     * 系统标识
     */
    public void setSourceType(java.lang.String sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 系统标识
     */
    public java.lang.String getSourceId() {
        return sourceId;
    }

    /**
     * 系统标识
     */
    public void setSourceId(java.lang.String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 发布项目ID
     */
    public java.lang.String getSourceProjectId() {
        return sourceProjectId;
    }

    /**
     * 发布项目ID
     */
    public void setSourceProjectId(java.lang.String sourceProjectId) {
        this.sourceProjectId = sourceProjectId;
    }
    /**
     * 发布项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 发布项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 发布项目编号
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 发布项目编号
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 发布组织ID
     */
    public java.lang.String getSourceOrgId() {
        return sourceOrgId;
    }

    /**
     * 发布组织ID
     */
    public void setSourceOrgId(java.lang.String sourceOrgId) {
        this.sourceOrgId = sourceOrgId;
    }
    /**
     * 发布组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 发布组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 招标单位ID
     */
    public java.lang.String getSourceUnitId() {
        return sourceUnitId;
    }

    /**
     * 招标单位ID
     */
    public void setSourceUnitId(java.lang.String sourceUnitId) {
        this.sourceUnitId = sourceUnitId;
    }
    /**
     * 招标单位名称
     */
    public java.lang.String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(java.lang.String unitName) {
        this.unitName = unitName;
    }
    /**
     * 备注
     */
    public java.lang.String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(java.lang.String memo) {
        this.memo = memo;
    }
    /**
     * 类型(1-材料采购招标，2-分包招标,3-设备采购招标，4-设备租赁招标，5-周转材租赁招标，6-其他招标)
     */
    public java.lang.String getType() {
        return type;
    }

    /**
     * 类型(1-材料采购招标，2-分包招标,3-设备采购招标，4-设备租赁招标，5-周转材租赁招标，6-其他招标)
     */
    public void setType(java.lang.String type) {
        this.type = type;
    }
    /**
     * 招标名称
     */
    public java.lang.String getTenderName() {
        return tenderName;
    }

    /**
     * 招标名称
     */
    public void setTenderName(java.lang.String tenderName) {
        this.tenderName = tenderName;
    }
    /**
     * 招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public java.lang.Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(java.lang.Integer tenderType) {
        this.tenderType = tenderType;
    }
    /**
     * 招标联系人
     */
    public java.lang.String getSourceEmployeeId() {
        return sourceEmployeeId;
    }

    /**
     * 招标联系人
     */
    public void setSourceEmployeeId(java.lang.String sourceEmployeeId) {
        this.sourceEmployeeId = sourceEmployeeId;
    }
    /**
     * 招标联系人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public java.lang.String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(java.lang.String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public java.lang.Integer getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public void setPurchaseType(java.lang.Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 项目联系人
     */
    public java.lang.String getProjectLinkName() {
        return projectLinkName;
    }

    /**
     * 项目联系人
     */
    public void setProjectLinkName(java.lang.String projectLinkName) {
        this.projectLinkName = projectLinkName;
    }
    /**
     * 项目联系人电话
     */
    public java.lang.String getProjectLinkPhone() {
        return projectLinkPhone;
    }

    /**
     * 项目联系人电话
     */
    public void setProjectLinkPhone(java.lang.String projectLinkPhone) {
        this.projectLinkPhone = projectLinkPhone;
    }
    /**
     * 报名开始时间
     */
    public java.util.Date getNoticeStartTime() {
        return noticeStartTime;
    }

    /**
     * 报名开始时间
     */
    public void setNoticeStartTime(java.util.Date noticeStartTime) {
        this.noticeStartTime = noticeStartTime;
    }
    /**
     * 报名截止时间
     */
    public java.util.Date getNoticeEndTime() {
        return noticeEndTime;
    }

    /**
     * 报名截止时间
     */
    public void setNoticeEndTime(java.util.Date noticeEndTime) {
        this.noticeEndTime = noticeEndTime;
    }
    /**
     * 报价开始时间
     */
    public java.util.Date getOfferStartTime() {
        return offerStartTime;
    }

    /**
     * 报价开始时间
     */
    public void setOfferStartTime(java.util.Date offerStartTime) {
        this.offerStartTime = offerStartTime;
    }
    /**
     * 报价结束时间
     */
    public java.util.Date getOfferEndTime() {
        return offerEndTime;
    }

    /**
     * 报价结束时间
     */
    public void setOfferEndTime(java.util.Date offerEndTime) {
        this.offerEndTime = offerEndTime;
    }
    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public java.lang.Integer getBrandFlag() {
        return brandFlag;
    }

    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public void setBrandFlag(java.lang.Integer brandFlag) {
        this.brandFlag = brandFlag;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public java.lang.Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(java.lang.Integer valueType) {
        this.valueType = valueType;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getMaterialContent() {
        return materialContent;
    }

    public void setMaterialContent(String materialContent) {
        this.materialContent = materialContent;
    }

    public List<DetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<SignEntity> getSignList() {
        return signList;
    }

    public void setSignList(List<SignEntity> signList) {
        this.signList = signList;
    }

    public Long getSubType() {
        return subType;
    }

    public void setSubType(Long subType) {
        this.subType = subType;
    }

    public String getProjectQualification() {
        return projectQualification;
    }

    public void setProjectQualification(String projectQualification) {
        this.projectQualification = projectQualification;
    }

    public String getPaymentId() {
        return paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public String getPaymentName() {
        return paymentName;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public Integer getRentType() {
        return rentType;
    }

    public void setRentType(Integer rentType) {
        this.rentType = rentType;
    }

    public List<RentDetailEntity> getRentDetailList() {
        return rentDetailList;
    }

    public void setRentDetailList(List<RentDetailEntity> rentDetailList) {
        this.rentDetailList = rentDetailList;
    }
}
