package com.ejianc.business.supbid.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbid.material.bean.SchemeDetailEntity;
import com.ejianc.business.supbid.material.bean.SchemeEntity;
import com.ejianc.business.supbid.material.bean.SchemeRecordEntity;
import com.ejianc.business.supbid.material.service.ISchemeDetailService;
import com.ejianc.business.supbid.material.service.ISchemeRecordService;
import com.ejianc.business.supbid.material.service.ISchemeService;
import com.ejianc.business.supbid.material.vo.SchemeDetailVO;
import com.ejianc.business.supbid.material.vo.SchemeVO;
import com.ejianc.business.supbid.notice.bean.ContentEntity;
import com.ejianc.business.supbid.notice.bean.FilecontentEntity;
import com.ejianc.business.supbid.notice.bean.NoticeEntity;
import com.ejianc.business.supbid.notice.bean.SignEntity;
import com.ejianc.business.supbid.notice.mapper.NoticeMapper;
import com.ejianc.business.supbid.notice.service.IContentService;
import com.ejianc.business.supbid.notice.service.IFilecontentService;
import com.ejianc.business.supbid.notice.service.INoticeService;
import com.ejianc.business.supbid.notice.service.ISignService;
import com.ejianc.business.supbid.notice.vo.*;
import com.ejianc.business.supbid.other.bean.OtherSchemeDetailEntity;
import com.ejianc.business.supbid.other.bean.OtherSchemeEntity;
import com.ejianc.business.supbid.other.bean.OtherSchemeRecordEntity;
import com.ejianc.business.supbid.other.service.IOtherSchemeDetailService;
import com.ejianc.business.supbid.other.service.IOtherSchemeRecordService;
import com.ejianc.business.supbid.other.service.IOtherSchemeService;
import com.ejianc.business.supbid.other.vo.OtherSchemeDetailVO;
import com.ejianc.business.supbid.other.vo.OtherSchemeVO;
import com.ejianc.business.supbid.purchase.bean.PurchaseSchemeDetailEntity;
import com.ejianc.business.supbid.purchase.bean.PurchaseSchemeEntity;
import com.ejianc.business.supbid.purchase.bean.PurchaseSchemeRecordEntity;
import com.ejianc.business.supbid.purchase.service.IPurchaseSchemeDetailService;
import com.ejianc.business.supbid.purchase.service.IPurchaseSchemeRecordService;
import com.ejianc.business.supbid.purchase.service.IPurchaseSchemeService;
import com.ejianc.business.supbid.purchase.vo.PurchaseSchemeDetailVO;
import com.ejianc.business.supbid.purchase.vo.PurchaseSchemeVO;
import com.ejianc.business.supbid.rent.bean.RentSchemeDetailEntity;
import com.ejianc.business.supbid.rent.bean.RentSchemeEntity;
import com.ejianc.business.supbid.rent.bean.RentSchemeRecordEntity;
import com.ejianc.business.supbid.rent.service.IRentSchemeDetailService;
import com.ejianc.business.supbid.rent.service.IRentSchemeRecordService;
import com.ejianc.business.supbid.rent.service.IRentSchemeService;
import com.ejianc.business.supbid.rent.vo.RentSchemeDetailVO;
import com.ejianc.business.supbid.rent.vo.RentSchemeVO;
import com.ejianc.business.supbid.rmat.bean.*;
import com.ejianc.business.supbid.rmat.service.*;
import com.ejianc.business.supbid.rmat.vo.RmatSchemeDetailVO;
import com.ejianc.business.supbid.rmat.vo.RmatSchemeRepairVO;
import com.ejianc.business.supbid.rmat.vo.RmatSchemeScrapVO;
import com.ejianc.business.supbid.rmat.vo.RmatSchemeVO;
import com.ejianc.business.supbid.sub.bean.SubSchemeDetailEntity;
import com.ejianc.business.supbid.sub.bean.SubSchemeEntity;
import com.ejianc.business.supbid.sub.bean.SubSchemeRecordEntity;
import com.ejianc.business.supbid.sub.service.ISubSchemeDetailService;
import com.ejianc.business.supbid.sub.service.ISubSchemeRecordService;
import com.ejianc.business.supbid.sub.service.ISubSchemeService;
import com.ejianc.business.supbid.sub.vo.SubDetailVO;
import com.ejianc.business.supbid.sub.vo.SubSchemeDetailVO;
import com.ejianc.business.supbid.sub.vo.SubSchemeVO;
import com.ejianc.business.supbid.util.CommonUtils;
import com.ejianc.business.supbid.util.DateUtils;
import com.ejianc.business.supbid.util.SendMsgUtils;
import com.ejianc.business.supbid.util.SupbidFileUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.tenant.api.IidmWebEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 公告实体
 *
 * @author generator
 *
 */
@Service("noticeService")
public class NoticeServiceImpl extends BaseServiceImpl<NoticeMapper, NoticeEntity> implements INoticeService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_TYPE = "BT211123000000003";

    /** 招标门户中查询条件：发布时间 */
    private static final String QUERY_HOME_PUBLISH_TIME = "publishTime";
    /** 招标门户中查询条件：报名/报价倒计时是否结束 0-展示全部，1-倒计时未结束，2-倒计时已结束 */
    private static final String QUERY_HOME_OVER_FLAG = "overFlag";


    @Autowired
    private CacheManager cacheManager;

    @Value("${gcyUrl.signUpUrl}")
    private String signUpUrl;

    // 材料
    @Value("${gcyUrl.pushSellUrl}")
    private String pushSellUrl;
    // 分包
    @Value("${gcyUrl.subPushSellUrl}")
    private String subPushSellUrl;
    // 设备
    @Value("${gcyUrl.purchasePushSellUrl}")
    private String purchasePushSellUrl;
    // 设备租赁
    @Value("${gcyUrl.rentPushSellUrl}")
    private String rentPushSellUrl;
    // 周转材租赁
    @Value("${gcyUrl.rmatPushSellUrl}")
    private String rmatPushSellUrl;
    // 其他
    @Value("${gcyUrl.otherPushSellUrl}")
    private String otherPushSellUrl;


    @Value("${gcyUrl.tokenUrl}")
    private String tokenUrl;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    /** 公开招标消息发送模板 */
    @Value("${weixinMsg.tenderOpen}")
    private String WEIXIN_TENDER_MSG_OPEN;
    /** 邀请招标消息发送模板 */
    @Value("${weixinMsg.tenderInvitation}")
    private String WEIXIN_TENDER_MSG_INVITATION;

    @Autowired
    private IContentService contentService;

    @Autowired
    private INoticeService service;

    @Autowired
    private IFilecontentService filecontentService;

    @Autowired
    private ISchemeService schemeService;
    /** 分包方案 */
    @Autowired
    private ISubSchemeService subSchemeService;
    /** 设备采购方案 */
    @Autowired
    private IPurchaseSchemeService purchaseSchemeService;
    /** 设备租赁方案 */
    @Autowired
    private IRentSchemeService rentSchemeService;
    /** 周转材租赁方案 */
    @Autowired
    private IRmatSchemeService rmatSchemeService;

    @Autowired
    private IRmatSchemeRepairRecordService rmatSchemeRepairRecordService;

    @Autowired
    private IRmatSchemeScrapRecordService rmatSchemeScrapRecordService;

    /** 其他方案 */
    @Autowired
    private IOtherSchemeService otherSchemeService;

    @Autowired
    private ISchemeRecordService schemeRecordService;
    /** 分包方案记录 */
    @Autowired
    private ISubSchemeRecordService subSchemeRecordService;
    /** 设备采购方案记录 */
    @Autowired
    private IPurchaseSchemeRecordService purchaseSchemeRecordService;
    /** 设备租赁方案记录 */
    @Autowired
    private IRentSchemeRecordService rentSchemeRecordService;
    /** 周转材租赁方案记录 */
    @Autowired
    private IRmatSchemeRecordService rmatSchemeRecordService;

    @Autowired
    private IRmatSchemeRepairService rmatSchemeRepairService;

    @Autowired
    private IRmatSchemeScrapService rmatSchemeScrapService;

    /** 其他方案记录 */
    @Autowired
    private IOtherSchemeRecordService otherSchemeRecordService;

    @Autowired
    private ISchemeDetailService schemeDetailService;
    /** 分包方案 */
    @Autowired
    private ISubSchemeDetailService subSchemeDetailService;
    /** 设备采购方案 */
    @Autowired
    private IPurchaseSchemeDetailService purchaseSchemeDetailService;
    /** 设备租赁方案 */
    @Autowired
    private IRentSchemeDetailService rentSchemeDetailService;
    /** 周转材租赁方案 */
    @Autowired
    private IRmatSchemeDetailService rmatSchemeDetailService;
    /** 其他方案 */
    @Autowired
    private IOtherSchemeDetailService otherSchemeDetailService;

    @Autowired
    private ISignService signService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IidmWebEnterpriseApi idmWebEnterpriseApi;

    /**
     * 采购方式：1-单位采购
     */
    private static final Integer PURCHASE_TYPE_1 = 1;


    @Override
    public CommonResponse<Boolean> saveWj(HttpServletRequest request, MultipartFile file) {
        logger.info("进入接口--");
        logger.info("request--" + request);
        String notice = request.getParameter("noticeEntity");
        logger.info("实体信息--" + notice);
        NoticeVO saveorUpdateVO = JSON.parseObject(notice, new TypeReference<NoticeVO>() {
        });
        boolean flag = false;
        saveorUpdateVO.setAbolishType(0);
        saveorUpdateVO.setMaterialContent(saveorUpdateVO.getPurchaseName()); // 供货内容
        saveorUpdateVO.setMaterialId(saveorUpdateVO.getPurchaseId()); // 供货内容id
        if(1==saveorUpdateVO.getNoticeType()) {//文件
            if(null!=saveorUpdateVO.getTalkNum()&&saveorUpdateVO.getTalkNum()>0){
                logger.info("进入二次报价逻辑--" + notice);
                // 二次报价  需将原报价信息 复制到历史表， 并清空当前子表信息 重新报价
                //1.处理主表
                NoticeEntity noticeEntity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId()));
//                NoticeVO dbVo = queryFileDetail(noticeEntity.getId());
//                noticeEntity.setTenderName(null);
                noticeEntity.setOfferStartTime(null);
                noticeEntity.setOfferEndTime(null);
                noticeEntity.setTalkNum(saveorUpdateVO.getTalkNum());
                //todo 发布二次报价  需要将原因放在备注里
                noticeEntity.setMemo(saveorUpdateVO.getMemo());
                flag = super.saveOrUpdate(noticeEntity, false);
               //需将状态改为已报名的数据改为  待报价

                List<ApplyVO> applyVOList = saveorUpdateVO.getApplyList();
                if (CollectionUtils.isNotEmpty(applyVOList)) {
                    LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(SignEntity::getSourceId, saveorUpdateVO.getSourceId());
                    updateWrapper.notIn(SignEntity::getSourceSupplierId, applyVOList.stream().map(ApplyVO::getSourceSupplierId).collect(Collectors.toList()));//本次有效的供应商
                    updateWrapper.set(SignEntity::getSignStatus,5);//全部变成已淘汰
                    updateWrapper.set(SignEntity::getOutReason,"未中标");
                    signService.update(updateWrapper);

                    LambdaUpdateWrapper<SignEntity> updateWrapper2 = new LambdaUpdateWrapper<>();
                    updateWrapper2.eq(SignEntity::getSourceId, saveorUpdateVO.getSourceId());
                    updateWrapper2.in(SignEntity::getSourceSupplierId, applyVOList.stream().map(ApplyVO::getSourceSupplierId).collect(Collectors.toList()));//本次有效的供应商
                    updateWrapper2.set(SignEntity::getSignStatus, 1);//待报价
                    signService.update(updateWrapper2);
                }

                // 材料招标
                if (CommonUtils.TYPE_MATERIAL.equals(noticeEntity.getType())) {
                    this.updateFileMaterial(noticeEntity);
                }
                // 分包招标
                else if (CommonUtils.TYPE_SUB.equals(noticeEntity.getType())) {
                    this.updateFileSub(noticeEntity);
                }
                // 设备采购
                else if (CommonUtils.TYPE_PURCHASE.equals(noticeEntity.getType())) {
                    this.updateFilePurchase(noticeEntity);
                }
                // 设备租赁
                else if (CommonUtils.TYPE_RENT.equals(noticeEntity.getType())) {
                    this.updateFileRent(noticeEntity);
                }
                // 周转材租赁
                else if (CommonUtils.TYPE_RMAT.equals(noticeEntity.getType())) {
                    this.updateFileRmat(noticeEntity);
                }
                // 其他
                else if (CommonUtils.TYPE_OTHER.equals(noticeEntity.getType())) {
                    this.updateFileOther(noticeEntity);
                }

            }else{
                NoticeEntity noticeEntity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId()));
                noticeEntity.setProjectLinkName(saveorUpdateVO.getProjectLinkName());
                noticeEntity.setProjectLinkPhone(saveorUpdateVO.getProjectLinkPhone());
                noticeEntity.setOfferStartTime(saveorUpdateVO.getOfferStartTime());
                noticeEntity.setOfferEndTime(saveorUpdateVO.getOfferEndTime());
                noticeEntity.setBrandFlag(saveorUpdateVO.getBrandFlag());
                noticeEntity.setMemo(saveorUpdateVO.getMemo());
                noticeEntity.setSystemId(saveorUpdateVO.getSystemId());
                flag = super.saveOrUpdate(noticeEntity, false);
                if (StringUtils.isNotEmpty(saveorUpdateVO.getContent())) {
                    FilecontentEntity contentEntity = new FilecontentEntity();
                    contentEntity.setNoticeId(noticeEntity.getId());
                    contentEntity.setContent(saveorUpdateVO.getContent());
                    filecontentService.save(contentEntity);
                }
                //需将状态改为已报名的数据改为  待报价
                LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(SignEntity::getSourceId, saveorUpdateVO.getSourceId());
                updateWrapper.eq(SignEntity::getSignStatus, 0);//查询已报名
                updateWrapper.set(SignEntity::getSignStatus, 1);//待报价
                signService.update(updateWrapper);
                if (null != file) {
                    logger.info(request + "文件模板--" + file.getOriginalFilename());
                    AttachmentVO upFlag = SupbidFileUtils.upFile("templateFiles", Long.toString(noticeEntity.getId()), BILL_TYPE, file, request,BASE_HOST,logger);
                    logger.info(request + "文件上传结果--" + upFlag);
                }
            }
        }else if(2==saveorUpdateVO.getNoticeType()){
            //询价
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }
            if (null != file) {
                logger.info(request + "文件模板--" + file.getOriginalFilename());
                AttachmentVO upFlag = SupbidFileUtils.upFile("templateFiles", Long.toString(entity.getId()), BILL_TYPE, file, request,BASE_HOST,logger);
                logger.info(request + "文件上传结果--" + upFlag);
            }
        }else if(3==saveorUpdateVO.getNoticeType()){
            //  竞争性/单一来源/紧急性   默认均为邀请供应商
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }

            List<SignEntity> signEntities = new ArrayList<>();
            List<ApplyVO> applyVOList = saveorUpdateVO.getApplyList();
            if(CollectionUtils.isNotEmpty(applyVOList)){
                applyVOList.forEach(e->{
                    SignEntity signEntity = new SignEntity();
                    signEntity.setSourceId(saveorUpdateVO.getSourceId());
                    signEntity.setNoticeId(entity.getId());
                    signEntity.setSignStatus(1);//待报价
                    signEntity.setSourceSupplierId(e.getSourceSupplierId());
                    signEntity.setTenantId(e.getTenantId());
                    signEntities.add(signEntity);
                });
                signService.saveOrUpdateBatch(signEntities);
            }
            if (null != file) {
                logger.info(request + "文件模板--" + file.getOriginalFilename());
                AttachmentVO upFlag = SupbidFileUtils.upFile("templateFiles", Long.toString(entity.getId()), BILL_TYPE, file, request,BASE_HOST,logger);
                logger.info(request + "文件上传结果--" + upFlag);
            }
        }
        return CommonResponse.success("保存或修改单据成功！",flag);

    }

    @Override
    public CommonResponse<Boolean> addFile(HttpServletRequest request, MultipartFile file) {
        AttachmentVO upFlag = null;
        if (null != file) {
            String sourceId = request.getParameter("sourceId");
            NoticeEntity noticeEntity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId,sourceId));
            logger.info(request + "文件模板--" + file.getOriginalFilename()+"---surceId:"+sourceId+"----noticeId"+noticeEntity.getId());
            upFlag = SupbidFileUtils.upFile("noticeFiles",Long.toString(noticeEntity.getId()), BILL_TYPE, file, request,BASE_HOST,logger);
            logger.info(request + "文件上传结果--" + upFlag);
        }
        return CommonResponse.success("上传成功！", upFlag != null);
    }

    @Override
    public CommonResponse<String> delFile(String sourceId, List<String> fileNames) {
        NoticeEntity noticeEntity = super
                .getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId, sourceId));
        attachmentApi.deleteFileByParams(Long.valueOf(noticeEntity.getId()), BILL_TYPE, "noticeFiles", fileNames);
        return attachmentApi.delete(sourceId);
    }

    /**
     * 接收公告接口
     *
     * @param saveorUpdateVO 公告信息
     * @return 接收结果
     */
    @Override
    public CommonResponse<Boolean> save(NoticeVO saveorUpdateVO) {
        boolean flag = false;
        saveorUpdateVO.setAbolishType(0);
        logger.info("接收到推送数据：{}", JSONObject.toJSONString(saveorUpdateVO));
        saveorUpdateVO.setMaterialContent(saveorUpdateVO.getPurchaseName()); // 供货内容
        saveorUpdateVO.setMaterialId(saveorUpdateVO.getPurchaseId()); // 供货内容id
        if (0 == saveorUpdateVO.getNoticeType()) {//公告
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if (StringUtils.isNotEmpty(saveorUpdateVO.getNoticeContent())) {
                ContentEntity contentEntity = new ContentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setNoticeContent(saveorUpdateVO.getNoticeContent());
                contentService.save(contentEntity);
            }
            if (1 == saveorUpdateVO.getTenderType()) {
                //邀请招标  需要生成报名表，状态为待报名
                List<SignEntity> signEntities = new ArrayList<>();
                List<ApplyVO> applyVOList = saveorUpdateVO.getApplyList();
                if (CollectionUtils.isNotEmpty(applyVOList)) {
                    applyVOList.forEach(e -> {
                        SignEntity signEntity = new SignEntity();
                        signEntity.setSourceId(saveorUpdateVO.getSourceId());
                        signEntity.setNoticeId(entity.getId());
                        signEntity.setSignStatus(9);//待报名
                        signEntity.setSourceSupplierId(e.getSourceSupplierId());
                        signEntity.setTenantId(e.getTenantId());
                        signEntities.add(signEntity);
                    });
                    signService.saveOrUpdateBatch(signEntities);
                    // 2022-09-06修改，邀请供应商需要发送微信消息
                    List<Long> tenantIdList = applyVOList.stream().map(ApplyVO::getTenantId)
                            .collect(Collectors.toList());
                    CommonResponse<Map<Long, List<Long>>> comRes = cooperateEnterpriseApi
                            .getSuperUserIdBySupplierTenantId(tenantIdList);
                    logger.info("公告sourceId{}查询邀请供应商信息结果：{}", saveorUpdateVO.getSourceId(), JSONObject
                            .toJSONString(comRes));
                    // 只有查询成功才发消息，查询失败不作处理
                    if (comRes.isSuccess()) {
                        try {
                            this.sendWeChatMsgByMap(comRes.getData(), 2, WEIXIN_TENDER_MSG_INVITATION, null, entity, null);
                        }
                        catch (Exception e) {
                            logger.info("消息发送失败！失败原因：{}", e.getMessage(), e);
                        }
                    }
                }
            }
        }else if(1==saveorUpdateVO.getNoticeType()){//文件
            NoticeEntity noticeEntity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery().eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId()));
            noticeEntity.setProjectLinkName(saveorUpdateVO.getProjectLinkName());
            noticeEntity.setProjectLinkPhone(saveorUpdateVO.getProjectLinkPhone());
            noticeEntity.setOfferStartTime(saveorUpdateVO.getOfferStartTime());
            noticeEntity.setOfferEndTime(saveorUpdateVO.getOfferEndTime());
            noticeEntity.setBrandFlag(saveorUpdateVO.getBrandFlag());
            noticeEntity.setMemo(saveorUpdateVO.getMemo());
            noticeEntity.setSystemId(saveorUpdateVO.getSystemId());
            flag = super.saveOrUpdate(noticeEntity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(noticeEntity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }
            //需将状态改为已报名的数据改为  待报价
            LambdaUpdateWrapper<SignEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SignEntity::getSourceId,saveorUpdateVO.getSourceId());
            updateWrapper.eq(SignEntity::getSignStatus,0);//查询已报名
            updateWrapper.set(SignEntity::getSignStatus,1);//待报价
            signService.update(updateWrapper);
        }else if(2==saveorUpdateVO.getNoticeType()){
            //询价
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }
        }else if(3==saveorUpdateVO.getNoticeType()){
            //  竞争性/单一来源/紧急性   默认均为邀请供应商
            NoticeEntity entity = BeanMapper.map(saveorUpdateVO, NoticeEntity.class);
            flag = super.saveOrUpdate(entity, false);
            if(StringUtils.isNotEmpty(saveorUpdateVO.getContent())){
                FilecontentEntity contentEntity = new FilecontentEntity();
                contentEntity.setNoticeId(entity.getId());
                contentEntity.setContent(saveorUpdateVO.getContent());
                filecontentService.save(contentEntity);
            }

            List<SignEntity> signEntities = new ArrayList<>();
            List<ApplyVO> applyVOList = saveorUpdateVO.getApplyList();
            if(CollectionUtils.isNotEmpty(applyVOList)){
                applyVOList.forEach(e->{
                    SignEntity signEntity = new SignEntity();
                    signEntity.setSourceId(saveorUpdateVO.getSourceId());
                    signEntity.setNoticeId(entity.getId());
                    signEntity.setSignStatus(1);//待报价
                    signEntity.setSourceSupplierId(e.getSourceSupplierId());
                    signEntity.setTenantId(e.getTenantId());
                    signEntities.add(signEntity);
                });
                signService.saveOrUpdateBatch(signEntities);
            }
        }else if(4==saveorUpdateVO.getNoticeType()){
            //  洽商谈判 主表更新字段
            NoticeEntity entity = super.getOne(Wrappers.<NoticeEntity>lambdaQuery()
                    .eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId()));
            //如果是第一轮   需根据sourceId与传来的tenantId将子表复制到历史记录表
            if (null != saveorUpdateVO.getTalkNum() && 1 == saveorUpdateVO.getTalkNum()) {
                // 材料招标
                if (CommonUtils.TYPE_MATERIAL.equals(entity.getType())) {
                    this.saveMaterial(saveorUpdateVO);
                }
                // 分包招标
                else if (CommonUtils.TYPE_SUB.equals(entity.getType())) {
                    this.saveSub(saveorUpdateVO);
                }
                // 设备采购
                else if (CommonUtils.TYPE_PURCHASE.equals(entity.getType())) {
                    this.savePurchase(saveorUpdateVO);
                }
                // 设备租赁
                else if (CommonUtils.TYPE_RENT.equals(entity.getType())) {
                    this.saveRent(saveorUpdateVO);
                }
                // 周转材租赁
                else if (CommonUtils.TYPE_RMAT.equals(entity.getType())) {
                    this.saveRmat(saveorUpdateVO);
                }
                // 其他
                else if (CommonUtils.TYPE_OTHER.equals(entity.getType())) {
                    this.saveOther(saveorUpdateVO);
                }
                else {
                    logger.error("招标类型不存在[{}]", entity.getType());
                    throw new BusinessException("招标类型不存在");
                }
            }
            entity.setTenderName(saveorUpdateVO.getTenderName());
            entity.setOfferStartTime(saveorUpdateVO.getOfferStartTime());
            entity.setOfferEndTime(saveorUpdateVO.getOfferEndTime());
            entity.setTalkMoney(saveorUpdateVO.getTalkMoney());
            entity.setTalkNum(saveorUpdateVO.getTalkNum());
            entity.setMemo(saveorUpdateVO.getMemo());
            flag = super.saveOrUpdate(entity, false);
            //将未淘汰的报名状态改为洽商谈判
            List<SignEntity> signEntities = signService
                    .list(Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getNoticeId, entity.getId())
                            .eq(SignEntity::getSourceId, saveorUpdateVO.getSourceId())
                            .ne(SignEntity::getSignStatus, 5));
            if (CollectionUtils.isNotEmpty(signEntities)) {
                signEntities.forEach(e -> {
                    e.setSignStatus(2);//洽商谈判
                });
                signService.saveOrUpdateBatch(signEntities);
            }
        }
        logger.info("公告接收成功-----sourceId:{}", saveorUpdateVO.getSourceId());
        return CommonResponse.success("保存或修改单据成功！", flag);
    }

    /**
     * 接收公告处理材料招标信息
     *
     * @param saveorUpdateVO 接收到的公告信息
     */
    private void saveMaterial(NoticeVO saveorUpdateVO) {
        List<SchemeEntity> schemeEntityList = schemeService.list((Wrappers.<SchemeEntity>lambdaQuery()
                .eq(SchemeEntity::getSourceId, saveorUpdateVO.getSourceId())));
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                SchemeEntity schemeEntity = schemeService.selectById(e.getId());
                SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity, SchemeRecordEntity.class);
                schemeRecordEntity.setId(null);
                schemeRecordEntity.setTalkNum(0);//首轮
                schemeRecordEntity.getSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                schemeRecordService.saveOrUpdate(schemeRecordEntity, false);
            });
        }
    }

    /**
     * 接收公告处理分包招标信息
     *
     * @param saveorUpdateVO 接收到的公告信息
     */
    private void saveSub(NoticeVO saveorUpdateVO) {
        List<SubSchemeEntity> subSchemeEntityList = subSchemeService.list((Wrappers.<SubSchemeEntity>lambdaQuery()
                .eq(SubSchemeEntity::getSourceId, saveorUpdateVO.getSourceId())));
        if (CollectionUtils.isNotEmpty(subSchemeEntityList)) {
            subSchemeEntityList.forEach(e -> {
                SubSchemeEntity subSchemeEntity = subSchemeService.selectById(e.getId());
                SubSchemeRecordEntity subSchemeRecordEntity = BeanMapper.map(subSchemeEntity, SubSchemeRecordEntity.class);
                subSchemeRecordEntity.setId(null);
                subSchemeRecordEntity.setTalkNum(0);//首轮
                subSchemeRecordEntity.getSubSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                subSchemeRecordService.saveOrUpdate(subSchemeRecordEntity, false);
            });
        }
    }

    /**
     * 接收公告处理设备采购招标信息
     *
     * @param saveorUpdateVO 接收到的公告信息
     */
    private void savePurchase(NoticeVO saveorUpdateVO) {
        List<PurchaseSchemeEntity> purchaseSchemeEntityList = purchaseSchemeService
                .list((Wrappers.<PurchaseSchemeEntity>lambdaQuery()
                        .eq(PurchaseSchemeEntity::getSourceId, saveorUpdateVO.getSourceId())));
        if (CollectionUtils.isNotEmpty(purchaseSchemeEntityList)) {
            purchaseSchemeEntityList.forEach(e -> {
                PurchaseSchemeEntity purchaseSchemeEntity = purchaseSchemeService.selectById(e.getId());
                PurchaseSchemeRecordEntity purchaseSchemeRecordEntity = BeanMapper
                        .map(purchaseSchemeEntity, PurchaseSchemeRecordEntity.class);
                purchaseSchemeRecordEntity.setId(null);
                purchaseSchemeRecordEntity.setTalkNum(0);//首轮
                purchaseSchemeRecordEntity.getPurchaseSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                purchaseSchemeRecordService.saveOrUpdate(purchaseSchemeRecordEntity, false);
            });
        }

    }

    /**
     * 接收公告处理设备租赁招标信息
     *
     * @param saveorUpdateVO 接收到的公告信息
     */
    private void saveRent(NoticeVO saveorUpdateVO) {
        List<RentSchemeEntity> rentSchemeEntityList = rentSchemeService
                .list((Wrappers.<RentSchemeEntity>lambdaQuery()
                        .eq(RentSchemeEntity::getSourceId, saveorUpdateVO.getSourceId())));
        if (CollectionUtils.isNotEmpty(rentSchemeEntityList)) {
            rentSchemeEntityList.forEach(e -> {
                RentSchemeEntity rentSchemeEntity = rentSchemeService.selectById(e.getId());
                RentSchemeRecordEntity rentSchemeRecordEntity = BeanMapper
                        .map(rentSchemeEntity, RentSchemeRecordEntity.class);
                rentSchemeRecordEntity.setId(null);
                rentSchemeRecordEntity.setTalkNum(0);//首轮
                rentSchemeRecordEntity.getRentSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                rentSchemeRecordService.saveOrUpdate(rentSchemeRecordEntity, false);
            });
        }

    }

    /**
     * 接收公告处理周转材租赁招标信息
     *
     * @param saveorUpdateVO 接收到的公告信息
     */
    private void saveRmat(NoticeVO saveorUpdateVO) {
        List<RmatSchemeEntity> rmatSchemeEntityList = rmatSchemeService
                .list((Wrappers.<RmatSchemeEntity>lambdaQuery()
                        .eq(RmatSchemeEntity::getSourceId, saveorUpdateVO.getSourceId())));
        if (CollectionUtils.isNotEmpty(rmatSchemeEntityList)) {
            rmatSchemeEntityList.forEach(e -> {
                RmatSchemeEntity rmatSchemeEntity = rmatSchemeService.selectById(e.getId());
                RmatSchemeRecordEntity rmatSchemeRecordEntity = BeanMapper
                        .map(rmatSchemeEntity, RmatSchemeRecordEntity.class);
                rmatSchemeRecordEntity.setId(null);
                rmatSchemeRecordEntity.setTalkNum(0);//首轮
                rmatSchemeRecordEntity.getRmatSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                rmatSchemeRecordService.saveOrUpdate(rmatSchemeRecordEntity, false);
            });
        }

        //处理维修/报废表数据

        List<RmatSchemeRepairEntity> rmatSchemeRepairList = rmatSchemeRepairService
                .list((Wrappers.<RmatSchemeRepairEntity>lambdaQuery()
                        .eq(RmatSchemeRepairEntity::getSourceId, saveorUpdateVO.getSourceId())));
        List<RmatSchemeRepairRecordEntity> repairRepairRecordEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(rmatSchemeRepairList)){
            rmatSchemeRepairList.forEach(e -> {
                RmatSchemeRepairRecordEntity rmatSchemeRepairRecordEntity = BeanMapper
                        .map(e, RmatSchemeRepairRecordEntity.class);
                rmatSchemeRepairRecordEntity.setId(null);
                rmatSchemeRepairRecordEntity.setTalkNum(0);//首轮
                repairRepairRecordEntityList.add(rmatSchemeRepairRecordEntity);
            });
            rmatSchemeRepairRecordService.saveOrUpdateBatch(repairRepairRecordEntityList);
        }

        List<RmatSchemeScrapEntity> rmatSchemeScrapList = rmatSchemeScrapService
                .list((Wrappers.<RmatSchemeScrapEntity>lambdaQuery()
                        .eq(RmatSchemeScrapEntity::getSourceId, saveorUpdateVO.getSourceId())));
        List<RmatSchemeScrapRecordEntity> repairScrapRecordEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(rmatSchemeScrapList)){
            rmatSchemeScrapList.forEach(e -> {
                RmatSchemeScrapRecordEntity rmatSchemeScrapRecordEntity = BeanMapper
                        .map(e, RmatSchemeScrapRecordEntity.class);
                rmatSchemeScrapRecordEntity.setId(null);
                rmatSchemeScrapRecordEntity.setTalkNum(0);//首轮
                repairScrapRecordEntityList.add(rmatSchemeScrapRecordEntity);
            });
            rmatSchemeScrapRecordService.saveOrUpdateBatch(repairScrapRecordEntityList);
        }

    }

    /**
     * 接收公告处理其他招标信息
     *
     * @param saveorUpdateVO 接收到的公告信息
     */
    private void saveOther(NoticeVO saveorUpdateVO) {
        List<OtherSchemeEntity> otherSchemeEntityList = otherSchemeService
                .list((Wrappers.<OtherSchemeEntity>lambdaQuery()
                        .eq(OtherSchemeEntity::getSourceId, saveorUpdateVO.getSourceId())));
        if (CollectionUtils.isNotEmpty(otherSchemeEntityList)) {
            otherSchemeEntityList.forEach(e -> {
                OtherSchemeEntity otherSchemeEntity = otherSchemeService.selectById(e.getId());
                OtherSchemeRecordEntity otherSchemeRecordEntity = BeanMapper
                        .map(otherSchemeEntity, OtherSchemeRecordEntity.class);
                otherSchemeRecordEntity.setId(null);
                otherSchemeRecordEntity.setTalkNum(0);//首轮
                otherSchemeRecordEntity.getOtherSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                otherSchemeRecordService.saveOrUpdate(otherSchemeRecordEntity, false);
            });
        }

    }


    /**
     * 报价
     *
     * @param saveorUpdateVO 报价信息
     * @return 报价结果
     * @throws Exception 异常信息
     */
    @Override
    public CommonResponse<NoticeVO> saveFile(NoticeVO saveorUpdateVO) throws Exception {
        NoticeVO dbVo = queryFileDetail(saveorUpdateVO.getId());
        if (dbVo.getAbolishType() != 0) {
            String msg = "流标";
            if (dbVo.getAbolishType() == 2) {
                msg = "废标";
            }
            throw new BusinessException("该标已" + msg + "，不可以报价");
        }
        List<SignVO> signVOList = saveorUpdateVO.getSignList();
        NoticeVO resVo = null;
        NoticeEntity noticeEntity = null;
        // 解决多页签重复新增报价问题
        List<SignEntity> querySignList = signService.list(Wrappers.<SignEntity>lambdaQuery()
                .eq(SignEntity::getSourceId, saveorUpdateVO.getSourceId())
                .eq(SignEntity::getNoticeId, saveorUpdateVO.getId())
                .eq(SignEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .eq(SignEntity::getSignStatus, 3));
        // 如果查询到当前用户有已经报价过的数据，则抛出异常
        if (CollectionUtils.isNotEmpty(querySignList) && signVOList.get(0).getsId() == null) {
            throw new BusinessException("您的单据已被其他同事操作，请刷新后重试！");
        }
        // 获取systemId
        String systemId = super.selectById(saveorUpdateVO.getId()).getSystemId();
        // 校验合作供应商
        this.checkCooperateEnterprise(systemId, 1);

        // 材料招标
        if (CommonUtils.TYPE_MATERIAL.equals(dbVo.getType())) {
            this.saveFileMaterial(saveorUpdateVO, dbVo);
        }
        // 分包招标
        else if (CommonUtils.TYPE_SUB.equals(dbVo.getType())) {
            this.saveFileSub(saveorUpdateVO, dbVo);
        }
        // 设备采购
        else if (CommonUtils.TYPE_PURCHASE.equals(dbVo.getType())) {
            this.saveFilePurchase(saveorUpdateVO, dbVo);
        }
        // 设备租赁
        else if (CommonUtils.TYPE_RENT.equals(dbVo.getType())) {
            this.saveFileRent(saveorUpdateVO, dbVo);
        }
        // 周转材租赁
        else if (CommonUtils.TYPE_RMAT.equals(dbVo.getType())) {
            this.saveFileRmat(saveorUpdateVO, dbVo);
        }
        // 其他
        else if (CommonUtils.TYPE_OTHER.equals(dbVo.getType())) {
            this.saveFileOther(saveorUpdateVO, dbVo);
        }
        else {
            logger.error("招标类型不存在[{}]", dbVo.getType());
            throw new BusinessException("招标类型不存在");
        }
        SignEntity signEntity = null;
        if (2 == saveorUpdateVO.getTenderType() && null == signVOList.get(0).getsId()) {
            signEntity = BeanMapper.map(signVOList.get(0), SignEntity.class);
            signEntity.setSourceId(saveorUpdateVO.getSourceId());
            signEntity.setNoticeId(saveorUpdateVO.getId());
            signEntity.setSignStatus(3);//报价中

            // 租户ID和供应商ID对应关系
//            Map<String,String> sourceTenantMap = new HashMap<>();
//            sourceTenantMap.put("1471726626618441730","1406947724700246112");
//            sourceTenantMap.put("1471729176256151553","1406947724700246113");
//            sourceTenantMap.put("1471731643794554881","1406947724700246114");
//            sourceTenantMap.put("1472852233918054402","527888337260777477");
//            sourceTenantMap.put("1473189202070044674","528220972239556690");
//            sourceTenantMap.put("1473189172567310338","528222266413027386");
//            sourceTenantMap.put("1473189113180160002","528222429273657395");
//            sourceTenantMap.put("1473190529172996098","528222690796900362");
//            // 根据租户ID查找供应商ID
//            String sourceSupplierId = sourceTenantMap.get(InvocationInfoProxy.getTenantid().toString());
            CommonResponse<Long> supplierResponse = cooperateEnterpriseApi
                    .getCooperateSupplierIdByTenantIdAndEnterpriseId(InvocationInfoProxy.getTenantid(), systemId);
            if (!supplierResponse.isSuccess()) {
//                return CommonResponse.error("未查询到供应商信息！");
                throw new BusinessException("未查询到供应商信息！");
            }
            String sourceSupplierId = supplierResponse.getData().toString();
//            signEntity.setSourceSupplierId("1212517281");
            signEntity.setSourceSupplierId(sourceSupplierId);
            signEntity.setTenantId(InvocationInfoProxy.getTenantid());
        }else{
            signEntity = signService.selectById(signVOList.get(0).getsId());
            signEntity.setSignEmployeeId(signVOList.get(0).getSignEmployeeId());
            signEntity.setSignEmployeeMobile(signVOList.get(0).getSignEmployeeMobile());
            signEntity.setSignEmployeeName(signVOList.get(0).getSignEmployeeName());
            signEntity.setSchemeId(signVOList.get(0).getSchemeId());
            signEntity.setSchemeName(signVOList.get(0).getSchemeName());
            signEntity.setInvoiceNote(signVOList.get(0).getInvoiceNote());
            signEntity.setSignStatus(3);
            if (CommonUtils.TYPE_SUB.equals(dbVo.getType())){
                signEntity.setMnySubTender(signVOList.get(0).getMnySubTender());
                signEntity.setMnySubTenderName(signVOList.get(0).getMnySubTenderName());
                signEntity.setTaxMnySubTender(signVOList.get(0).getTaxMnySubTender());
                signEntity.setTaxMnySubTenderName(signVOList.get(0).getTaxMnySubTenderName());
                signEntity.setSafePromise(signVOList.get(0).getSafePromise());
                signEntity.setDurationPromise(signVOList.get(0).getDurationPromise());
                signEntity.setOtherPromise(signVOList.get(0).getOtherPromise());
                signEntity.setQualityPromise(signVOList.get(0).getQualityPromise());
                signEntity.setMarginType(signVOList.get(0).getMarginType());
                signEntity.setPriceType(signVOList.get(0).getPriceType());
            }
        }
        signService.saveOrUpdate(signEntity, false);
        // 是否进行报名报价校验，洽商谈判不需要进行校验
        boolean isCheckFlag = true;
        if (null != saveorUpdateVO.getTalkNum() && 0 < saveorUpdateVO.getTalkNum()) {
            isCheckFlag = false;
        }
        // 报名报价校验
        if (isCheckFlag) {
            this.checkSignOrBj(dbVo.getSourceId(), signEntity.getSourceSupplierId(), dbVo.getType(), 1, systemId);
        }

        resVo = queryFileDetail(saveorUpdateVO.getId());
        logger.info("报价查询后返回信息---" + resVo);
        //调用第三方报名接口 推送报价
        BjNoticeVO bjNoticeVO = BeanMapper.map(signEntity, BjNoticeVO.class);
        bjNoticeVO.setSourceSupplierId(signEntity.getSourceSupplierId());
        bjNoticeVO.setSchemeTime(new Date());
        bjNoticeVO.setEmployeeId(signEntity.getSignEmployeeId());
        bjNoticeVO.setEmployeeName(signEntity.getSignEmployeeName());
        bjNoticeVO.setEmployeeMobile(signEntity.getSignEmployeeMobile());
        bjNoticeVO.setSubType(resVo.getSubType());
        bjNoticeVO.setEquipmentType(resVo.getEquipmentType());
        bjNoticeVO.setTenderType(resVo.getTenderType());
        bjNoticeVO.setTalkNum(resVo.getTalkNum()==null?0:resVo.getTalkNum());
        String url;
        // 材料招标
        if (CommonUtils.TYPE_MATERIAL.equals(resVo.getType())) {
            bjNoticeVO.setDetailList(resVo.getDetailList());
            bjNoticeVO.setSchemeList(resVo.getSchemeList());
            url = pushSellUrl;
        }
        // 分包招标
        else if (CommonUtils.TYPE_SUB.equals(resVo.getType())) {
            bjNoticeVO.setSubDetailList(resVo.getSubDetailList());
            bjNoticeVO.setSubSchemeList(resVo.getSubSchemeList());
            url = subPushSellUrl;
        }
        // 设备采购
        else if (CommonUtils.TYPE_PURCHASE.equals(resVo.getType())) {
            bjNoticeVO.setPurchaseDetailList(resVo.getPurchaseDetailList());
            bjNoticeVO.setPurchaseSchemeList(resVo.getPurchaseSchemeList());
            url = purchasePushSellUrl;
        }
        // 设备租赁
        else if (CommonUtils.TYPE_RENT.equals(resVo.getType())) {
            bjNoticeVO.setEquipmentType(resVo.getEquipmentType());
            bjNoticeVO.setRentDetailList(resVo.getRentDetailList());
            bjNoticeVO.setRentSchemeList(resVo.getRentSchemeList());
            url = rentPushSellUrl;
        }
        // 周转材租赁
        else if (CommonUtils.TYPE_RMAT.equals(resVo.getType())) {
            bjNoticeVO.setRmatDetailList(resVo.getRmatDetailList());
            bjNoticeVO.setRmatSchemeList(resVo.getRmatSchemeList());
            bjNoticeVO.setRmatSchemeRepairList(resVo.getRmatSchemeRepairList());
            bjNoticeVO.setRmatSchemeScrapList(resVo.getRmatSchemeScrapList());
            url = rmatPushSellUrl;
        }
        // 其他
        else if (CommonUtils.TYPE_OTHER.equals(resVo.getType())) {
            bjNoticeVO.setOtherDetailList(resVo.getOtherDetailList());
            bjNoticeVO.setOtherSchemeList(resVo.getOtherSchemeList());
            url = otherPushSellUrl;
        }
        else {
            logger.error("招标类型不存在[{}]", resVo.getType());
            throw new BusinessException("招标类型不存在");
        }
//        CommonResponse<JSONObject> response = null;
//        response = new ThirdSystemUtils().sendPostReq(tokenUrl,pushSellUrl, JSON.toJSONString(bjNoticeVO),
//        cacheManager);
//        if(!response.isSuccess()) {
//            throw new BusinessException("调用第三方接口失败!");
//        }
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi
                .queryListBySourceId(signEntity.getId(), "BT211123000000004", "bjFiles", null);
        Long attachId = null;
        String fileName = "";
        InputStream inputStream = null;
        if (listCommonResponse.isSuccess()) {
            List<AttachmentVO> data = listCommonResponse.getData();
            List<SupplyFileVo> filePathList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(data)) {
//                attachId = data.get(0).getId();
//                fileName = data.get(0).getFileName();
//                Response fileResponse = attachmentApi.downloadFileById(attachId);
//                Response.Body body = fileResponse.body();
//                inputStream = body.asInputStream();
                // 20220801 修改，文件传全路径
                for (AttachmentVO attachmentVO : data) {
                    SupplyFileVo supplyFileVo = new SupplyFileVo();
                    supplyFileVo.setFileName(attachmentVO.getFileName());
                    supplyFileVo.setFilePath(BASE_HOST + attachmentVO.getFilePath());
                    supplyFileVo.setFileId(attachmentVO.getId());
                    filePathList.add(supplyFileVo);
                }
            }
            bjNoticeVO.setSupplyFileList(filePathList);
            String bjNotice = JSONObject.toJSONString(bjNoticeVO);
            logger.info("实体信息---" + bjNotice);
            Map<String, String> params = new HashMap<>();
            params.put("bjNoticeVO", bjNotice);
            Map<String, String> headers = new HashMap<>();

            // 公有云--->>>私有云
            // 组装文件参数
            // Map<"file",Map<"文件名称",InputStream>>
            Map<String, Map<String, InputStream>> files = null;
            if (null != inputStream) {
                files = new HashMap<>();
                Map<String, InputStream> fileMap = new HashMap<>();
                fileMap.put(fileName, inputStream);
                files.put("file", fileMap);
            }
            logger.info("-----开始调用私有云----");
            logger.info("参数--->>>url:[{}],systemId:[{}],params:【{}】,files:【{}】", url, systemId, params, files);
            CommonResponse<String> commonResponse = systemDataPushService
                    .exchangeDataAndFilesWithThirdSystem(url, params, systemId, files);
            logger.info("-----调用私有云结束----调用结果：{}", commonResponse.isSuccess());
            // 校验返回结果
            CommonUtils.checkCommonResponse(commonResponse, logger);
//            if (!commonResponse.isSuccess()) {
//                logger.error("推送数据失败！失败原因：{}", commonResponse.getMsg());
//                // 上面已操作过数据库，需要抛出异常进行回滚
//                throw new BusinessException("推送数据失败！");
//            }
//            String s = new ThirdSystemUtils().postFile(tokenUrl, pushSellUrl, params, headers, inputStream,
//            cacheManager,fileName);
        }

        return CommonResponse.success("保存或修改单据成功！", resVo);
    }

    /**
     * 处理材料招标报价信息
     *
     * @param saveorUpdateVO 前端传入的公告报价信息
     * @param dbVo           查询出的公告报价信息
     */
    private void saveFileMaterial(NoticeVO saveorUpdateVO, NoticeVO dbVo) {
        List<SchemeVO> schemeVOList = saveorUpdateVO.getSchemeList();
        if(CollectionUtils.isNotEmpty(schemeVOList)){
            for (SchemeVO schemeVO : schemeVOList) {
                for (SchemeDetailVO detailVO :schemeVO.getSchemeDetailList()) {
                    if (detailVO.getDetailRate() == null) {
                        detailVO.setDetailRate(detailVO.getRate());
                    }
                }
            }
        }
        List<SchemeVO> delList = new ArrayList<>();//删除的数据
        List<SchemeVO> dbList = dbVo.getSchemeList();//数据库里的数据
        if (null != saveorUpdateVO.getTalkNum() && 0 < saveorUpdateVO.getTalkNum()) {
            //说明是洽商谈判保存  这种场景不允许修改保存
            //1,将原子表数据 移到记录表
            // 20220113修改：供方接收招标方发布的洽商谈判时，已经将首轮报价记录，此时记录表需要记录最新（当前轮次）的报价
            if (CollectionUtils.isNotEmpty(schemeVOList)) {
                schemeVOList.forEach(e -> {
//                    SchemeEntity schemeEntity = schemeService.selectById(e.getId());
//                    SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity, SchemeRecordEntity.class);
                    SchemeRecordEntity schemeRecordEntity = BeanMapper.map(e, SchemeRecordEntity.class);
                    schemeRecordEntity.setId(null);
                    schemeRecordEntity.setTalkNum(saveorUpdateVO.getTalkNum());//当前轮次
                    schemeRecordEntity.getSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    schemeRecordService.saveOrUpdate(schemeRecordEntity, false);
                });
            }
            //新增修改的数据
            List<SchemeEntity> schemeEntityList = BeanMapper.mapList(schemeVOList, SchemeEntity.class);
            schemeEntityList.forEach(e -> {
                schemeService.saveOrUpdate(e, false);
            });
        }
        else {
            if (CollectionUtils.isNotEmpty(schemeVOList)) {
                Map<Long, String> map = new HashMap<>();
                schemeVOList.forEach(k -> {
                    if (null != k.getId()) {
                        map.put(k.getId(), k.getSchemeName());
                    }
                });

                if (CollectionUtils.isNotEmpty(dbList)) {
                    dbList.forEach(d -> {
                        if (!map.containsKey(d.getId())) {
                            delList.add(d);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(delList)) {
                    schemeService.removeByIds(delList, false);
                }
                //新增修改的数据
                List<SchemeEntity> schemeEntityList = BeanMapper.mapList(schemeVOList, SchemeEntity.class);
                schemeEntityList.forEach(e -> {
                    schemeService.saveOrUpdate(e, false);
                });
            }
        }
    }

    /**
     * 处理分包招标报价信息
     *
     * @param saveorUpdateVO 前端传入的公告报价信息
     * @param dbVo           查询出的公告报价信息
     */
    private void saveFileSub(NoticeVO saveorUpdateVO, NoticeVO dbVo) {
        List<SubSchemeVO> subSchemeVOList = saveorUpdateVO.getSubSchemeList();
        if(CollectionUtils.isNotEmpty(subSchemeVOList)){
            for (SubSchemeVO schemeVO : subSchemeVOList) {
                for (SubSchemeDetailVO detailVO :schemeVO.getSubSchemeDetailList()) {
                    if (detailVO.getDetailRate() == null) {
                        detailVO.setDetailRate(detailVO.getRate());
                    }
                }
            }
        }
        List<SubSchemeVO> delList = new ArrayList<>();//删除的数据
        List<SubSchemeVO> dbList = dbVo.getSubSchemeList();//数据库里的数据
        if (null != saveorUpdateVO.getTalkNum() && 0 < saveorUpdateVO.getTalkNum()) {
            //说明是洽商谈判保存  这种场景不允许修改保存
            //1,将原子表数据 移到记录表
            // 20220113修改：供方接收标方发布的洽商谈判时，已经将首轮报价记录，此时记录表需要记录最新（当前轮次）的报价
            if (CollectionUtils.isNotEmpty(subSchemeVOList)) {
                subSchemeVOList.forEach(e -> {
//                    SubSchemeEntity subSchemeEntity = subSchemeService.selectById(e.getId());
//                    SubSchemeRecordEntity subSchemeRecordEntity = BeanMapper
//                            .map(subSchemeEntity, SubSchemeRecordEntity.class);
                    SubSchemeRecordEntity subSchemeRecordEntity = BeanMapper.map(e, SubSchemeRecordEntity.class);
                    subSchemeRecordEntity.setId(null);
                    subSchemeRecordEntity.setTalkNum(saveorUpdateVO.getTalkNum());//当前轮次
                    subSchemeRecordEntity.getSubSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    subSchemeRecordService.saveOrUpdate(subSchemeRecordEntity, false);
                });
            }
            //新增修改的数据
            List<SubSchemeEntity> subSchemeEntityList = BeanMapper.mapList(subSchemeVOList, SubSchemeEntity.class);
//            subSchemeService.saveOrUpdateBatch(subSchemeEntityList, subSchemeEntityList.size());
            subSchemeEntityList.forEach(e -> {
                subSchemeService.saveOrUpdate(e, false);
            });
        }
        else {
            if (CollectionUtils.isNotEmpty(subSchemeVOList)) {
                Map<Long, String> map = new HashMap<>();
                subSchemeVOList.forEach(k -> {
                    if (null != k.getId()) {
                        map.put(k.getId(), k.getSchemeName());
                    }
                });

                if (CollectionUtils.isNotEmpty(dbList)) {
                    dbList.forEach(d -> {
                        if (!map.containsKey(d.getId())) {
                            delList.add(d);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(delList)) {
                    subSchemeService.removeByIds(delList, false);
                }
                //新增修改的数据
                List<SubSchemeEntity> subSchemeEntityList = BeanMapper.mapList(subSchemeVOList, SubSchemeEntity.class);
//                subSchemeService.saveOrUpdateBatch(subSchemeEntityList, subSchemeEntityList.size());
                subSchemeEntityList.forEach(e -> {
                    subSchemeService.saveOrUpdate(e, false);
                });
            }
        }
    }

    /**
     * 处理设备采购招标报价信息
     *
     * @param saveorUpdateVO 前端传入的公告报价信息
     * @param dbVo           查询出的公告报价信息
     */
    private void saveFilePurchase(NoticeVO saveorUpdateVO, NoticeVO dbVo) {
        List<PurchaseSchemeVO> purchaseSchemeList = saveorUpdateVO.getPurchaseSchemeList();
        if(CollectionUtils.isNotEmpty(purchaseSchemeList)){
            for (PurchaseSchemeVO schemeVO : purchaseSchemeList) {
                for (PurchaseSchemeDetailVO detailVO :schemeVO.getPurchaseSchemeDetailList()) {
                    if (detailVO.getDetailRate() == null) {
                        detailVO.setDetailRate(detailVO.getRate());
                    }
                }
            }
        }

        List<PurchaseSchemeVO> delList = new ArrayList<>();//删除的数据
        List<PurchaseSchemeVO> dbList = dbVo.getPurchaseSchemeList();//数据库里的数据
        if (null != saveorUpdateVO.getTalkNum() && 0 < saveorUpdateVO.getTalkNum()) {
            //说明是洽商谈判保存  这种场景不允许修改保存
            //1,将原子表数据 移到记录表
            // 20220113修改：供方接收招标方发布的洽商谈判时，已经将首轮报价记录，此时记录表需要记录最新（当前轮次）的报价
            if (CollectionUtils.isNotEmpty(purchaseSchemeList)) {
                purchaseSchemeList.forEach(e -> {
//                    SchemeEntity schemeEntity = schemeService.selectById(e.getId());
//                    SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity, SchemeRecordEntity.class);
                    PurchaseSchemeRecordEntity purchaseSchemeRecordEntity = BeanMapper
                            .map(e, PurchaseSchemeRecordEntity.class);

                    purchaseSchemeRecordEntity.setId(null);
                    purchaseSchemeRecordEntity.setTalkNum(saveorUpdateVO.getTalkNum());//当前轮次
                    purchaseSchemeRecordEntity.getPurchaseSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    purchaseSchemeRecordService.saveOrUpdate(purchaseSchemeRecordEntity, false);
                });
            }
            //新增修改的数据
            List<PurchaseSchemeEntity> purchaseSchemeEntityList = BeanMapper
                    .mapList(purchaseSchemeList, PurchaseSchemeEntity.class);
            purchaseSchemeEntityList.forEach(e -> {
                purchaseSchemeService.saveOrUpdate(e, false);
            });
        }
        else {
            if (CollectionUtils.isNotEmpty(purchaseSchemeList)) {
                Map<Long, String> map = new HashMap<>();
                purchaseSchemeList.forEach(k -> {
                    if (null != k.getId()) {
                        map.put(k.getId(), k.getSchemeName());
                    }
                });

                if (CollectionUtils.isNotEmpty(dbList)) {
                    dbList.forEach(d -> {
                        if (!map.containsKey(d.getId())) {
                            delList.add(d);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(delList)) {
                    schemeService.removeByIds(delList, false);
                }
                //新增修改的数据
                List<PurchaseSchemeEntity> purchaseSchemeEntityList = BeanMapper
                        .mapList(purchaseSchemeList, PurchaseSchemeEntity.class);
                purchaseSchemeEntityList.forEach(e -> {
                    purchaseSchemeService.saveOrUpdate(e, false);
                });
            }
        }
    }

    /**
     * 处理设备租赁招标报价信息
     *
     * @param saveorUpdateVO 前端传入的公告报价信息
     * @param dbVo           查询出的公告报价信息
     */
    private void saveFileRent(NoticeVO saveorUpdateVO, NoticeVO dbVo) {
        List<RentSchemeVO> rentSchemeList = saveorUpdateVO.getRentSchemeList();
        if(CollectionUtils.isNotEmpty(rentSchemeList)){
            for (RentSchemeVO schemeVO : rentSchemeList) {
                for (RentSchemeDetailVO detailVO :schemeVO.getRentSchemeDetailList()) {
                    if (detailVO.getDetailRate() == null) {
                        detailVO.setDetailRate(detailVO.getRate());
                    }
                }
            }
        }

        List<RentSchemeVO> delList = new ArrayList<>();//删除的数据
        List<RentSchemeVO> dbList = dbVo.getRentSchemeList();//数据库里的数据
        if (null != saveorUpdateVO.getTalkNum() && 0 < saveorUpdateVO.getTalkNum()) {
            //说明是洽商谈判保存  这种场景不允许修改保存
            //1,将原子表数据 移到记录表
            // 20220113修改：供方接收招标方发布的洽商谈判时，已经将首轮报价记录，此时记录表需要记录最新（当前轮次）的报价
            if (CollectionUtils.isNotEmpty(rentSchemeList)) {
                rentSchemeList.forEach(e -> {
//                    SchemeEntity schemeEntity = schemeService.selectById(e.getId());
//                    SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity, SchemeRecordEntity.class);
                    RentSchemeRecordEntity rentSchemeRecordEntity = BeanMapper
                            .map(e, RentSchemeRecordEntity.class);
                    rentSchemeRecordEntity.setId(null);
                    rentSchemeRecordEntity.setTalkNum(saveorUpdateVO.getTalkNum());//当前轮次
                    rentSchemeRecordEntity.getRentSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    rentSchemeRecordService.saveOrUpdate(rentSchemeRecordEntity, false);
                });
            }
            //新增修改的数据
            List<RentSchemeEntity> rentSchemeEntityList = BeanMapper
                    .mapList(rentSchemeList, RentSchemeEntity.class);
            rentSchemeEntityList.forEach(e -> {
                rentSchemeService.saveOrUpdate(e, false);
            });
        }
        else {
            if (CollectionUtils.isNotEmpty(rentSchemeList)) {
                Map<Long, String> map = new HashMap<>();
                rentSchemeList.forEach(k -> {
                    if (null != k.getId()) {
                        map.put(k.getId(), k.getSchemeName());
                    }
                });

                if (CollectionUtils.isNotEmpty(dbList)) {
                    dbList.forEach(d -> {
                        if (!map.containsKey(d.getId())) {
                            delList.add(d);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(delList)) {
                    schemeService.removeByIds(delList, false);
                }
                //新增修改的数据
                List<RentSchemeEntity> rentSchemeEntityList = BeanMapper
                        .mapList(rentSchemeList, RentSchemeEntity.class);
                rentSchemeEntityList.forEach(e -> {
                    rentSchemeService.saveOrUpdate(e, false);
                });
            }
        }
    }

    /**
     * 处理周转材租赁招标报价信息
     *
     * @param saveorUpdateVO 前端传入的公告报价信息
     * @param dbVo           查询出的公告报价信息
     */
    private void saveFileRmat(NoticeVO saveorUpdateVO, NoticeVO dbVo) {
        List<RmatSchemeVO> rmatSchemeList = saveorUpdateVO.getRmatSchemeList();
        List<RmatSchemeRepairVO> rmatSchemeRepairList = saveorUpdateVO.getRmatSchemeRepairList();
        List<RmatSchemeScrapVO> rmatSchemeScrapList = saveorUpdateVO.getRmatSchemeScrapList();
        if(CollectionUtils.isNotEmpty(rmatSchemeList)){
            for (RmatSchemeVO schemeVO : rmatSchemeList) {
                for (RmatSchemeDetailVO detailVO :schemeVO.getRmatSchemeDetailList()) {
                    if (detailVO.getDetailRate() == null) {
                        detailVO.setDetailRate(detailVO.getRate());
                    }
                }
            }
        }

        List<RmatSchemeVO> delList = new ArrayList<>();//删除的数据
        List<RmatSchemeVO> dbList = dbVo.getRmatSchemeList();//数据库里的数据
        if (null != saveorUpdateVO.getTalkNum() && 0 < saveorUpdateVO.getTalkNum()) {
            //说明是洽商谈判保存  这种场景不允许修改保存
            //1,将原子表数据 移到记录表
            // 20220113修改：供方接收招标方发布的洽商谈判时，已经将首轮报价记录，此时记录表需要记录最新（当前轮次）的报价
            if (CollectionUtils.isNotEmpty(rmatSchemeList)) {
                rmatSchemeList.forEach(e -> {
//                    SchemeEntity schemeEntity = schemeService.selectById(e.getId());
//                    SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity, SchemeRecordEntity.class);
                    RmatSchemeRecordEntity rmatSchemeRecordEntity = BeanMapper
                            .map(e, RmatSchemeRecordEntity.class);
                    rmatSchemeRecordEntity.setId(null);
                    rmatSchemeRecordEntity.setTalkNum(saveorUpdateVO.getTalkNum());//当前轮次
                    rmatSchemeRecordEntity.getRmatSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    rmatSchemeRecordService.saveOrUpdate(rmatSchemeRecordEntity, false);
                });
            }
            //新增修改的数据
            List<RmatSchemeEntity> rmatSchemeEntityList = BeanMapper
                    .mapList(rmatSchemeList, RmatSchemeEntity.class);
            rmatSchemeEntityList.forEach(e -> {
                rmatSchemeService.saveOrUpdate(e, false);
            });


            //处理维修/报废表数据

            if(CollectionUtils.isNotEmpty(rmatSchemeRepairList)){
                rmatSchemeRepairList.forEach(e -> {
                    RmatSchemeRepairRecordEntity rmatSchemeRepairRecordEntity = BeanMapper
                            .map(e, RmatSchemeRepairRecordEntity.class);
                    rmatSchemeRepairRecordEntity.setId(null);
                    rmatSchemeRepairRecordEntity.setTalkNum(saveorUpdateVO.getTalkNum());//当前轮次
                    rmatSchemeRepairRecordService.saveOrUpdate(rmatSchemeRepairRecordEntity,false);
                });
            }


            if(CollectionUtils.isNotEmpty(rmatSchemeScrapList)){
                rmatSchemeScrapList.forEach(e -> {
                    RmatSchemeScrapRecordEntity rmatSchemeScrapRecordEntity = BeanMapper
                            .map(e, RmatSchemeScrapRecordEntity.class);
                    rmatSchemeScrapRecordEntity.setId(null);
                    rmatSchemeScrapRecordEntity.setTalkNum(saveorUpdateVO.getTalkNum());//当前轮次
                    rmatSchemeScrapRecordService.saveOrUpdate(rmatSchemeScrapRecordEntity,false);
                });
            }

        }
        else {
            if (CollectionUtils.isNotEmpty(rmatSchemeList)) {
                Map<Long, String> map = new HashMap<>();
                rmatSchemeList.forEach(k -> {
                    if (null != k.getId()) {
                        map.put(k.getId(), k.getSchemeName());
                    }
                });

                if (CollectionUtils.isNotEmpty(dbList)) {
                    dbList.forEach(d -> {
                        if (!map.containsKey(d.getId())) {
                            delList.add(d);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(delList)) {
                    schemeService.removeByIds(delList, false);
                }
                //新增修改的数据
                List<RmatSchemeEntity> rmatSchemeEntityList = BeanMapper
                        .mapList(rmatSchemeList, RmatSchemeEntity.class);
                rmatSchemeEntityList.forEach(e -> {
                    rmatSchemeService.saveOrUpdate(e, false);
                });
            }
            //处理维修/报废表数据
            if(CollectionUtils.isNotEmpty(rmatSchemeRepairList)){
                List<RmatSchemeRepairEntity> rmatSchemeRepairEntityList = BeanMapper.mapList(rmatSchemeRepairList,RmatSchemeRepairEntity.class);
                rmatSchemeRepairEntityList.forEach(e -> {
                    rmatSchemeRepairService.saveOrUpdate(e, false);
                });
            }

            if(CollectionUtils.isNotEmpty(rmatSchemeScrapList)){
                List<RmatSchemeScrapEntity> rmatSchemeScrapEntityList = BeanMapper.mapList(rmatSchemeScrapList,RmatSchemeScrapEntity.class);
                rmatSchemeScrapEntityList.forEach(e -> {
                    rmatSchemeScrapService.saveOrUpdate(e, false);
                });
            }
        }
    }

    /**
     * 处理其他招标报价信息
     *
     * @param saveorUpdateVO 前端传入的公告报价信息
     * @param dbVo           查询出的公告报价信息
     */
    private void saveFileOther(NoticeVO saveorUpdateVO, NoticeVO dbVo) {
        List<OtherSchemeVO> otherSchemeList = saveorUpdateVO.getOtherSchemeList();
        if(CollectionUtils.isNotEmpty(otherSchemeList)){
            for (OtherSchemeVO schemeVO : otherSchemeList) {
                for (OtherSchemeDetailVO detailVO :schemeVO.getOtherSchemeDetailList()) {
                    if (detailVO.getDetailRate() == null) {
                        detailVO.setDetailRate(detailVO.getRate());
                    }
                }
            }
        }

        List<OtherSchemeVO> delList = new ArrayList<>();//删除的数据
        List<OtherSchemeVO> dbList = dbVo.getOtherSchemeList();//数据库里的数据
        if (null != saveorUpdateVO.getTalkNum() && 0 < saveorUpdateVO.getTalkNum()) {
            //说明是洽商谈判保存  这种场景不允许修改保存
            //1,将原子表数据 移到记录表
            // 20220113修改：供方接收招标方发布的洽商谈判时，已经将首轮报价记录，此时记录表需要记录最新（当前轮次）的报价
            if (CollectionUtils.isNotEmpty(otherSchemeList)) {
                otherSchemeList.forEach(e -> {
//                    SchemeEntity schemeEntity = schemeService.selectById(e.getId());
//                    SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity, SchemeRecordEntity.class);
                    OtherSchemeRecordEntity otherSchemeRecordEntity = BeanMapper
                            .map(e, OtherSchemeRecordEntity.class);
                    otherSchemeRecordEntity.setId(null);
                    otherSchemeRecordEntity.setTalkNum(saveorUpdateVO.getTalkNum());//当前轮次
                    otherSchemeRecordEntity.getOtherSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    otherSchemeRecordService.saveOrUpdate(otherSchemeRecordEntity, false);
                });
            }
            //新增修改的数据
            List<OtherSchemeEntity> otherSchemeEntityList = BeanMapper
                    .mapList(otherSchemeList, OtherSchemeEntity.class);
            otherSchemeEntityList.forEach(e -> {
                otherSchemeService.saveOrUpdate(e, false);
            });
        }
        else {
            if (CollectionUtils.isNotEmpty(otherSchemeList)) {
                Map<Long, String> map = new HashMap<>();
                otherSchemeList.forEach(k -> {
                    if (null != k.getId()) {
                        map.put(k.getId(), k.getSchemeName());
                    }
                });

                if (CollectionUtils.isNotEmpty(dbList)) {
                    dbList.forEach(d -> {
                        if (!map.containsKey(d.getId())) {
                            delList.add(d);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(delList)) {
                    schemeService.removeByIds(delList, false);
                }
                //新增修改的数据
                List<OtherSchemeEntity> otherSchemeEntityList = BeanMapper
                        .mapList(otherSchemeList, OtherSchemeEntity.class);
                otherSchemeEntityList.forEach(e -> {
                    otherSchemeService.saveOrUpdate(e, false);
                });
            }
        }
    }

    /**
     * 处理材料招标报价信息
     *
     * @param
     */
    private void updateFileMaterial(NoticeEntity noticeEntity) {
        List<SchemeEntity> schemeEntityList = schemeService
                .list((Wrappers.<SchemeEntity>lambdaQuery().eq(SchemeEntity::getNoticeId, noticeEntity.getId()))
                        .orderByAsc(SchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                List<SchemeDetailEntity> schemeDetailEntities = null;
                schemeDetailEntities = schemeDetailService.list((Wrappers.<SchemeDetailEntity>lambdaQuery()
                        .eq(SchemeDetailEntity::getSchemeId, e.getId())));
                e.setSchemeDetailList(schemeDetailEntities);
            });
        }
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                //1,删除现有子表数据
//                schemeService.removeById(e.getId());
                //2，复制现有子表到记录表
                SchemeRecordEntity schemeRecordEntity = BeanMapper.map(e, SchemeRecordEntity.class);
                schemeRecordEntity.setId(null);
                schemeRecordEntity.setTalkNum(noticeEntity.getTalkNum()==null?0:noticeEntity.getTalkNum()-1);//当前轮次
                schemeRecordEntity.getSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                schemeRecordService.saveOrUpdate(schemeRecordEntity, false);
            });
        }
    }

    /**
     * 处理报价信息
     *
     */
    private void updateFileSub(NoticeEntity noticeEntity) {
        List<SubSchemeEntity> schemeEntityList = subSchemeService
                .list((Wrappers.<SubSchemeEntity>lambdaQuery().eq(SubSchemeEntity::getNoticeId, noticeEntity.getId()))
                        .orderByAsc(SubSchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                List<SubSchemeDetailEntity> schemeDetailEntities = null;
                schemeDetailEntities = subSchemeDetailService.list((Wrappers.<SubSchemeDetailEntity>lambdaQuery()
                        .eq(SubSchemeDetailEntity::getSchemeId, e.getId())));
                e.setSubSchemeDetailList(schemeDetailEntities);
            });
        }
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                //1,删除现有子表数据
//                subSchemeService.removeById(e.getId());
                //2，复制现有子表到记录表
                SubSchemeRecordEntity schemeRecordEntity = BeanMapper.map(e, SubSchemeRecordEntity.class);
                schemeRecordEntity.setId(null);
                schemeRecordEntity.setTalkNum(noticeEntity.getTalkNum()==null?0:noticeEntity.getTalkNum()-1);//当前轮次
                schemeRecordEntity.getSubSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                subSchemeRecordService.saveOrUpdate(schemeRecordEntity, false);
            });
        }
    }

    /**
     * 处理报价信息
     *
     */
    private void updateFilePurchase(NoticeEntity noticeEntity) {
        List<PurchaseSchemeEntity> schemeEntityList = purchaseSchemeService
                .list((Wrappers.<PurchaseSchemeEntity>lambdaQuery().eq(PurchaseSchemeEntity::getNoticeId, noticeEntity.getId()))
                        .orderByAsc(PurchaseSchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                List<PurchaseSchemeDetailEntity> schemeDetailEntities = null;
                schemeDetailEntities = purchaseSchemeDetailService.list((Wrappers.<PurchaseSchemeDetailEntity>lambdaQuery()
                        .eq(PurchaseSchemeDetailEntity::getSchemeId, e.getId())));
                e.setPurchaseSchemeDetailList(schemeDetailEntities);
            });
        }
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                //1,删除现有子表数据
//                purchaseSchemeService.removeById(e.getId());
                //2，复制现有子表到记录表
                PurchaseSchemeRecordEntity schemeRecordEntity = BeanMapper.map(e, PurchaseSchemeRecordEntity.class);
                schemeRecordEntity.setId(null);
                schemeRecordEntity.setTalkNum(noticeEntity.getTalkNum()==null?0:noticeEntity.getTalkNum()-1);//当前轮次
                schemeRecordEntity.getPurchaseSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                purchaseSchemeRecordService.saveOrUpdate(schemeRecordEntity, false);
            });
        }
    }

    /**
     * 处理报价信息
     *
     */
    private void updateFileRent(NoticeEntity noticeEntity) {
        List<RentSchemeEntity> schemeEntityList = rentSchemeService
                .list((Wrappers.<RentSchemeEntity>lambdaQuery().eq(RentSchemeEntity::getNoticeId, noticeEntity.getId()))
                        .orderByAsc(RentSchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                List<RentSchemeDetailEntity> schemeDetailEntities = null;
                schemeDetailEntities = rentSchemeDetailService.list((Wrappers.<RentSchemeDetailEntity>lambdaQuery()
                        .eq(RentSchemeDetailEntity::getSchemeId, e.getId())));
                e.setRentSchemeDetailList(schemeDetailEntities);
            });
        }
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                //1,删除现有子表数据
//                rentSchemeService.removeById(e.getId());
                //2，复制现有子表到记录表
                RentSchemeRecordEntity schemeRecordEntity = BeanMapper.map(e, RentSchemeRecordEntity.class);
                schemeRecordEntity.setId(null);
                schemeRecordEntity.setTalkNum(noticeEntity.getTalkNum()==null?0:noticeEntity.getTalkNum()-1);//当前轮次
                schemeRecordEntity.getRentSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                rentSchemeRecordService.saveOrUpdate(schemeRecordEntity, false);
            });
        }
    }

    /**
     * 处理报价信息
     *
     */
    private void updateFileRmat(NoticeEntity noticeEntity) {
        List<RmatSchemeEntity> schemeEntityList = rmatSchemeService
                .list((Wrappers.<RmatSchemeEntity>lambdaQuery().eq(RmatSchemeEntity::getNoticeId, noticeEntity.getId()))
                        .orderByAsc(RmatSchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                List<RmatSchemeDetailEntity> schemeDetailEntities = null;
                schemeDetailEntities = rmatSchemeDetailService.list((Wrappers.<RmatSchemeDetailEntity>lambdaQuery()
                        .eq(RmatSchemeDetailEntity::getSchemeId, e.getId())));
                e.setRmatSchemeDetailList(schemeDetailEntities);
            });
        }
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                //1,删除现有子表数据
//                rmatSchemeService.removeById(e.getId());
                //2，复制现有子表到记录表
                RmatSchemeRecordEntity schemeRecordEntity = BeanMapper.map(e, RmatSchemeRecordEntity.class);
                schemeRecordEntity.setId(null);
                schemeRecordEntity.setTalkNum(noticeEntity.getTalkNum()==null?0:noticeEntity.getTalkNum()-1);//当前轮次
                schemeRecordEntity.getRmatSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                rmatSchemeRecordService.saveOrUpdate(schemeRecordEntity, false);
            });
        }

        //处理维修/报废表数据

        List<RmatSchemeRepairEntity> rmatSchemeRepairList = rmatSchemeRepairService
                .list((Wrappers.<RmatSchemeRepairEntity>lambdaQuery()
                        .eq(RmatSchemeRepairEntity::getNoticeId, noticeEntity.getId())));
        List<RmatSchemeRepairRecordEntity> repairRepairRecordEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(rmatSchemeRepairList)){
            rmatSchemeRepairList.forEach(e -> {
                RmatSchemeRepairRecordEntity rmatSchemeRepairRecordEntity = BeanMapper
                        .map(e, RmatSchemeRepairRecordEntity.class);
                rmatSchemeRepairRecordEntity.setId(null);
                rmatSchemeRepairRecordEntity.setTalkNum(noticeEntity.getTalkNum()==null?0:noticeEntity.getTalkNum()-1);
                repairRepairRecordEntityList.add(rmatSchemeRepairRecordEntity);
            });
            rmatSchemeRepairRecordService.saveOrUpdateBatch(repairRepairRecordEntityList);
        }

        List<RmatSchemeScrapEntity> rmatSchemeScrapList = rmatSchemeScrapService
                .list((Wrappers.<RmatSchemeScrapEntity>lambdaQuery()
                        .eq(RmatSchemeScrapEntity::getNoticeId, noticeEntity.getId())));
        List<RmatSchemeScrapRecordEntity> repairScrapRecordEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(rmatSchemeScrapList)){
            rmatSchemeScrapList.forEach(e -> {
                RmatSchemeScrapRecordEntity rmatSchemeScrapRecordEntity = BeanMapper
                        .map(e, RmatSchemeScrapRecordEntity.class);
                rmatSchemeScrapRecordEntity.setId(null);
                rmatSchemeScrapRecordEntity.setTalkNum(noticeEntity.getTalkNum()==null?0:noticeEntity.getTalkNum()-1);
                repairScrapRecordEntityList.add(rmatSchemeScrapRecordEntity);
            });
            rmatSchemeScrapRecordService.saveOrUpdateBatch(repairScrapRecordEntityList);
        }
    }

    /**
     * 处理报价信息
     *
     */
    private void updateFileOther(NoticeEntity noticeEntity) {
        List<OtherSchemeEntity> schemeEntityList = otherSchemeService
                .list((Wrappers.<OtherSchemeEntity>lambdaQuery().eq(OtherSchemeEntity::getNoticeId, noticeEntity.getId()))
                        .orderByAsc(OtherSchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                List<OtherSchemeDetailEntity> schemeDetailEntities = null;
                schemeDetailEntities = otherSchemeDetailService.list((Wrappers.<OtherSchemeDetailEntity>lambdaQuery()
                        .eq(OtherSchemeDetailEntity::getSchemeId, e.getId())));
                e.setOtherSchemeDetailList(schemeDetailEntities);
            });
        }
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                //1,删除现有子表数据
//                otherSchemeService.removeById(e.getId());
                //2，复制现有子表到记录表
                OtherSchemeRecordEntity schemeRecordEntity = BeanMapper.map(e, OtherSchemeRecordEntity.class);
                schemeRecordEntity.setId(null);
                schemeRecordEntity.setTalkNum(noticeEntity.getTalkNum()==null?0:noticeEntity.getTalkNum()-1);//当前轮次
                schemeRecordEntity.getOtherSchemeDetailList().forEach(k -> {
                    k.setId(null);
                    k.setSchemeId(null);
                });
                otherSchemeRecordService.saveOrUpdate(schemeRecordEntity, false);
            });
        }
    }

    @Override
    public CommonResponse<Boolean> updateTime(NoticeVO saveorUpdateVO) {
        LambdaUpdateWrapper<NoticeEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(NoticeEntity::getSourceId, saveorUpdateVO.getSourceId());
        if (null != saveorUpdateVO.getNoticeEndTime()) {
            updateWrapper.set(NoticeEntity::getNoticeEndTime, saveorUpdateVO.getNoticeEndTime());
        }
        if (null != saveorUpdateVO.getOfferEndTime()) {
            updateWrapper.set(NoticeEntity::getOfferEndTime, saveorUpdateVO.getOfferEndTime());
        }
        return CommonResponse.success("修改成功！", service.update(updateWrapper));
    }

    /**
     * 供应商补充报价接口
     *
     * @param vos 补充信息
     * @return 补充结果
     */
    @Override
    public Boolean updateSupOffer(List<SupOfferVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            NoticeEntity noticeEntity = super.getOne((Wrappers.<NoticeEntity>lambdaQuery()
                    .eq(NoticeEntity::getSourceId, vos.get(0).getSourceId())));
            String type = noticeEntity.getType();
            switch (type) {
                case CommonUtils.TYPE_MATERIAL:
                    materialRecord(vos);
                    break;
                case CommonUtils.TYPE_SUB:
                    subRecord(vos);
                    break;
                case CommonUtils.TYPE_PURCHASE:
                    this.purchaseRecord(vos);
                    break;
                case CommonUtils.TYPE_RENT:
                    this.rentRecord(vos);
                    break;
                case CommonUtils.TYPE_RMAT:
                    this.rmatRecord(vos);
                    break;
                case CommonUtils.TYPE_OTHER:
                    this.otherRecord(vos);
                    break;
                default:
                    logger.error("招标类型不存在[{}]", type);
                    throw new BusinessException("招标类型不存在");
            }
        }
        return true;
    }

    /**
     * 材料
     *
     * @param vos vo
     */
    public void materialRecord(List<SupOfferVO> vos) {
        vos.forEach(e -> {
            List<SchemeEntity> schemeEntityList = schemeService
                    .list((Wrappers.<SchemeEntity>lambdaQuery().eq(SchemeEntity::getSourceId, e.getSourceId()))
                            .eq(SchemeEntity::getTenantId, e.getTenantId()));
            if (CollectionUtils.isNotEmpty(schemeEntityList)) {
                schemeEntityList.forEach(i -> {
                    SchemeEntity schemeEntity = schemeService.selectById(i.getId());
                    SchemeRecordEntity schemeRecordEntity = BeanMapper.map(schemeEntity, SchemeRecordEntity.class);
                    schemeRecordEntity.setId(null);
                    schemeRecordEntity.setTalkNum(e.getTalkNum());
                    schemeRecordEntity.getSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    schemeRecordService.saveOrUpdate(schemeRecordEntity, false);
                });
            }
        });
    }

    /**
     * 分包
     *
     * @param vos vo
     */
    public void subRecord(List<SupOfferVO> vos) {
        vos.forEach(e -> {
            List<SubSchemeEntity> schemeEntityList = subSchemeService
                    .list((Wrappers.<SubSchemeEntity>lambdaQuery().eq(SubSchemeEntity::getSourceId, e.getSourceId()))
                            .eq(SubSchemeEntity::getTenantId, e.getTenantId()));
            if (CollectionUtils.isNotEmpty(schemeEntityList)) {
                schemeEntityList.forEach(i -> {
                    SubSchemeEntity schemeEntity = subSchemeService.selectById(i.getId());
                    SubSchemeRecordEntity schemeRecordEntity = BeanMapper
                            .map(schemeEntity, SubSchemeRecordEntity.class);
                    schemeRecordEntity.setId(null);
                    schemeRecordEntity.setTalkNum(e.getTalkNum());
                    schemeRecordEntity.getSubSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    subSchemeRecordService.saveOrUpdate(schemeRecordEntity, false);
                });
            }
        });
    }

    /**
     * 设备采购
     *
     * @param vos vo
     */
    public void purchaseRecord(List<SupOfferVO> vos) {
        vos.forEach(e -> {
            List<PurchaseSchemeEntity> schemeEntityList = purchaseSchemeService
                    .list((Wrappers.<PurchaseSchemeEntity>lambdaQuery()
                            .eq(PurchaseSchemeEntity::getSourceId, e.getSourceId()))
                            .eq(PurchaseSchemeEntity::getTenantId, e.getTenantId()));
            if (CollectionUtils.isNotEmpty(schemeEntityList)) {
                schemeEntityList.forEach(i -> {
                    PurchaseSchemeEntity schemeEntity = purchaseSchemeService.selectById(i.getId());
                    PurchaseSchemeRecordEntity schemeRecordEntity = BeanMapper
                            .map(schemeEntity, PurchaseSchemeRecordEntity.class);
                    schemeRecordEntity.setId(null);
                    schemeRecordEntity.setTalkNum(e.getTalkNum());
                    schemeRecordEntity.getPurchaseSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    purchaseSchemeRecordService.saveOrUpdate(schemeRecordEntity, false);
                });
            }
        });
    }

    /**
     * 设备租赁
     *
     * @param vos vo
     */
    public void rentRecord(List<SupOfferVO> vos) {
        vos.forEach(e -> {
            List<RentSchemeEntity> schemeEntityList = rentSchemeService
                    .list((Wrappers.<RentSchemeEntity>lambdaQuery().eq(RentSchemeEntity::getSourceId, e.getSourceId()))
                            .eq(RentSchemeEntity::getTenantId, e.getTenantId()));
            if (CollectionUtils.isNotEmpty(schemeEntityList)) {
                schemeEntityList.forEach(i -> {
                    RentSchemeEntity schemeEntity = rentSchemeService.selectById(i.getId());
                    RentSchemeRecordEntity schemeRecordEntity = BeanMapper
                            .map(schemeEntity, RentSchemeRecordEntity.class);
                    schemeRecordEntity.setId(null);
                    schemeRecordEntity.setTalkNum(e.getTalkNum());
                    schemeRecordEntity.getRentSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    rentSchemeRecordService.saveOrUpdate(schemeRecordEntity, false);
                });
            }
        });
    }

    /**
     * 周转材租赁
     *
     * @param vos vo
     */
    public void rmatRecord(List<SupOfferVO> vos) {
        vos.forEach(e -> {
            List<RmatSchemeEntity> schemeEntityList = rmatSchemeService
                    .list((Wrappers.<RmatSchemeEntity>lambdaQuery().eq(RmatSchemeEntity::getSourceId, e.getSourceId()))
                            .eq(RmatSchemeEntity::getTenantId, e.getTenantId()));
            if (CollectionUtils.isNotEmpty(schemeEntityList)) {
                schemeEntityList.forEach(i -> {
                    RmatSchemeEntity schemeEntity = rmatSchemeService.selectById(i.getId());
                    RmatSchemeRecordEntity schemeRecordEntity = BeanMapper
                            .map(schemeEntity, RmatSchemeRecordEntity.class);
                    schemeRecordEntity.setId(null);
                    schemeRecordEntity.setTalkNum(e.getTalkNum());
                    schemeRecordEntity.getRmatSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    rmatSchemeRecordService.saveOrUpdate(schemeRecordEntity, false);
                });
            }
        });
    }

    /**
     * 其他
     *
     * @param vos vo
     */
    public void otherRecord(List<SupOfferVO> vos) {
        vos.forEach(e -> {
            List<OtherSchemeEntity> schemeEntityList = otherSchemeService
                    .list((Wrappers.<OtherSchemeEntity>lambdaQuery().eq(OtherSchemeEntity::getSourceId, e.getSourceId()))
                            .eq(OtherSchemeEntity::getTenantId, e.getTenantId()));
            if (CollectionUtils.isNotEmpty(schemeEntityList)) {
                schemeEntityList.forEach(i -> {
                    OtherSchemeEntity schemeEntity = otherSchemeService.selectById(i.getId());
                    OtherSchemeRecordEntity schemeRecordEntity = BeanMapper
                            .map(schemeEntity, OtherSchemeRecordEntity.class);
                    schemeRecordEntity.setId(null);
                    schemeRecordEntity.setTalkNum(e.getTalkNum());
                    schemeRecordEntity.getOtherSchemeDetailList().forEach(k -> {
                        k.setId(null);
                        k.setSchemeId(null);
                    });
                    otherSchemeRecordService.saveOrUpdate(schemeRecordEntity, false);
                });
            }
        });
    }


    @Override
    public NoticeVO queryDetail(Long id) {
        NoticeEntity noticeEntity = super.selectById(id);
        NoticeVO vo = BeanMapper.map(noticeEntity, NoticeVO.class);
        List<SignEntity> signEntities = signService
                .list(Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getNoticeId, id)
                        .eq(SignEntity::getTenantId, InvocationInfoProxy.getTenantid()));
        List<SignVO> signVOList = BeanMapper.mapList(signEntities, SignVO.class);
        List<SignVO> signList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(signEntities)) {
            Long sid = signEntities.get(0).getId();
            signVOList.get(0).setsId(sid);
            signList.add(signVOList.get(0));
        }
        vo.setSignList(signList);
        ContentEntity contentEntity = contentService
                .getOne((Wrappers.<ContentEntity>lambdaQuery().eq(ContentEntity::getNoticeId, id)));
        if (null != contentEntity) {
            vo.setNoticeContent(contentEntity.getNoticeContent());
        }
        return vo;
    }

    /**
     * 查询公告详情
     * @param id 公告id
     * @return 公告详情
     */
    @Override
    public NoticeVO queryFileDetail(Long id) {
        NoticeEntity noticeEntity = super.selectById(id);
        NoticeVO vo = BeanMapper.map(noticeEntity, NoticeVO.class);
        List<SignEntity> signEntities = signService
                .list(Wrappers.<SignEntity>lambdaQuery().eq(SignEntity::getNoticeId, id)
                        .eq(SignEntity::getTenantId, InvocationInfoProxy.getTenantid()));
        List<SignVO> signVOList = BeanMapper.mapList(signEntities, SignVO.class);
        List<SignVO> signList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(signEntities)) {
            Long sid = signEntities.get(0).getId();
            signVOList.get(0).setsId(sid);
            signList.add(signVOList.get(0));
        }
        vo.setSignList(signList);
        FilecontentEntity filecontentEntity = filecontentService
                .getOne((Wrappers.<FilecontentEntity>lambdaQuery().eq(FilecontentEntity::getNoticeId, id)));
        if (null != filecontentEntity) {
            vo.setContent(filecontentEntity.getContent());
        }

        // 材料招标
        if (CommonUtils.TYPE_MATERIAL.equals(noticeEntity.getType())) {
            this.queryMaterialScheme(noticeEntity, vo);
        }
        // 分包
        else if (CommonUtils.TYPE_SUB.equals(noticeEntity.getType())) {
            this.querySubScheme(noticeEntity, vo);
            if(CollectionUtils.isNotEmpty(vo.getSubDetailList())){
                // 分包取消默认值
                for (SubDetailVO subDetailVO: vo.getSubDetailList()) {
                    subDetailVO.setTenderMny(subDetailVO.getMny());
                    subDetailVO.setTenderTaxMny(subDetailVO.getTaxMny());
                    subDetailVO.setTenderPrice(subDetailVO.getPrice());
                    subDetailVO.setTenderTaxPrice(subDetailVO.getTaxPrice());
                    if(CollectionUtils.isNotEmpty(vo.getSubSchemeList())){
                        for (SubSchemeVO subSchemeVO : vo.getSubSchemeList()) {
                            if(CollectionUtils.isNotEmpty(subSchemeVO.getSubSchemeDetailList())){
                                for (SubSchemeDetailVO subSchemeDetailVO : subSchemeVO.getSubSchemeDetailList()) {
                                    if(null!=subDetailVO.getSourceDetailId() && subDetailVO.getSourceDetailId().equals(subSchemeDetailVO.getSourceDetailId())){
                                        subSchemeDetailVO.setTenderMny(subDetailVO.getMny());
                                        subSchemeDetailVO.setTenderTaxMny(subDetailVO.getTaxMny());
                                        subSchemeDetailVO.setTenderPrice(subDetailVO.getPrice());
                                        subSchemeDetailVO.setTenderTaxPrice(subDetailVO.getTaxPrice());
                                    }
                                }
                            }
                        }
                    }
                    subDetailVO.setMny(null);
                    subDetailVO.setTaxMny(null);
                    subDetailVO.setPrice(null);
                    subDetailVO.setTaxPrice(null);
                }
            }
        }
        // 设备采购
        else if (CommonUtils.TYPE_PURCHASE.equals(noticeEntity.getType())) {
            this.queryPurchaseScheme(noticeEntity, vo);
        }
        // 设备租赁
        else if (CommonUtils.TYPE_RENT.equals(noticeEntity.getType())) {
            this.queryRentScheme(noticeEntity, vo);
        }
        // 周转材租赁
        else if (CommonUtils.TYPE_RMAT.equals(noticeEntity.getType())) {
            this.queryRmatScheme(noticeEntity, vo);
        }
        // 其他
        else if (CommonUtils.TYPE_OTHER.equals(noticeEntity.getType())) {
            this.queryOtherScheme(noticeEntity, vo);
        }
        else {
            logger.error("招标类型不存在[{}]", noticeEntity.getType());
            throw new BusinessException("招标类型不存在");
        }

        //如果是二次报价  需查询招标方 是否已开标
        if(null!=noticeEntity.getTenderType()&&(noticeEntity.getTenderType()==0||noticeEntity.getTenderType()==1) && null!=noticeEntity.getTalkNum()&&noticeEntity.getTalkNum()>0){
            logger.info("二次报价校验开标开始----");
            Integer bidFlag = checkBigFlag(noticeEntity.getSourceId(),noticeEntity.getSystemId());
            logger.info("----设置开标标识"+noticeEntity.getSourceId()+"  :::"+bidFlag);
            vo.setBidFlag(bidFlag);
        }
        return vo;
    }

    /**
     * 查询材料招标报价方案
     *
     * @param noticeEntity 公告实体
     * @param vo           公告vo
     */
    private void queryMaterialScheme(NoticeEntity noticeEntity, NoticeVO vo) {
        //查询方案信息
        List<SchemeEntity> schemeEntityList = schemeService
                .list((Wrappers.<SchemeEntity>lambdaQuery().eq(SchemeEntity::getNoticeId, noticeEntity.getId()))
                        .eq(SchemeEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(SchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(schemeEntityList)) {
            schemeEntityList.forEach(e -> {
                List<SchemeDetailEntity> schemeDetailEntities = null;
                schemeDetailEntities = schemeDetailService.list((Wrappers.<SchemeDetailEntity>lambdaQuery()
                        .eq(SchemeDetailEntity::getSchemeId, e.getId())));
                e.setSchemeDetailList(schemeDetailEntities);
            });
            vo.setSchemeList(BeanMapper.mapList(schemeEntityList, SchemeVO.class));
        }
    }

    /**
     * 查询分包方案信息
     *
     * @param noticeEntity 公告实体
     * @param vo           公告vo
     */
    private void querySubScheme(NoticeEntity noticeEntity, NoticeVO vo) {
        //查询分包方案信息
        List<SubSchemeEntity> subSchemeEntityList = subSchemeService
                .list(Wrappers.<SubSchemeEntity>lambdaQuery().eq(SubSchemeEntity::getNoticeId, noticeEntity.getId())
                        .eq(SubSchemeEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(SubSchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(subSchemeEntityList)) {
            subSchemeEntityList.forEach(e -> {
                List<SubSchemeDetailEntity> subSchemeDetailEntities;
                subSchemeDetailEntities = subSchemeDetailService.list((Wrappers.<SubSchemeDetailEntity>lambdaQuery()
                        .eq(SubSchemeDetailEntity::getSchemeId, e.getId())));
                e.setSubSchemeDetailList(subSchemeDetailEntities);
            });
            vo.setSubSchemeList(BeanMapper.mapList(subSchemeEntityList, SubSchemeVO.class));
        }
    }

    /**
     * 查询设备采购招标报价方案
     *
     * @param noticeEntity 公告实体
     * @param vo           公告vo
     */
    private void queryPurchaseScheme(NoticeEntity noticeEntity, NoticeVO vo) {
        //查询方案信息
        List<PurchaseSchemeEntity> purchaseSchemeEntityList = purchaseSchemeService
                .list((Wrappers.<PurchaseSchemeEntity>lambdaQuery()
                        .eq(PurchaseSchemeEntity::getNoticeId, noticeEntity.getId()))
                        .eq(PurchaseSchemeEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(PurchaseSchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(purchaseSchemeEntityList)) {
            purchaseSchemeEntityList.forEach(e -> {
                List<PurchaseSchemeDetailEntity> purchaseSchemeDetailEntityList = null;
                purchaseSchemeDetailEntityList = purchaseSchemeDetailService
                        .list((Wrappers.<PurchaseSchemeDetailEntity>lambdaQuery()
                                .eq(PurchaseSchemeDetailEntity::getSchemeId, e.getId())));
                e.setPurchaseSchemeDetailList(purchaseSchemeDetailEntityList);
            });
            vo.setPurchaseSchemeList(BeanMapper.mapList(purchaseSchemeEntityList, PurchaseSchemeVO.class));
        }
    }

    /**
     * 查询设备租赁招标报价方案
     *
     * @param noticeEntity 公告实体
     * @param vo           公告vo
     */
    private void queryRentScheme(NoticeEntity noticeEntity, NoticeVO vo) {
        //查询方案信息
        List<RentSchemeEntity> rentSchemeEntityList = rentSchemeService
                .list((Wrappers.<RentSchemeEntity>lambdaQuery()
                        .eq(RentSchemeEntity::getNoticeId, noticeEntity.getId()))
                        .eq(RentSchemeEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(RentSchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(rentSchemeEntityList)) {
            rentSchemeEntityList.forEach(e -> {
                List<RentSchemeDetailEntity> rentSchemeDetailEntityList = null;
                rentSchemeDetailEntityList = rentSchemeDetailService
                        .list((Wrappers.<RentSchemeDetailEntity>lambdaQuery()
                                .eq(RentSchemeDetailEntity::getSchemeId, e.getId())));

                e.setRentSchemeDetailList(rentSchemeDetailEntityList);
            });
            vo.setRentSchemeList(BeanMapper.mapList(rentSchemeEntityList, RentSchemeVO.class));
        }
    }

    /**
     * 查询周转材租赁招标报价方案
     *
     * @param noticeEntity 公告实体
     * @param vo           公告vo
     */
    private void queryRmatScheme(NoticeEntity noticeEntity, NoticeVO vo) {
        //查询方案信息
        List<RmatSchemeEntity> rmatSchemeEntityList = rmatSchemeService
                .list((Wrappers.<RmatSchemeEntity>lambdaQuery()
                        .eq(RmatSchemeEntity::getNoticeId, noticeEntity.getId()))
                        .eq(RmatSchemeEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(RmatSchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(rmatSchemeEntityList)) {
            rmatSchemeEntityList.forEach(e -> {
                List<RmatSchemeDetailEntity> rmatSchemeDetailEntityList = null;
                rmatSchemeDetailEntityList = rmatSchemeDetailService
                        .list((Wrappers.<RmatSchemeDetailEntity>lambdaQuery()
                                .eq(RmatSchemeDetailEntity::getSchemeId, e.getId())));

                e.setRmatSchemeDetailList(rmatSchemeDetailEntityList);
            });
            vo.setRmatSchemeList(BeanMapper.mapList(rmatSchemeEntityList, RmatSchemeVO.class));
        }
        //查询 维修/报废信息
        List<RmatSchemeRepairEntity> rmatSchemeRepairEntityList = rmatSchemeRepairService
                .list((Wrappers.<RmatSchemeRepairEntity>lambdaQuery()
                        .eq(RmatSchemeRepairEntity::getNoticeId, noticeEntity.getId()))
                        .eq(RmatSchemeRepairEntity::getTenantId, InvocationInfoProxy.getTenantid()));
        if (CollectionUtils.isNotEmpty(rmatSchemeRepairEntityList)) {
            //说明之前报过价
            vo.setRmatSchemeRepairList(BeanMapper.mapList(rmatSchemeRepairEntityList,RmatSchemeRepairVO.class));
        }else{
            vo.setRmatSchemeRepairList(new ArrayList<>());
        }

        List<RmatSchemeScrapEntity> rmatSchemeScrapEntityList = rmatSchemeScrapService
                .list((Wrappers.<RmatSchemeScrapEntity>lambdaQuery()
                        .eq(RmatSchemeScrapEntity::getNoticeId, noticeEntity.getId()))
                        .eq(RmatSchemeScrapEntity::getTenantId, InvocationInfoProxy.getTenantid()));
        if (CollectionUtils.isNotEmpty(rmatSchemeScrapEntityList)) {
            vo.setRmatSchemeScrapList(BeanMapper.mapList(rmatSchemeScrapEntityList,RmatSchemeScrapVO.class));
        }else{
            vo.setRmatSchemeScrapList(new ArrayList<>());
        }
    }

    /**
     * 查询其他招标报价方案
     *
     * @param noticeEntity 公告实体
     * @param vo           公告vo
     */
    private void queryOtherScheme(NoticeEntity noticeEntity, NoticeVO vo) {
        //查询方案信息
        List<OtherSchemeEntity> otherSchemeEntityList = otherSchemeService
                .list((Wrappers.<OtherSchemeEntity>lambdaQuery()
                        .eq(OtherSchemeEntity::getNoticeId, noticeEntity.getId()))
                        .eq(OtherSchemeEntity::getTenantId, InvocationInfoProxy.getTenantid())
                        .orderByAsc(OtherSchemeEntity::getSchemeName));
        if (CollectionUtils.isNotEmpty(otherSchemeEntityList)) {
            otherSchemeEntityList.forEach(e -> {
                List<OtherSchemeDetailEntity> otherSchemeDetailEntityList = null;
                otherSchemeDetailEntityList = otherSchemeDetailService
                        .list((Wrappers.<OtherSchemeDetailEntity>lambdaQuery()
                                .eq(OtherSchemeDetailEntity::getSchemeId, e.getId())));

                e.setOtherSchemeDetailList(otherSchemeDetailEntityList);
            });
            vo.setOtherSchemeList(BeanMapper.mapList(otherSchemeEntityList, OtherSchemeVO.class));
        }
    }

    @Override
    public List<NoticeVO> queryInvitationList(QueryWrapper queryWrapper, Integer signStatus, String tenantId) {
        return baseMapper.queryInvitation(queryWrapper, signStatus, tenantId);
    }

    @Override
    public List<NoticeVO> queryAllList(QueryWrapper queryWrapper, String tenantId) {
        return baseMapper.queryAllList(queryWrapper, tenantId);
    }

    /**
     * 查询供方门户招标列表数据
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<NoticeVO> queryHomeList(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("employeeName");
        fuzzyFields.add("employeeMobile");
        fuzzyFields.add("unitName");
        fuzzyFields.add("tenderName");
//        fuzzyFields.add("content");

        // 对查询参数进行处理
        Map<String, Parameter> parameterMap = param.getParams();
        String overFlag = null;
        // 记录需要处理的key，防止循环异常
        List<String> parameterRemoveList = new ArrayList<>();
        if (parameterMap != null && !parameterMap.isEmpty()) {
            for (String key : parameterMap.keySet()) {
                Parameter parameter = parameterMap.get(key);
                Object value = parameter.getValue();
                // 将前端传入的发布时间转换为数据库字段
                if (QUERY_HOME_PUBLISH_TIME.equals(key) && !parameterValueIsNull(value)) {
                    parameterMap.put("create_time", new Parameter(QueryParam.BETWEEN, value));
                    parameterRemoveList.add(key);
                }
                // 倒计时是否结束条件取出
                if (QUERY_HOME_OVER_FLAG.equals(key) && !parameterValueIsNull(value)) {
                    overFlag = value.toString();
                    parameterRemoveList.add(key);
                }
                // 查询参数值是空的则不做查询条件
                if (parameterValueIsNull(value)) {
                    parameterRemoveList.add(key);
                }
            }
            // 对需要处理的key进行处理
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(parameterRemoveList)) {
                parameterRemoveList.forEach(parameterMap::remove);
            }
        }
//        param.getOrderMap().put("create_time", QueryParam.DESC);
        List<Integer> tenderTypeList = new ArrayList<>();
        tenderTypeList.add(0); // 公开
        tenderTypeList.add(2); // 询价

//        List<Integer> tenderTypeOtherList = new ArrayList<>();
//        tenderTypeOtherList.add(1); // 公开
//        tenderTypeOtherList.add(3); // 询价
        // 查询合作企业的systemId
        CommonResponse<List<String>> response = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            logger.error("获取合作企业信息失败！失败原因：{}", response.getMsg());
            throw new BusinessException("获取合作企业信息失败");
        }
        List<String> systemIdList = response.getData();
        logger.info("合作企业信息：{}", systemIdList);
        IPage<NoticeEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(systemIdList)){
            List<NoticeVO> list = baseMapper.queryHomeList(changeToQueryWrapper(param), tenderTypeList,
                    String.valueOf(InvocationInfoProxy.getTenantid()), systemIdList, overFlag, page);
            IPage<NoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(list);
            return pageData;
        }else{
            IPage<NoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            return pageData;
        }
    }

    /**
     * 判断参数是否为空，为空返回true
     *
     * @param obj 判断参数
     * @return null:true,其他：false
     */
    private boolean parameterValueIsNull(Object obj) {
        if (obj == null) return true;
        return org.apache.commons.lang3.StringUtils.isEmpty(obj.toString());
    }

    @Override
    public NumsVO queryCounts() {
        NumsVO numsVO = new NumsVO();
        List<NoticeVO> list = baseMapper.queryCounts(InvocationInfoProxy.getTenantid() + "");
        numsVO.setDbmnums(list.get(0).getNums());
        numsVO.setYbmnums(list.get(1).getNums());
        numsVO.setDbjnums(list.get(2).getNums());
        numsVO.setQstpnums(list.get(3).getNums());
        numsVO.setBjznums(list.get(4).getNums());
        numsVO.setYdbnums(list.get(5).getNums());
        numsVO.setTtnums(list.get(6).getNums());
        return numsVO;
    }

    /**
     * 校验供应商合作企业是否包含该数据，如果招标单位没有与供应商合作，则抛出异常
     *
     * @param systemId 招标单位私有云id
     * @param type     0报名，1报价
     */
    @Override
    public void checkCooperateEnterprise(String systemId, Integer type) {
        logger.info("查询（合作企业）施工方信息，查询参数：tenantId:{}", InvocationInfoProxy.getTenantid());
        CommonResponse<List<String>> cooperateEnterprise = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!cooperateEnterprise.isSuccess()) {
            logger.error("未查询到（合作企业）施工方信息！查询结果：{}，错误信息:{}", cooperateEnterprise.isSuccess(), cooperateEnterprise
                    .getMsg());
//            return CommonResponse.error("查询合作企业失败！");
            throw new BusinessException("查询合作企业失败！");
        }
        List<String> sysDateList = cooperateEnterprise.getData();
        logger.info("查询合作企业结果：{}", JSONObject.toJSONString(sysDateList));
        // 默认没有合作
        boolean flag = true;
        for (String sys : sysDateList) {
            // 如果有合作企业，则不抛异常
            if (sys.equals(systemId)) {
                flag = false;
                break;
            }
        }
        if (flag) {
            String str = "报名";
            if (1 == type) str = "报价";
            throw new BusinessException("很抱歉，您与招标单位没有合作，无法" + str);
        }
    }

    /**
     * 报名报价前进行校验
     *
     * @param inviteId   招标立项id
     * @param supplierId 供应商id
     * @param type       招标类型
     * @param flag       报名报价类型 0报名1报价
     * @param systemId   systemId
     */
    @Override
    public void checkSignOrBj(String inviteId, String supplierId, String type, Integer flag, String systemId) {
        CheckVo checkVo = new CheckVo();
        checkVo.setInviteId(inviteId);
        checkVo.setSupplierId(supplierId);
        checkVo.setType(type);
        checkVo.setFlag(flag);
        String url = "/ejc-tender-web/openapi/check/checkSupplier";
        String postDate = JSONObject.toJSONString(checkVo);
        logger.info("-----开始校验报名资格----");
        logger.info("参数--->>>url:[{}],systemId:[{}],postDate:【{}】", url, systemId, postDate);
        CommonResponse<String> commonResponse = systemDataPushService
                .exchangeDataWithThirdSystem(url, RequestMethod.POST, postDate, systemId);
        logger.info("-----校验报名资格结束----调用结果：{}", commonResponse.isSuccess());
        // 校验返回结果
        CommonUtils.checkCommonResponse(commonResponse, true, null, logger);
    }

    /**
     * 报价前进行校验 获取是否开标
     *
     * @param inviteId   招标立项id
     * @param systemId   systemId
     */
    @Override
    public Integer checkBigFlag(String inviteId,String systemId) {
        CheckVo checkVo = new CheckVo();
        checkVo.setInviteId(inviteId);
        String url = "/ejc-tender-web/openapi/check/checkBidFlag";
        String postDate = JSONObject.toJSONString(checkVo);
        logger.info("-----开始获取二次报价是否开标----");
        logger.info("参数--->>>url:[{}],systemId:[{}],postDate:【{}】", url, systemId, postDate);
        CommonResponse<String> commonResponse = systemDataPushService
                .exchangeDataWithThirdSystem(url, RequestMethod.POST, postDate, systemId);
        logger.info("-----开始获取二次报价是否开标结束----调用结果：{}", commonResponse.isSuccess());
        // 校验返回结果
        CommonUtils.checkCommonResponse(commonResponse, true, null, logger);
        String dataString = JSONObject.toJSONString(commonResponse.getData());
        logger.info("-----是否开标转换后数据----"+dataString);
        JSONObject jsonObject = JSONObject.parseObject(dataString);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(dataString) && jsonObject.containsKey("data")) {
            logger.info("-----是否开标----"+jsonObject.get("data"));
            return Integer.parseInt(jsonObject.get("data").toString());
        }
        return 0; //查不到的情况下 按照0返回
    }

    /**
     * 定时统计公开、询价的招标发送消息
     *
     * @param date 日期
     */
    @Override
    public void timingSendMsg(Date date) {
        if (date == null) date = new Date();
        // 取上一日数据
        Date qDate = DateUtils.calculationDay(date, -1);
        String newDate = DateUtils.transformationDefaultDate(date); // 今天 00:00:00
        String oldDate = DateUtils.transformationDefaultDate(qDate); // 昨天 00:00:00
        QueryWrapper<NoticeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("tender_type", Arrays.asList(0, 2))
                .notIn("abolish_type", Arrays.asList(1, 2))
                .ge("create_time", oldDate)
                .le("create_time", newDate);
        List<NoticeEntity> list = super.list(queryWrapper);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            logger.info("{}至{}之间为查询到符合条件的数据", oldDate, newDate);
            return;
        }
        // 获取systemId列表
//        List<String> systemIdList = list.stream().map(NoticeEntity::getSystemId).distinct()
//                .collect(Collectors.toList());
        Map<String, List<NoticeEntity>> sysNoticeMap = list.stream()
                .collect(Collectors.groupingBy(NoticeEntity::getSystemId));
//        // 测试数据
//        Map<Long, List<Long>> testMap = new HashMap<>();
//        testMap.put(1568118451103154177L, Collections.singletonList(557607478610395209L)); // 郑州益企联
//        testMap.put(1502490641206525953L, Collections.singletonList(1502490641206525956L)); // 北京益企联科技有限公司
//        testMap.put(1524667181896732674L, Collections.singletonList(1524667181896732677L)); // 张三

        // 循环处理
        for (Map.Entry<String, List<NoticeEntity>> entry : sysNoticeMap.entrySet()) {
            String systemId = entry.getKey();
            List<NoticeEntity> sysList = entry.getValue();
            CommonResponse<Map<Long, List<Long>>> commonResponse = cooperateEnterpriseApi
                    .getCooperateSupplierSuperUserIdByEnterpriseId(systemId);
            logger.info("{}查询供应商数据结果：{}", systemId, JSONObject.toJSONString(commonResponse));
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("查询供方列表失败！");
            }
            CommonResponse<EnterpriseVO> enterpriseRes = idmWebEnterpriseApi.getEnterpriseById(Long.valueOf(systemId));
            logger.info("{}查询合作企业信息结果：{}", systemId, JSONObject.toJSONString(enterpriseRes));
            if (!enterpriseRes.isSuccess()) {
                throw new BusinessException("查询合作企业信息失败！");
            }
            EnterpriseVO enterpriseVO = enterpriseRes.getData();
            Map<Long, List<Long>> map = commonResponse.getData();
            try {
                this.sendWeChatMsgByMap(map, 1, WEIXIN_TENDER_MSG_OPEN, sysList, null, enterpriseVO);
            }
            catch (Exception e) {
                logger.info("消息发送失败！失败原因：{}", e.getMessage(), e);
            }
        }
    }

    /**
     * 发送微信消息
     *
     * @param map                   key:租户id，value:用户列表
     * @param tenderType            招标类型，1公开，2邀请（仅发送消息使用，和其他定义的不一致）
     * @param weixinCheckTemplateId 微信消息模板
     * @param list                  公告列表信息（公开招标定时任务使用）
     * @param noticeEntity          公告信息（邀请招标使用）
     * @param enterpriseVO          合作企业信息
     */
    private void sendWeChatMsgByMap(Map<Long, List<Long>> map, Integer tenderType, String weixinCheckTemplateId,
                                    List<NoticeEntity> list, NoticeEntity noticeEntity, EnterpriseVO enterpriseVO) {
        if (CollectionUtils.isEmpty(map)) {
            logger.info("查询信息为空！");
            return;
        }
        logger.info("------开始发送微信消息----");
        logger.info("发送消息数量：{}；发送消息类型（1公开，2邀请）：{}；消息模板：{}", map.size(), tenderType, weixinCheckTemplateId);
        // 循环处理发送消息
        for (Map.Entry<Long, List<Long>> entry : map.entrySet()) {
            Long tenantId = entry.getKey();
            List<Long> userLongList = entry.getValue();
            if (CollectionUtils.isEmpty(userLongList)) {
                logger.info("租户{}下查询用户为空", tenantId);
                continue;
            }
            // 组装标题及内容
            String formurl;
            String subject;
            String content;
            HashMap<String, Object> weixinMap = new HashMap<>();
            String mobileUrl;
            // 公开消息模板
            if (1 == tenderType) {
//                formurl = BASE_HOST + "ejc-supbid-frontend/#/eliminated?id=";
                int X = list.size(); // 新增总数
                String name = enterpriseVO.getName();
                long Y = list.stream().filter(e -> e.getTenderType() == 0).count(); // 公开数量
                long Z = list.stream().filter(e -> e.getTenderType() == 2).count(); // 询价数量

                formurl = "";
                subject = "昨日新增招标信息" + X + "条";
                content = "昨日新增招标信息" + X + "条";
//                        "<a href= '" + formurl + "'" + ">点击查看详情</a>";
                mobileUrl = BASE_HOST+"ejc-supbid-mobile/#/bidSignList?openid={openid}";
                weixinMap.put("first", "昨日新增招标信息" + X + "条"); // 今天新增招标信息X条
                weixinMap.put("keyword1", name); // 供应商合作企业名称
                weixinMap.put("keyword2", DateUtils.transformationDate(new Date(), DateUtils.YYYY_MM_DD_HH_MM_SS)); // 消息发送时间
                weixinMap.put("keyword3", "公开招标" + Y + "条，询价招标" + Z + "条"); // 公开X条，询价招标Y条
                weixinMap.put("remark", "请及时选标"); // 请及时选标

            }
            // 邀请消息模板
            else {
                String projectName = noticeEntity.getProjectName();
                // 单位采购使用orgName
                if (PURCHASE_TYPE_1.equals(noticeEntity.getPurchaseType())) {
                    projectName = noticeEntity.getOrgName();
                }
                String endTimeStr = DateUtils.transformationDate(noticeEntity.getNoticeEndTime(), DateUtils.YYYY_MM_DD_HH_MM_SS);
                formurl = "";
                subject = "您有一条新的邀请招标信息";
                content = "<p>招标名称：" + noticeEntity.getTenderName() + "</p>" +
                        "<p>招标单位：" + noticeEntity.getUnitName() + "</p>" +
                        "<p>招标组织：" + projectName + "</p>" +
                        "<p>报名截止时间：" + endTimeStr + "</p>";
//                        "<a href= '" + formurl + "'" + ">点击查看详情</a>";
                mobileUrl = BASE_HOST+"ejc-supbid-mobile/#/bidSignList/signCard?id="+noticeEntity.getId()+"&openid={openid}";
                weixinMap.put("first", noticeEntity.getTenderName()); // 招标名称
                weixinMap.put("keyword1", 1); // 单据数量
                weixinMap.put("keyword2", endTimeStr); // 报名截止时间
                weixinMap.put("remark", "招标单位：" + noticeEntity.getUnitName() + "；招标组织：" + projectName); // 招标单位;招标组织
            }

            List<String> userList = userLongList.stream().map(String::valueOf).collect(Collectors.toList());

            new SendMsgUtils().sendWeiXinMsg(userList, subject, content, tenantId.toString(),
                    weixinMap, weixinCheckTemplateId, mobileUrl, pushMessageApi);
        }
        logger.info("------发送微信消息结束----");
    }


}
